/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.DDObjectFactory;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.EnvEntryMetaData;
import org.jboss.metadata.IconMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.QueryMetaData;
import org.jboss.metadata.RelationMetaData;
import org.jboss.metadata.RelationshipRoleMetaData;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class EjbJarObjectFactory
extends DDObjectFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger(EjbJarObjectFactory.class);
    private int ejbVersion = 2;
    private int ejbMinorVersion = 0;

    public void startDTD(String name, String publicId, String systemId) {
        if (publicId.startsWith("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0")) {
            this.ejbVersion = 2;
        } else if (publicId.startsWith("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1")) {
            this.ejbVersion = 1;
        }
    }

    public ApplicationMetaData newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        ApplicationMetaData metaData = null;
        metaData = root != null ? (ApplicationMetaData)root : new ApplicationMetaData();
        String version = attrs.getValue(namespaceURI, "version");
        if (version == null) {
            version = attrs.getValue("", "version");
        }
        if (version != null && version.equals("3.0")) {
            metaData.setEjbVersion(3);
            metaData.setEjbMinorVersion(0);
            this.ejbVersion = 3;
            this.ejbMinorVersion = 0;
        }
        return metaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(ApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        String version = attrs.getValue(namespaceURI, "version");
        if (version != null) {
            if (version.equals("2.1")) {
                dd.setEjbVersion(2);
                dd.setEjbMinorVersion(1);
            }
        } else {
            dd.setEjbVersion(this.ejbVersion);
            dd.setEjbMinorVersion(this.ejbMinorVersion);
        }
        if (localName.equals("enterprise-beans")) {
            child = dd;
        } else if (localName.equals("entity")) {
            child = new EntityMetaData(dd);
        } else if (localName.equals("session")) {
            child = new SessionMetaData(dd);
        } else if (localName.equals("message-driven")) {
            child = new MessageDrivenMetaData(dd);
        } else if (localName.equals("relationships")) {
            child = dd;
        } else if (localName.equals("ejb-relation")) {
            child = new RelationMetaData();
        } else if (localName.equals("assembly-descriptor")) {
            child = new AssemblyDescriptor(dd);
        } else if (localName.equals("icon")) {
            child = new IconMetaData();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring: " + localName);
        }
        return child;
    }

    public Object newChild(EntityMetaData entity, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("security-role-ref")) {
            child = new SecurityRoleRefMetaData();
        } else if (localName.equals("security-identity")) {
            child = new SecurityIdentityMetaData();
        } else if (localName.equals("cmp-field")) {
            child = new CMPFieldMetaData();
        } else if (localName.equals("query")) {
            child = new QueryMetaData();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring child of entity: " + localName);
        }
        return child;
    }

    public Object newChild(MessageDrivenMetaData mdb, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("security-identity")) {
            child = new SecurityIdentityMetaData();
        } else if (localName.equals("message-driven-destination")) {
            child = mdb;
        } else if (localName.equals("activation-config")) {
            child = mdb;
        } else if (localName.equals("activation-config-property")) {
            child = new ActivationConfigPropertyMetaData();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring child of message-driven: " + localName);
        }
        return child;
    }

    public Object newChild(SessionMetaData session, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("security-identity")) {
            child = new SecurityIdentityMetaData();
        } else if (localName.equals("security-role-ref")) {
            child = new SecurityRoleRefMetaData();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring child of session: " + localName);
        }
        return child;
    }

    public Object newChild(RelationMetaData relation, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        RelationshipRoleMetaData child = null;
        if (localName.equals("ejb-relationship-role")) {
            child = new RelationshipRoleMetaData(relation);
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring child of relation: " + localName);
        }
        return child;
    }

    public Object newChild(RelationshipRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        RelationshipRoleMetaData child = null;
        if (localName.equals("cascade-delete")) {
            role.setCascadeDelete(true);
        } else if (localName.equals("relationship-role-source") || localName.equals("cmr-field")) {
            child = role;
        }
        return child;
    }

    public Object newChild(AssemblyDescriptor ad, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("security-role")) {
            return ad;
        }
        if (localName.equals("method-permission")) {
            return new MethodPermission(ad);
        }
        if (localName.equals("container-transaction")) {
            return new ContainerTransaction();
        }
        if (localName.equals("exclude-list")) {
            return ad;
        }
        if (localName.equals("method")) {
            MethodMetaData method = new MethodMetaData();
            method.setExcluded();
            return method;
        }
        if (localName.equals("message-destination")) {
            MessageDestinationMetaData mdmd = new MessageDestinationMetaData();
            return mdmd;
        }
        return null;
    }

    public Object newChild(MethodMetaData method, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("method") || localName.equals("method-params")) {
            return method;
        }
        if (localName.equals("unchecked")) {
            method.setUnchecked();
        }
        return null;
    }

    public Object newChild(QueryMetaData query, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("query-method") || localName.equals("method-params")) {
            return query;
        }
        return null;
    }

    public Object newChild(SecurityIdentityMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("run-as")) {
            return parent;
        }
        if (localName.equals("use-caller-identity")) {
            parent.setUseCallerIdentity(true);
        }
        return null;
    }

    public Object newChild(MethodPermission parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("method")) {
            return new MethodMetaData();
        }
        return null;
    }

    public Object newChild(ContainerTransaction parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("method")) {
            MethodMetaData method = new MethodMetaData();
            parent.methods.add(method);
            return method;
        }
        return null;
    }

    public void addChild(ApplicationMetaData parent, EntityMetaData entity, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (parent.isEJB1x() && entity.isCMP()) {
            entity.setCmpVersion(1);
        }
        parent.addBeanMetaData(entity);
    }

    public void addChild(ApplicationMetaData parent, SessionMetaData session, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addBeanMetaData(session);
    }

    public void addChild(ApplicationMetaData parent, MessageDrivenMetaData mdb, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addBeanMetaData(mdb);
    }

    public void addChild(ApplicationMetaData parent, RelationMetaData relation, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (relation.getRelationName() == null) {
            relation.setDefaultRelationName();
        }
        parent.addRelationship(relation);
    }

    public void addChild(EntityMetaData parent, SecurityIdentityMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setSecurityIdentityMetaData(child);
    }

    public void addChild(EntityMetaData parent, SecurityRoleRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRoleReference(child);
    }

    public void addChild(EntityMetaData parent, CMPFieldMetaData field, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.getCmpFields().add(field.name);
    }

    public void addChild(EntityMetaData parent, QueryMetaData query, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addQuery(query);
    }

    public void addChild(EntityMetaData parent, EjbLocalRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbLocalReference(child);
    }

    public void addChild(EntityMetaData parent, EjbRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbReference(child);
    }

    public void addChild(EntityMetaData parent, ResourceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceReference(child);
    }

    public void addChild(EntityMetaData parent, ResourceEnvRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceEnvReference(child);
    }

    public void addChild(EntityMetaData parent, EnvEntryMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvironmentEntry(child);
    }

    public void addChild(EntityMetaData parent, MessageDestinationRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMessageDestinationReference(child);
    }

    public void addChild(EntityMetaData parent, ServiceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServiceRef(child);
    }

    public void addChild(SessionMetaData parent, SecurityIdentityMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setSecurityIdentityMetaData(child);
    }

    public void addChild(SessionMetaData parent, SecurityRoleRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addSecurityRoleReference(child);
    }

    public void addChild(SessionMetaData parent, EjbLocalRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbLocalReference(child);
    }

    public void addChild(SessionMetaData parent, EjbRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbReference(child);
    }

    public void addChild(SessionMetaData parent, ResourceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceReference(child);
    }

    public void addChild(SessionMetaData parent, ResourceEnvRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceEnvReference(child);
    }

    public void addChild(SessionMetaData parent, EnvEntryMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvironmentEntry(child);
    }

    public void addChild(SessionMetaData parent, MessageDestinationRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMessageDestinationReference(child);
    }

    public void addChild(SessionMetaData parent, ServiceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServiceRef(child);
    }

    public void addChild(RelationMetaData relation, RelationshipRoleMetaData role, UnmarshallingContext ctx, String namespaceURI, String localName) {
        if (role.getRelationshipRoleName() == null) {
            role.setRelationshipRoleName(role.getEntityName() + (role.getCMRFieldName() == null ? "" : "_" + role.getCMRFieldName()));
        }
        if (relation.getLeftRelationshipRole() == null) {
            relation.setLeftRelationshipRole(role);
        } else {
            relation.setRightRelationshipRole(role);
        }
    }

    public void addChild(AssemblyDescriptor ad, MessageDestinationMetaData mdmd, UnmarshallingContext ctx, String namespaceURI, String localName) {
        ad.app.getAssemblyDescriptor().addMessageDestinationMetaData(mdmd);
    }

    public void addChild(AssemblyDescriptor parent, ContainerTransaction child, UnmarshallingContext ctx, String namespaceURI, String localName) {
        for (int i = 0; i < child.methods.size(); ++i) {
            MethodMetaData method = (MethodMetaData)child.methods.get(i);
            BeanMetaData bean = this.getBeanForMethod(parent, method);
            method.setTransactionType(child.transAttr);
            bean.addTransactionMethod(method);
        }
    }

    public void addChild(AssemblyDescriptor parent, MethodMetaData child, UnmarshallingContext ctx, String namespaceURI, String localName) {
        try {
            BeanMetaData bean = this.getBeanForMethod(parent, child);
            bean.addExcludedMethod(child);
        }
        catch (IllegalStateException igored) {
            // empty catch block
        }
    }

    public void addChild(MessageDrivenMetaData parent, SecurityIdentityMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setSecurityIdentityMetaData(child);
    }

    public void addChild(MessageDrivenMetaData mdb, ActivationConfigPropertyMetaData child, UnmarshallingContext ctx, String namespaceURI, String localName) {
        mdb.getActivationConfigProperties().put(child.getName(), child);
    }

    public void addChild(MessageDrivenMetaData parent, EjbLocalRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbLocalReference(child);
    }

    public void addChild(MessageDrivenMetaData parent, EjbRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEjbReference(child);
    }

    public void addChild(MessageDrivenMetaData parent, ResourceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceReference(child);
    }

    public void addChild(MessageDrivenMetaData parent, ResourceEnvRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addResourceEnvReference(child);
    }

    public void addChild(MessageDrivenMetaData parent, EnvEntryMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvironmentEntry(child);
    }

    public void addChild(MessageDrivenMetaData parent, MessageDestinationRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addMessageDestinationReference(child);
    }

    public void addChild(MessageDrivenMetaData parent, ServiceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addServiceRef(child);
    }

    public void addChild(MethodPermission parent, MethodMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        BeanMetaData bean = this.getBeanForMethod(parent.ad, child);
        if (parent.roles == null) {
            child.setUnchecked();
        } else {
            child.getRoles().addAll(parent.roles);
        }
        bean.addPermissionMethod(child);
    }

    public void setValue(ApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("display-name")) {
            dd.setDisplayName(value);
        } else if (localName.equals("description")) {
            dd.setDescription(value);
        } else if (localName.equals("ejb-client-jar")) {
            dd.setClientJar(value);
        }
    }

    public void setValue(EntityMetaData entity, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("display-name")) {
            entity.setDisplayName(value);
        } else if (localName.equals("description")) {
            entity.setDescription(value);
        } else if (localName.equals("ejb-name")) {
            entity.setEjbName(value);
        } else if (localName.equals("home")) {
            entity.setHome(value);
        } else if (localName.equals("remote")) {
            entity.setRemote(value);
        } else if (localName.equals("local-home")) {
            entity.setLocalHome(value);
        } else if (localName.equals("local")) {
            entity.setLocal(value);
        } else if (localName.equals("ejb-class")) {
            entity.setEjbClass(value);
        } else if (localName.equals("persistence-type")) {
            boolean cmp = false;
            if (value.equals("Bean")) {
                cmp = false;
            } else if (value.equals("Container")) {
                cmp = true;
            } else {
                throw new IllegalStateException(entity.getEjbName() + ": " + "persistence-type must be 'Bean' or 'Container'!");
            }
            entity.setCmp(cmp);
        } else if (localName.equals("prim-key-class")) {
            entity.setPrimaryKeyClass(value);
        } else if (localName.equals("reentrant")) {
            boolean flag = Boolean.valueOf(value);
            entity.setReentrant(flag);
        } else if (localName.equals("cmp-version")) {
            int cmpVersion = 2;
            if ("1.x".equals(value)) {
                cmpVersion = 1;
            } else if ("2.x".equals(value)) {
                cmpVersion = 2;
            }
            entity.setCmpVersion(cmpVersion);
        } else if (localName.equals("abstract-schema-name")) {
            entity.setAbstractSchemaName(value);
        } else if (localName.equals("primkey-field")) {
            entity.setPrimKeyField(value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(SessionMetaData bean, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("display-name")) {
            bean.setDisplayName(value);
            return;
        } else if (localName.equals("description")) {
            bean.setDescription(value);
            return;
        } else if (localName.equals("ejb-name")) {
            bean.setEjbName(value);
            return;
        } else if (localName.equals("home")) {
            bean.setHome(value);
            return;
        } else if (localName.equals("remote")) {
            bean.setRemote(value);
            return;
        } else if (localName.equals("local-home")) {
            bean.setLocalHome(value);
            return;
        } else if (localName.equals("local")) {
            bean.setLocal(value);
            return;
        } else if (localName.equals("ejb-class")) {
            bean.setEjbClass(value);
            return;
        } else if (localName.equals("service-endpoint")) {
            bean.setServiceEndpointClass(value);
            return;
        } else if (localName.equals("session-type")) {
            if (value.equals("Stateful")) {
                bean.setStateful(true);
                return;
            } else {
                if (!value.equals("Stateless")) throw new IllegalStateException(bean.getEjbName() + ": " + "session-type must be 'Stateful' or 'Stateless' but was " + value);
                bean.setStateful(false);
            }
            return;
        } else {
            if (!localName.equals("transaction-type")) return;
            if ("Bean".equals(value)) {
                bean.setContainerManagedTx(false);
                return;
            } else {
                if (!"Container".equals(value)) throw new IllegalStateException("Unexpected value for transaction-type: " + value);
                bean.setContainerManagedTx(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(MessageDrivenMetaData mdb, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("display-name")) {
            mdb.setDisplayName(value);
            return;
        } else if (localName.equals("description")) {
            mdb.setDescription(value);
            return;
        } else if (localName.equals("ejb-name")) {
            mdb.setEjbName(value);
            return;
        } else if (localName.equals("ejb-class")) {
            mdb.setEjbClass(value);
            return;
        } else if (localName.equals("transaction-type")) {
            if ("Bean".equals(value)) {
                mdb.setContainerManagedTx(false);
                return;
            } else {
                if (!"Container".equals(value)) throw new IllegalStateException("Unexpected value for transaction-type: " + value);
                mdb.setContainerManagedTx(true);
            }
            return;
        } else if (localName.equals("message-selector")) {
            mdb.setMessageSelector(value);
            return;
        } else if (localName.equals("messaging-type")) {
            mdb.setMessagingType(value);
            return;
        } else if (localName.equals("message-destination-type") || localName.equals("destination-type")) {
            mdb.setDestinationType(value);
            return;
        } else if (localName.equals("message-destination-type")) {
            mdb.setDestinationType(value);
            return;
        } else if (localName.equals("message-destination-link")) {
            mdb.setDestinationLink(value);
            return;
        } else if (localName.equals("acknowledge-mode")) {
            mdb.setAcknowledgeMode(value);
            return;
        } else {
            if (!localName.equals("subscription-durability")) return;
            mdb.setSubscriptionDurability(value);
        }
    }

    public void setValue(IconMetaData icon, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("small-icon")) {
            icon.setSmallIcon(value);
        }
        if (localName.equals("large-icon")) {
            icon.setLargeIcon(value);
        }
    }

    public void setValue(RelationMetaData relation, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("description")) {
            relation.setDescription(value);
        } else if (localName.equals("display-name")) {
            relation.setDisplayName(value);
        } else if (localName.equals("ejb-relation-name")) {
            relation.setRelationName(value);
        } else if (localName.equals("ejb-relation-name")) {
            relation.setRelationName(value);
        }
    }

    public void setValue(RelationshipRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("ejb-relationship-role-name")) {
            role.setRelationshipRoleName(value);
        } else if (localName.equals("multiplicity")) {
            role.setMultiplicity(value);
        } else if (localName.equals("ejb-name")) {
            role.setEntityName(value);
        } else if (localName.equals("cmr-field-name")) {
            role.setCmrFieldName(value);
        } else if (localName.equals("cmr-field-type")) {
            role.setCmrFieldType(value);
        }
    }

    public void setValue(CMPFieldMetaData field, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("field-name")) {
            field.name = value;
        }
    }

    public void setValue(AssemblyDescriptor ad, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            ad.app.getAssemblyDescriptor().addSecurityRoleMetaData(new SecurityRoleMetaData(value));
        }
    }

    public void setValue(MethodPermission method, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            method.addRole(value);
        }
    }

    public void setValue(ContainerTransaction parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("trans-attribute")) {
            parent.transAttr = MethodMetaData.getTransactionAttribute(value);
        }
    }

    public void setValue(MethodMetaData method, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("ejb-name")) {
            method.setEjbName(value);
        } else if (localName.equals("method-intf")) {
            method.setInterfaceType(value);
        } else if (localName.equals("method-name")) {
            method.setMethodName(value);
        } else if (localName.equals("method-param")) {
            method.addParam(value);
        }
    }

    public void setValue(QueryMetaData query, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("result-type-mapping")) {
            query.setResultTypeMapping(value);
        } else if (localName.equals("ejb-ql")) {
            query.setEjbQl(value);
        } else if (localName.equals("method-name")) {
            query.setMethodName(value);
        } else if (localName.equals("method-param")) {
            query.addMethodParam(value);
        }
    }

    public void setValue(ActivationConfigPropertyMetaData prop, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("activation-config-property-name")) {
            prop.setName(value);
        } else if (localName.equals("activation-config-property-value")) {
            prop.setValue(value);
        }
    }

    public void setValue(SecurityIdentityMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            parent.setRunAsRoleName(value);
        }
    }

    public void setValue(SecurityRoleRefMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            parent.setName(value);
        } else if (localName.equals("role-link")) {
            parent.setLink(value);
        }
    }

    public void setValue(MessageDestinationMetaData mdmd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("message-destination-name")) {
            mdmd.setName(value);
        }
    }

    private BeanMetaData getBeanForMethod(AssemblyDescriptor parent, MethodMetaData child) {
        if (child.getEjbName() == null) {
            throw new IllegalStateException("Method permission without ejb-name!");
        }
        BeanMetaData bean = parent.app.getBeanByEjbName(child.getEjbName());
        if (bean == null) {
            throw new IllegalStateException("Bean " + child.getEjbName() + " not found in the application.");
        }
        return bean;
    }

    public static class ContainerTransaction {
        List methods = new ArrayList();
        byte transAttr;
    }

    public static class MethodPermission {
        AssemblyDescriptor ad;
        List roles;

        public MethodPermission(AssemblyDescriptor ad) {
            this.ad = ad;
        }

        void addRole(String role) {
            if (this.roles == null) {
                this.roles = new ArrayList();
            }
            this.roles.add(role);
        }
    }

    public static class AssemblyDescriptor {
        ApplicationMetaData app;

        public AssemblyDescriptor(ApplicationMetaData app) {
            this.app = app;
        }
    }

    public static class CMPFieldMetaData {
        String name;
    }
}

