/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.logging.Logger;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class JBossApplicationObjectFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger(JBossApplicationObjectFactory.class);
    private static ThreadLocal<J2eeApplicationMetaData> activeMetaData = new ThreadLocal();

    public J2eeApplicationMetaData newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        J2eeApplicationMetaData metaData = null;
        metaData = root != null ? (J2eeApplicationMetaData)root : new J2eeApplicationMetaData();
        activeMetaData.set(metaData);
        return metaData;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        activeMetaData.set(null);
        return root;
    }

    public Object newChild(J2eeApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        log.debug("newChild, " + localName);
        if (localName.equals("module")) {
            child = new J2eeModuleMetaData();
        } else if (localName.equals("security-role")) {
            child = new SecurityRoleMetaData();
        } else if (localName.equals("loader-repository")) {
            child = new LoaderRepositoryFactory.LoaderRepositoryConfig();
        } else if (log.isTraceEnabled()) {
            log.trace("Ignoring: " + localName);
        }
        return child;
    }

    public void setValue(J2eeModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("service")) {
            module.setType(4);
            module.setFileName(value);
        } else if (localName.equals("har")) {
            module.setType(5);
            module.setFileName(value);
        } else if (localName.equals("web-uri")) {
            module.setType(1);
            module.setFileName(value);
        } else if (localName.equals("context-root")) {
            module.setType(1);
            module.setWebContext(value);
        }
    }

    public void addChild(J2eeApplicationMetaData parent, J2eeModuleMetaData module, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addModule(module);
    }

    public void addChild(J2eeApplicationMetaData parent, LoaderRepositoryFactory.LoaderRepositoryConfig cfg, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setLoaderCfg(cfg);
    }

    public void setValue(J2eeApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("security-domain")) {
            dd.setSecurityDomain(value);
        } else if (localName.equals("unauthenticated-principal")) {
            dd.setUnauthenticatedPrincipal(value);
        } else if (localName.equals("jmx-name")) {
            dd.setJMXName(value);
        }
    }

    public void setValue(SecurityRoleMetaData role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            role.setRoleName(value);
        } else if (localName.equals("principal-name")) {
            J2eeApplicationMetaData metaData = activeMetaData.get();
            SecurityRoleMetaData srmd = metaData.getSecurityRole(role.getRoleName());
            if (srmd == null) {
                srmd = new SecurityRoleMetaData();
                srmd.setRoleName(role.getRoleName());
                metaData.addSecurityRole(srmd);
            }
            srmd.addPrincipalName(value);
        }
    }

    public void setValue(LoaderRepositoryFactory.LoaderRepositoryConfig cfg, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("loader-repository")) {
            cfg.repositoryName = ObjectNameFactory.create(value);
        } else if (localName.equals("loader-repository-config")) {
            cfg.repositoryConfig = value;
        }
    }
}

