/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.CacheInvalidationConfigMetaData;
import org.jboss.metadata.ClusterConfigMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.DDObjectFactory;
import org.jboss.metadata.EjbLocalRefMetaData;
import org.jboss.metadata.EjbPortComponentMetaData;
import org.jboss.metadata.EjbRefMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.jboss.metadata.MessageDestinationMetaData;
import org.jboss.metadata.MessageDestinationRefMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MethodAttributes;
import org.jboss.metadata.ResourceEnvRefMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.metadata.SecurityRoleMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.ws.integration.ServiceRefMetaData;
import org.jboss.xb.binding.UnmarshallingContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class JBossEjbObjectFactory
extends DDObjectFactory {
    private static DocumentBuilder DOC_BUILDER;
    private ApplicationMetaData appMetaData;

    public JBossEjbObjectFactory(ApplicationMetaData dd) {
        this.appMetaData = dd;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (root == null && this.appMetaData == null) {
            throw new IllegalStateException("No existing ApplicationMetaData, check the JBossEjbObjectFactory order");
        }
        return root == null ? this.appMetaData : root;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        ApplicationMetaData app = (ApplicationMetaData)root;
        if (app.getUnauthenticatedPrincipal() == null) {
            app.setDefaultUnauthenticatedPrincipal();
        }
        return root;
    }

    public Object newChild(ApplicationMetaData dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        if (!localName.equals("loader-repository")) {
            if (localName.equals("invoker-proxy-bindings")) {
                child = dd;
            } else if (localName.equals("invoker-proxy-binding")) {
                child = new InvokerProxyBindingMetaData();
            } else if (localName.equals("container-configurations")) {
                child = dd;
            } else if (localName.equals("container-configuration")) {
                int extendsIndex = attrs.getIndex("extends");
                if (extendsIndex != -1) {
                    String extendName = attrs.getValue(extendsIndex);
                    ConfigurationMetaData extendConfig = dd.getConfigurationMetaDataByName(extendName);
                    if (extendConfig == null) {
                        throw new IllegalStateException("Parent container configuration couldn't be found: " + extendName);
                    }
                    child = new ConfigurationHolder(dd, (ConfigurationMetaData)extendConfig.clone());
                } else {
                    child = new ConfigurationHolder(dd, new ConfigurationMetaData());
                }
            } else if (localName.equals("webservices")) {
                child = new ApplicationMetaData.Webservices();
            } else if (localName.equals("enterprise-beans")) {
                child = dd;
            } else if (localName.equals("entity") || localName.equals("session") || localName.equals("message-driven")) {
                child = new BeanHolder();
            } else if (localName.equals("resource-managers")) {
                child = dd;
            } else if (localName.equals("resource-manager")) {
                child = new ResourceManagerMetaData();
            } else if (localName.equals("assembly-descriptor")) {
                child = dd.getAssemblyDescriptor();
            }
        }
        return child;
    }

    public Object newChild(BeanHolder bean, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("invoker-bindings")) {
            child = bean;
        } else if (localName.equals("invoker")) {
            child = new InvokerMetaData(bean.metaData);
        } else if (localName.equals("security-identity")) {
            child = bean.metaData.getSecurityIdentityMetaData();
            if (child == null) {
                throw new IllegalStateException("security-identity in jboss.xml has no match in ejb-jar.xml for " + bean.metaData.getEjbName());
            }
        } else if (localName.equals("ejb-timeout-identity")) {
            child = new SecurityIdentityMetaData();
        } else if (localName.equals("method-attributes")) {
            child = bean;
        } else if (localName.equals("method")) {
            child = new MethodAttributes();
        } else if (localName.equals("cluster-config")) {
            ClusterConfigMetaData cc = new ClusterConfigMetaData();
            cc.init(bean.metaData);
        } else if (localName.equals("ior-security-config")) {
            child = new IorSecurityConfigMetaData();
        } else if (localName.equals("cache-invalidation-config")) {
            CacheInvalidationConfigMetaData config = new CacheInvalidationConfigMetaData();
            config.init(bean.metaData);
            child = config;
        } else if (localName.equals("port-component")) {
            child = new EjbPortComponentMetaData((SessionMetaData)bean.metaData);
        } else if (localName.equals("activation-config")) {
            child = bean;
        } else if (localName.equals("activation-config-property")) {
            return new ActivationConfigPropertyMetaData();
        }
        return child;
    }

    public Object newChild(InvokerProxyBindingMetaData md, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        DomElement child = null;
        if (localName.equals("proxy-factory-config")) {
            child = new DomElement(JBossEjbObjectFactory.newDomElement(localName, attrs));
        }
        return child;
    }

    public Object newChild(ConfigurationHolder md, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        if (localName.equals("cluster-config")) {
            child = new ClusterConfigMetaData();
        } else if (localName.equals("container-interceptors") || localName.equals("container-cache-conf") || localName.equals("container-pool-conf")) {
            child = new DomElement(JBossEjbObjectFactory.newDomElement(localName, attrs));
        } else if (localName.equals("security-domain")) {
            child = md;
            md.getConfiguration().setSecurityDomain("");
        }
        return child;
    }

    public Object newChild(DomElement dom, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Element child = dom.element.getOwnerDocument().createElement(localName);
        JBossEjbObjectFactory.addAttributes(child, attrs);
        return new DomElement(child);
    }

    public Object newChild(InvokerMetaData invoker, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("ejb-ref")) {
            return new InvokerMetaData.EjbRef();
        }
        return null;
    }

    public Object newChild(IorSecurityConfigMetaData invoker, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("transport-config")) {
            return new IorSecurityConfigMetaData.TransportConfig();
        }
        if (localName.equals("as-context")) {
            return new IorSecurityConfigMetaData.AsContext();
        }
        if (localName.equals("sas-context")) {
            return new IorSecurityConfigMetaData.SasContext();
        }
        return null;
    }

    public Object newChild(AssemblyDescriptorMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        if (localName.equals("security-role")) {
            return new SecurityRoleMetaData();
        }
        if (localName.equals("message-destination")) {
            return new MessageDestinationMetaData();
        }
        return null;
    }

    public Object newChild(ApplicationMetaData.Webservices parent, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        ApplicationMetaData.WebserviceDescription child = null;
        if (localName.equals("webservice-description")) {
            child = new ApplicationMetaData.WebserviceDescription();
        }
        return child;
    }

    public void addChild(ApplicationMetaData parent, InvokerProxyBindingMetaData binding, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addInvokerProxyBinding(binding);
    }

    public void addChild(ApplicationMetaData parent, ConfigurationHolder container, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addContainerConfiguration(container.getConfiguration());
    }

    public void addChild(ApplicationMetaData parent, ResourceManagerMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (child.jndiName != null) {
            parent.mapResource(child.resName, child.jndiName);
        } else if (child.url != null) {
            parent.mapResource(child.resName, child.url);
        } else {
            throw new IllegalStateException(child.resName + " : expected res-url or res-jndi-name tag");
        }
    }

    public void addChild(ApplicationMetaData parent, ApplicationMetaData.Webservices child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setWebservices(child);
    }

    public void addChild(ApplicationMetaData.Webservices parent, ApplicationMetaData.WebserviceDescription child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.getWebserviceDescriptions().add(child);
    }

    public void addChild(ConfigurationHolder parent, ClusterConfigMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.getConfiguration().setClusterConfig(child);
    }

    public void addChild(ConfigurationHolder parent, DomElement child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (localName.equals("container-interceptors")) {
            parent.getConfiguration().setContainerInterceptorsConf(child.element);
        } else if (localName.equals("container-cache-conf")) {
            parent.getConfiguration().setContainerCacheConf(child.element);
        } else if (localName.equals("container-pool-conf")) {
            parent.getConfiguration().setContainerPoolConf(child.element);
        }
    }

    public void addChild(InvokerProxyBindingMetaData parent, DomElement domElement, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (localName.equals("proxy-factory-config")) {
            parent.setProxyFactoryConfig(domElement.element);
        }
    }

    public void addChild(DomElement parent, DomElement child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.element.appendChild(child.element);
    }

    public void addChild(BeanHolder parent, InvokerMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        String jndiName = child.jndiName;
        if (jndiName == null) {
            jndiName = parent.metaData.getJndiName();
        }
        parent.metaData.addInvokerBinding(child.bindingName, jndiName);
    }

    public void addChild(BeanHolder parent, SecurityIdentityMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        if (localName.equals("ejb-timeout-identity")) {
            child.setRunAsRoleName("ejbTimeout");
            if (child.getRunAsPrincipalName() == null) {
                child.getUseCallerIdentity();
            }
            parent.metaData.setEjbTimeoutIdentity(child);
        }
    }

    public void addChild(BeanHolder parent, MethodAttributes child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.metaData.getMethodAttributes().add(child);
    }

    public void addChild(BeanHolder parent, ClusterConfigMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.metaData.setClusterConfig(child);
    }

    public void addChild(BeanHolder parent, IorSecurityConfigMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.metaData.setIorSecurityConfig(child);
    }

    public void addChild(BeanHolder parent, CacheInvalidationConfigMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        ((EntityMetaData)parent.metaData).setCacheInvalidConfig(child);
    }

    public void addChild(BeanHolder parent, EjbPortComponentMetaData pcMetaData, UnmarshallingContext navigator, String namespaceURI, String localName) {
        SessionMetaData sessionMetaData = (SessionMetaData)parent.metaData;
        sessionMetaData.setPortComponent(pcMetaData);
    }

    public void addChild(BeanHolder parent, ActivationConfigPropertyMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        ((MessageDrivenMetaData)parent.metaData).getActivationConfigProperties().put(child.getName(), child);
    }

    public void addChild(BeanHolder parent, EjbLocalRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        EjbLocalRefMetaData ref = parent.metaData.getEjbLocalRefByName(child.getName());
        if (ref == null) {
            throw new IllegalStateException("ejb-local-ref " + child.getName() + " found in jboss.xml in ejb " + parent.metaData.getEjbName() + " could not be found in the ejb-jar.xml");
        }
        ref.setJndiName(child.getJndiName());
    }

    public void addChild(BeanHolder parent, EjbRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        EjbRefMetaData ref = parent.metaData.getEjbRefByName(child.getName());
        if (ref == null) {
            throw new IllegalStateException("ejb-ref " + child.getName() + " found in jboss.xml in ejb " + parent.metaData.getEjbName() + " could not be found in the ejb-jar.xml");
        }
        ref.setJndiName(child.getJndiName());
    }

    public void addChild(BeanHolder parent, ResourceRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        ResourceRefMetaData ref = parent.metaData.getResourceReference(child.getRefName());
        if (ref == null) {
            throw new IllegalStateException("resource-ref " + child.getRefName() + " found in jboss.xml in ejb " + parent.metaData.getEjbName() + " could not be found in the ejb-jar.xml");
        }
        ref.setName(child.getName());
        ref.setJndiName(child.getJndiName());
        ref.setResURL(child.getResURL());
    }

    public void addChild(BeanHolder parent, ResourceEnvRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        ResourceEnvRefMetaData ref = parent.metaData.getResourceEnvReference(child.getRefName());
        if (ref == null) {
            throw new IllegalStateException("resource-env-ref " + child.getRefName() + " found in jboss.xml in ejb " + parent.metaData.getEjbName() + " could not be found in the ejb-jar.xml");
        }
        ref.setJndiName(child.getJndiName());
    }

    public void addChild(BeanHolder parent, MessageDestinationRefMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        MessageDestinationRefMetaData ref = parent.metaData.getMessageDestinationReference(child.getRefName());
        if (ref == null) {
            throw new IllegalStateException("message-destination-ref " + child.getRefName() + " found in jboss.xml in ejb " + parent.metaData.getEjbName() + " could not be found in the ejb-jar.xml");
        }
        ref.setJndiName(child.getJndiName());
    }

    public void addChild(BeanHolder parent, ServiceRefMetaData sref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        String refName = sref.getServiceRefName();
        if (refName == null) {
            throw new IllegalStateException("Invalid service-ref-name: " + refName);
        }
        ServiceRefMetaData targetRef = parent.metaData.getServiceRef(refName);
        if (targetRef == null) {
            this.log.debug("Cannot find <service-ref> with name: " + refName);
            parent.metaData.addServiceRef(sref);
        } else {
            targetRef.merge(sref);
        }
    }

    public void addChild(InvokerMetaData parent, InvokerMetaData.EjbRef child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        EjbRefMetaData ejbRef = parent.bean.getEjbRefByName(child.ejbRefName);
        if (ejbRef == null) {
            throw new IllegalStateException("ejb-ref " + child.ejbRefName + " found in jboss.xml but not in ejb-jar.xml");
        }
        ejbRef.addInvokerBinding(parent.bindingName, child.jndiName);
    }

    public void addChild(IorSecurityConfigMetaData parent, IorSecurityConfigMetaData.TransportConfig child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setTransportConfig(child);
    }

    public void addChild(IorSecurityConfigMetaData parent, IorSecurityConfigMetaData.AsContext child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setAsContext(child);
    }

    public void addChild(IorSecurityConfigMetaData parent, IorSecurityConfigMetaData.SasContext child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setSasContext(child);
    }

    public void addChild(AssemblyDescriptorMetaData parent, SecurityRoleMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        SecurityRoleMetaData ejbjarRole = parent.getSecurityRoleByName(child.getRoleName());
        if (ejbjarRole != null) {
            ejbjarRole.addPrincipalNames(child.getPrincipals());
        } else {
            parent.addSecurityRoleMetaData(child);
        }
    }

    public void addChild(AssemblyDescriptorMetaData parent, MessageDestinationMetaData child, UnmarshallingContext navigator, String namespaceURI, String localName) {
        MessageDestinationMetaData ejbjarDest = parent.getMessageDestinationMetaData(child.getName());
        if (ejbjarDest == null) {
            throw new IllegalStateException("message-destination " + child.getName() + " found in jboss.xml but not in ejb-jar.xml");
        }
        ejbjarDest.setJNDIName(child.getJNDIName());
    }

    public void setValue(ApplicationMetaData amd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("jmx-name")) {
            amd.setJmxName(value);
        } else if (localName.equals("enforce-ejb-restrictions")) {
            amd.setEnforceEjbRestrictions(Boolean.parseBoolean(value));
        } else if (localName.equals("exception-on-rollback")) {
            boolean flag = Boolean.valueOf(value);
            amd.setExceptionRollback(flag);
        } else if (localName.equals("security-domain")) {
            amd.setSecurityDomain(value);
        } else if (localName.equals("missing-method-permissions-excluded-mode")) {
            amd.setExcludeMissingMethods(Boolean.parseBoolean(value));
        } else if (localName.equals("unauthenticated-principal")) {
            amd.setUnauthenticatedPrincipal(value);
        }
    }

    public void setValue(InvokerProxyBindingMetaData md, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("name")) {
            md.setName(value);
        } else if (localName.equals("invoker-mbean")) {
            md.setInvokerMBean(value);
        } else if (localName.equals("proxy-factory")) {
            md.setProxyFactory(value);
        }
    }

    public void setValue(InvokerMetaData md, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("invoker-proxy-binding-name")) {
            md.bindingName = value;
        } else if (localName.equals("jndi-name")) {
            md.jndiName = value;
        }
    }

    public void setValue(InvokerMetaData.EjbRef md, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("ejb-ref-name")) {
            md.ejbRefName = value;
        } else if (localName.equals("jndi-name")) {
            md.jndiName = value;
        }
    }

    public void setValue(BeanHolder bean, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("ejb-name")) {
            bean.ejbName = value;
            bean.metaData = this.appMetaData.getBeanByEjbName(value);
            if (bean.metaData == null) {
                throw new IllegalStateException("Bean " + value + " not declared in the ejb-jar.xml");
            }
        } else if (localName.equals("jndi-name")) {
            bean.metaData.setJndiName(value);
        } else if (localName.equals("local-jndi-name")) {
            bean.metaData.setLocalJndiName(value);
        } else if (localName.equals("exception-on-rollback")) {
            bean.metaData.setExceptionRollback(Boolean.parseBoolean(value));
        } else if (localName.equals("timer-persistence")) {
            bean.metaData.setTimerPersistence(Boolean.parseBoolean(value));
        } else if (localName.equals("configuration-name")) {
            bean.metaData.setConfigurationName(value);
        } else if (localName.equals("security-proxy")) {
            bean.metaData.setSecurityProxy(value);
        } else if (localName.equals("depends")) {
            bean.metaData.addDepends(ObjectNameFactory.create(value));
        } else if (localName.equals("call-by-value")) {
            boolean flag = Boolean.valueOf(value);
            bean.metaData.setCallByValue(flag);
        } else if (localName.equals("clustered")) {
            bean.metaData.setClustered(Boolean.parseBoolean(value));
        } else if (localName.equals("read-only")) {
            ((EntityMetaData)bean.metaData).setReadOnly(Boolean.parseBoolean(value));
        } else if (localName.equals("cache-invalidation")) {
            ((EntityMetaData)bean.metaData).setDoDistCachInvalidations(Boolean.parseBoolean(value));
        } else if (localName.equals("destination-jndi-name")) {
            ((MessageDrivenMetaData)bean.metaData).setDestinationJndiName(value);
        } else if (localName.equals("mdb-user")) {
            ((MessageDrivenMetaData)bean.metaData).setUser(value);
        } else if (localName.equals("mdb-passwd")) {
            ((MessageDrivenMetaData)bean.metaData).setPasswd(value);
        } else if (localName.equals("mdb-client-id")) {
            ((MessageDrivenMetaData)bean.metaData).setClientId(value);
        } else if (localName.equals("mdb-subscription-id")) {
            ((MessageDrivenMetaData)bean.metaData).setSubscriptionId(value);
        } else if (localName.equals("resource-adapter-name")) {
            ((MessageDrivenMetaData)bean.metaData).setResourceAdapterName(value);
        }
    }

    public void setValue(ConfigurationHolder ch, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        ConfigurationMetaData container = ch.getConfiguration();
        if (localName.equals("container-name")) {
            ConfigurationMetaData cmd = ch.amd.getConfigurationMetaDataByName(value);
            if (cmd != null) {
                ch.extended = container = (ConfigurationMetaData)cmd.clone();
            }
            container.setName(value);
        } else if (localName.equals("call-logging")) {
            container.setCallLogging(Boolean.valueOf(value));
        } else if (localName.equals("invoker-proxy-binding-name")) {
            String[] invokers = container.getInvokers();
            if (invokers == null) {
                container.setInvokerNames(new String[]{value});
            } else {
                String[] newInvokers = new String[invokers.length + 1];
                System.arraycopy(invokers, 0, newInvokers, 0, invokers.length);
                newInvokers[invokers.length] = value;
                container.setInvokerNames(newInvokers);
            }
        } else if (localName.equals("sync-on-commit-only")) {
            container.setSyncOnCommitOnly(Boolean.valueOf(value));
        } else if (localName.equals("insert-after-ejb-post-create")) {
            container.setInsertAfterEjbPostCreate(Boolean.valueOf(value));
        } else if (localName.equals("call-ejb-store-on-clean")) {
            container.setEjbStoreForClean(Boolean.valueOf(value));
        } else if (localName.equals("store-not-flushed")) {
            container.setStoreNotFlushed(Boolean.valueOf(value));
        } else if (localName.equals("instance-pool")) {
            container.setInstancePool(value);
        } else if (localName.equals("instance-cache")) {
            container.setInstanceCache(value);
        } else if (localName.equals("persistence-manager")) {
            container.setPersistenceManager(value);
        } else if (localName.equals("web-class-loader")) {
            container.setWebClassLoader(value);
        } else if (localName.equals("locking-policy")) {
            container.setLockClass(value);
        } else if (localName.equals("commit-option")) {
            container.setCommitOption(value);
        } else if (localName.equals("optiond-refresh-rate")) {
            container.setOptionDRefreshRate(Long.parseLong(value));
        } else if (localName.equals("security-domain")) {
            container.setSecurityDomain(value);
        } else if (localName.equals("depends")) {
            container.getDepends().add(ObjectNameFactory.create(value));
        }
    }

    public void setValue(ClusterConfigMetaData config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("partition-name")) {
            config.setPartitionName(value);
        } else if (localName.equals("home-load-balance-policy")) {
            config.setHomeLoadBalancePolicy(value);
        } else if (localName.equals("bean-load-balance-policy")) {
            config.setBeanLoadBalancePolicy(value);
        } else if (localName.equals("session-state-manager-jndi-name")) {
            config.setHaSessionStateName(value);
        }
    }

    public void setValue(DomElement dom, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        Document doc = dom.element.getOwnerDocument();
        Text textNode = doc.createTextNode(value);
        dom.element.appendChild(textNode);
    }

    public void setValue(SecurityIdentityMetaData id, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("run-as-principal") && value != null) {
            id.setRunAsPrincipalName(value);
        }
    }

    public void setValue(MethodAttributes method, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("method-name")) {
            method.setPattern(value);
        } else if (localName.equals("read-only")) {
            method.setReadOnly(Boolean.parseBoolean(value));
        } else if (localName.equals("idempotent")) {
            method.setIdempotent(Boolean.parseBoolean(value));
        } else if (localName.equals("transaction-timeout")) {
            method.setTxTimeout(Integer.parseInt(value));
        }
    }

    public void setValue(IorSecurityConfigMetaData.TransportConfig parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("integrity")) {
            parent.setIntegrity(value);
        } else if (localName.equals("confidentiality")) {
            parent.setConfidentiality(value);
        } else if (localName.equals("establish-trust-in-target")) {
            parent.setEstablishTrustInTarget(value);
        } else if (localName.equals("establish-trust-in-client")) {
            parent.setEstablishTrustInClient(value);
        } else if (localName.equals("detect-misordering")) {
            parent.setDetectMisordering(value);
        } else if (localName.equals("detect-replay")) {
            parent.setDetectReplay(value);
        }
    }

    public void setValue(IorSecurityConfigMetaData.AsContext parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("auth-method")) {
            parent.setAuthMethod(value);
        } else if (localName.equals("realm")) {
            parent.setRealm(value);
        } else if (localName.equals("required")) {
            parent.setRequired(Boolean.parseBoolean(value));
        }
    }

    public void setValue(IorSecurityConfigMetaData.SasContext parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("caller-propagation")) {
            parent.setCallerPropagation(value);
        }
    }

    public void setValue(CacheInvalidationConfigMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("invalidation-group-name")) {
            parent.setInvalidationGroupName(value);
        } else if (localName.equals("invalidation-manager-name")) {
            parent.setInvalidationManagerName(value);
        }
    }

    public void setValue(EjbPortComponentMetaData pcMetaData, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("port-component-name")) {
            pcMetaData.setPortComponentName(value);
        } else if (localName.equals("port-component-uri")) {
            pcMetaData.setPortComponentURI(value);
        } else if (localName.equals("auth-method")) {
            pcMetaData.setAuthMethod(value);
        } else if (localName.equals("transport-guarantee")) {
            pcMetaData.setTransportGuarantee(value);
        } else if (localName.equals("secure-wsdl-access")) {
            pcMetaData.setSecureWSDLAccess(Boolean.valueOf(value));
        }
    }

    public void setValue(ActivationConfigPropertyMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("activation-config-property-name")) {
            parent.setName(value);
        } else if (localName.equals("activation-config-property-value")) {
            parent.setValue(value);
        }
    }

    public void setValue(SecurityRoleMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("role-name")) {
            parent.setRoleName(value);
        } else if (localName.equals("principal-name")) {
            parent.addPrincipalName(value);
        }
    }

    public void setValue(ResourceManagerMetaData parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("res-name")) {
            parent.resName = value;
        } else if (localName.equals("res-jndi-name")) {
            parent.jndiName = value;
        } else if (localName.equals("res-url")) {
            parent.url = value;
        }
    }

    public void setValue(ApplicationMetaData.Webservices parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("context-root")) {
            parent.setContextRoot(value);
        }
    }

    public void setValue(ApplicationMetaData.WebserviceDescription parent, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("webservice-description-name")) {
            parent.setDescriptionName(value);
        } else if (localName.equals("config-name")) {
            parent.setConfigName(value);
        } else if (localName.equals("config-file")) {
            parent.setConfigFile(value);
        } else if (localName.equals("wsdl-publish-location")) {
            parent.setWsdlPublishLocation(value);
        }
    }

    private static Element newDomElement(String name, Attributes attrs) {
        if (DOC_BUILDER == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DOC_BUILDER = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Failed to create W3C DocumentBuilder", e);
            }
        }
        Element element = DOC_BUILDER.newDocument().createElement(name);
        JBossEjbObjectFactory.addAttributes(element, attrs);
        return element;
    }

    private static void addAttributes(Element e, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            e.setAttribute(attrs.getQName(i), attrs.getValue(i));
        }
    }

    static class ConfigurationHolder {
        ApplicationMetaData amd;
        ConfigurationMetaData base;
        ConfigurationMetaData extended;

        ConfigurationHolder(ApplicationMetaData amd, ConfigurationMetaData base) {
            this.amd = amd;
            this.base = base;
        }

        ConfigurationMetaData getConfiguration() {
            return this.extended != null ? this.extended : this.base;
        }
    }

    static class BeanHolder {
        String ejbName;
        BeanMetaData metaData;

        BeanHolder() {
        }
    }

    public static class ResourceManagerMetaData {
        String resName;
        String jndiName;
        String url;
    }

    public static class InvokerMetaData {
        BeanMetaData bean;
        String bindingName;
        String jndiName;

        public InvokerMetaData(BeanMetaData bean) {
            this.bean = bean;
        }

        public static class EjbRef {
            String ejbRefName;
            String jndiName;
        }
    }

    public static class DomElement {
        private final Element element;

        public DomElement(Element element) {
            this.element = element;
        }
    }
}

