/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployers.plugins.deployers.helpers.AttachmentLocator;
import org.jboss.deployers.plugins.deployers.helpers.ObjectModelFactoryDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.J2eeModuleMetaData;
import org.jboss.metadata.WebMetaData;
import org.jboss.metadata.web.JBossWebMetaDataObjectFactory;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.xb.binding.ObjectModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossWebAppParsingDeployer
extends ObjectModelFactoryDeployer<WebMetaData> {
    private String webXmlPath = "jboss-web.xml";

    public JBossWebAppParsingDeployer() {
        super(WebMetaData.class);
        this.setRelativeOrder(2001);
    }

    public String getWebXmlPath() {
        return this.webXmlPath;
    }

    public void setWebXmlPath(String webXmlPath) {
        this.webXmlPath = webXmlPath;
    }

    @Override
    protected boolean allowsReparse() {
        return true;
    }

    @Override
    protected ObjectModelFactory getObjectModelFactory(WebMetaData root) {
        return new JBossWebMetaDataObjectFactory(root);
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        J2eeApplicationMetaData earMetaData;
        this.log.debug("deploy, unit: " + unit);
        this.createMetaData(unit, this.webXmlPath, null);
        WebMetaData metaData = (WebMetaData)this.getMetaData(unit, WebMetaData.class.getName());
        if (metaData == null) {
            return;
        }
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = metaData.getLoaderConfig();
        if (loaderConfig != null) {
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderConfig);
        }
        if ((earMetaData = AttachmentLocator.search(unit, J2eeApplicationMetaData.class)) != null) {
            String path = unit.getRelativePath();
            J2eeModuleMetaData webModule = earMetaData.getModule(path);
            if (webModule != null) {
                String contextRoot = metaData.getContextRoot();
                if (contextRoot == null) {
                    contextRoot = webModule.getWebContext();
                    metaData.setContextRoot(contextRoot);
                }
                metaData.setAltDDPath(webModule.getAlternativeDD());
            }
            if (metaData.getSecurityDomain() == null) {
                metaData.setSecurityDomain(earMetaData.getSecurityDomain());
            }
            metaData.mergeSecurityRoles(earMetaData.getSecurityRoles());
        }
    }
}

