/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBLocalHome;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import javax.transaction.TransactionManager;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.ejb.BeanLockManager;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EjbModuleMBean;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.EntityPersistenceStore;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.SecurityActions;
import org.jboss.ejb.StatefulSessionContainer;
import org.jboss.ejb.StatefulSessionPersistenceManager;
import org.jboss.ejb.StatelessSessionContainer;
import org.jboss.ejb.plugins.CMPPersistenceManager;
import org.jboss.ejb.plugins.SecurityProxyInterceptor;
import org.jboss.ejb.plugins.StatefulSessionInstancePool;
import org.jboss.invocation.InvocationType;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.EntityMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.Util;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.system.Registry;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerFactory;
import org.jboss.util.loading.DelegatingClassLoader;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebClassLoader;
import org.jboss.web.WebServiceMBean;
import org.w3c.dom.Element;

public class EjbModule
extends ServiceMBeanSupport
implements EjbModuleMBean {
    public static final String BASE_EJB_MODULE_NAME = "jboss.j2ee:service=EjbModule";
    public static final ObjectName EJB_MODULE_QUERY_NAME = ObjectNameFactory.create("jboss.j2ee:service=EjbModule,*");
    public static String DEFAULT_STATELESS_CONFIGURATION = "Default Stateless SessionBean";
    public static String DEFAULT_STATEFUL_CONFIGURATION = "Default Stateful SessionBean";
    public static String DEFAULT_ENTITY_BMP_CONFIGURATION = "Default BMP EntityBean";
    public static String DEFAULT_ENTITY_CMP_CONFIGURATION = "Default CMP EntityBean";
    public static String DEFAULT_MESSAGEDRIVEN_CONFIGURATION = "Default MesageDriven Bean";
    public static final int BMT = 1;
    public static final int CMT = 2;
    public static final int ANY = 3;
    static final String BMT_VALUE = "Bean";
    static final String CMT_VALUE = "Container";
    static final String ANY_VALUE = "Both";
    private static final Logger log = Logger.getLogger(EjbModule.class);
    HashMap containers = new HashMap();
    LinkedList containerOrdering = new LinkedList();
    HashMap localHomes = new HashMap();
    ClassLoader classLoader = null;
    final String name;
    private DeploymentUnit deploymentUnit;
    private ServiceControllerMBean serviceController;
    private final Map moduleData = Collections.synchronizedMap(new HashMap());
    private ObjectName webServiceName;
    private TransactionManagerFactory tmFactory;
    private boolean callByValue;
    private ApplicationMetaData appMetaData;
    private JaccPolicyMBean jaccPolicy;

    public EjbModule(DeploymentUnit unit, ApplicationMetaData metaData) {
        this.appMetaData = metaData;
        this.deploymentUnit = unit;
        String name = this.deploymentUnit.getName();
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        this.name = name;
        Boolean flag = unit.getAttachment("EJB.callByValue", Boolean.class);
        if (flag == null) {
            flag = unit.getAttachment("EAR.callByValue", Boolean.class);
        }
        if (flag != null) {
            this.callByValue = flag;
        }
        if (unit.getAttachment(ApplicationMetaData.class) == null) {
            unit.addAttachment(ApplicationMetaData.class, metaData);
        }
    }

    public EjbModule(DeploymentInfo di, TransactionManager tm, ObjectName webServiceName) {
        this.name = "deprecated";
    }

    public void setTransactionManagerFactory(TransactionManagerFactory tm) {
        this.tmFactory = tm;
    }

    public ObjectName getWebServiceName() {
        return this.webServiceName;
    }

    public void setWebServiceName(ObjectName webServiceName) {
        this.webServiceName = webServiceName;
    }

    public Map getModuleDataMap() {
        return this.moduleData;
    }

    public Object getModuleData(Object key) {
        return this.moduleData.get(key);
    }

    public void putModuleData(Object key, Object value) {
        this.moduleData.put(key, value);
    }

    public void removeModuleData(Object key) {
        this.moduleData.remove(key);
    }

    private void addContainer(Container con) throws DeploymentException {
        String ejbName = con.getBeanMetaData().getEjbName();
        if (this.containers.containsKey(ejbName)) {
            throw new DeploymentException("Duplicate ejb-name. Container for " + ejbName + " already exists.");
        }
        this.containers.put(ejbName, con);
        this.containerOrdering.add(con);
        con.setEjbModule(this);
    }

    public void removeContainer(Container con) {
        this.containers.remove(con.getBeanMetaData().getEjbName());
        this.containerOrdering.remove(con);
    }

    public void addLocalHome(Container con, EJBLocalHome localHome) {
        this.localHomes.put(con.getBeanMetaData().getEjbName(), localHome);
    }

    public void removeLocalHome(Container con) {
        this.localHomes.remove(con.getBeanMetaData().getEjbName());
    }

    public EJBLocalHome getLocalHome(Container con) {
        return (EJBLocalHome)this.localHomes.get(con.getBeanMetaData().getEjbName());
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public Container getContainer(String name) {
        return (Container)this.containers.get(name);
    }

    public Collection getContainers() {
        return this.containerOrdering;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public URL getURL() {
        return this.appMetaData.getUrl();
    }

    public JaccPolicyMBean getJaccPolicy() {
        return this.jaccPolicy;
    }

    public void setJaccPolicy(JaccPolicyMBean jaccPolicy) {
        this.jaccPolicy = jaccPolicy;
    }

    protected void createService() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanProxyExt.create(ServiceControllerMBean.class, ServiceControllerMBean.OBJECT_NAME, this.server);
        log.debug("createService, begin");
        try {
            AuthorizationManager authzmgr;
            VirtualFile xacmlFile;
            Container con;
            Iterator beans = this.appMetaData.getEnterpriseBeans();
            String contextID = this.appMetaData.getJaccContextID();
            if (contextID == null) {
                contextID = this.deploymentUnit.getSimpleName();
            }
            this.appMetaData.setJaccContextID(contextID);
            PolicyConfiguration pc = null;
            while (beans.hasNext()) {
                BeanMetaData bean = (BeanMetaData)beans.next();
                log.info("Deploying " + bean.getEjbName());
                con = this.createContainer(bean, this.deploymentUnit);
                this.addContainer(con);
                con.setJaccContextID(contextID);
                if (this.jaccPolicy == null) continue;
                pc = this.jaccPolicy.createPermissions(bean, contextID, pc);
            }
            if (pc != null && this.jaccPolicy != null) {
                this.jaccPolicy.link(pc);
            }
            ListIterator iter = this.containerOrdering.listIterator();
            while (iter.hasNext()) {
                con = (Container)iter.next();
                ObjectName jmxName = con.getJmxName();
                this.server.registerMBean(con, jmxName);
                BeanMetaData metaData = con.getBeanMetaData();
                Set<ObjectName> depends = metaData.getDepends();
                this.serviceController.create(jmxName, depends);
                int jmxHash = jmxName.hashCode();
                Registry.bind(new Integer(jmxHash), jmxName);
                log.debug("Bound jmxName=" + jmxName + ", hash=" + jmxHash + "into Registry");
            }
            String securityDomain = Util.unprefixSecurityDomain(this.appMetaData.getSecurityDomain());
            if (securityDomain == null) {
                securityDomain = "jboss-ejb-policy";
            }
            if ((xacmlFile = this.deploymentUnit.getMetaDataFile("jboss-xacml-policy.xml")) != null && (authzmgr = Util.getAuthorizationManager(securityDomain)) instanceof PolicyRegistration) {
                PolicyRegistration xam = (PolicyRegistration)authzmgr;
                xam.registerPolicy(contextID, xacmlFile.toURL());
            }
        }
        catch (Exception e) {
            this.destroyService();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        Container con;
        ListIterator iter = this.containerOrdering.listIterator();
        while (iter.hasNext()) {
            con = (Container)iter.next();
            if (!con.getBeanMetaData().isEntity()) continue;
            ClassLoader oldCl = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader(con.getClassLoader());
            con.pushENC();
            try {
                ((EntityContainer)con).getPersistenceManager().start();
            }
            finally {
                con.popENC();
                SecurityActions.setContextClassLoader(oldCl);
            }
        }
        iter = this.containerOrdering.listIterator();
        while (iter.hasNext()) {
            con = (Container)iter.next();
            log.debug("startService, starting container: " + con.getBeanMetaData().getEjbName());
            this.serviceController.start(con.getJmxName());
        }
    }

    protected void stopService() throws Exception {
        ListIterator iter = this.containerOrdering.listIterator(this.containerOrdering.size());
        while (iter.hasPrevious()) {
            Container con = (Container)iter.previous();
            try {
                ObjectName jmxName = con.getJmxName();
                BeanMetaData metaData = con.getBeanMetaData();
                String ejbName = metaData != null ? metaData.getEjbName() : "Unknown";
                log.debug("stopService, stopping container: " + ejbName);
                this.serviceController.stop(jmxName);
            }
            catch (Exception e) {
                log.error("unexpected exception stopping Container: " + con.getJmxName(), e);
            }
        }
    }

    protected void destroyService() throws Exception {
        AuthorizationManager authzmgr;
        WebServiceMBean webServer = null;
        if (this.webServiceName != null) {
            webServer = (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
        }
        ListIterator iter = this.containerOrdering.listIterator(this.containerOrdering.size());
        String contextID = this.appMetaData.getJaccContextID();
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, true);
        pc.delete();
        String securityDomain = Util.unprefixSecurityDomain(this.appMetaData.getSecurityDomain());
        if (securityDomain != null && (authzmgr = Util.getAuthorizationManager(securityDomain)) instanceof PolicyRegistration) {
            PolicyRegistration xam = (PolicyRegistration)authzmgr;
            xam.deRegisterPolicy(contextID);
        }
        while (iter.hasPrevious()) {
            ClassLoader wcl;
            Container con = (Container)iter.previous();
            ObjectName jmxName = con.getJmxName();
            int conState = con.getState();
            boolean destroyContainer = true;
            log.debug("Looking to destroy container: " + jmxName + ", state: " + con.getStateString() + ", destroy: " + destroyContainer);
            int jmxHash = jmxName.hashCode();
            Registry.unbind(new Integer(jmxHash));
            if (webServer != null && (wcl = con.getWebClassLoader()) != null) {
                try {
                    webServer.removeClassLoader(wcl);
                }
                catch (Throwable e) {
                    log.warn("Failed to unregister webClassLoader", e);
                }
            }
            if (destroyContainer) {
                try {
                    this.serviceController.destroy(jmxName);
                    this.serviceController.remove(jmxName);
                    log.info("Undeployed " + con.getBeanMetaData().getEjbName());
                    if (this.server.isRegistered(jmxName)) {
                        this.server.unregisterMBean(jmxName);
                    }
                }
                catch (Throwable e) {
                    log.error("unexpected exception destroying Container: " + jmxName, e);
                }
            }
            con.setBeanMetaData(null);
            con.setWebClassLoader(null);
            con.setClassLoader(null);
            con.setEjbModule(null);
            con.setDeploymentInfo(null);
            con.setTransactionManager(null);
            con.setSecurityManager(null);
            con.setRealmMapping(null);
            con.setSecurityProxy(null);
            con.setAuthorizationManager(null);
            con.proxyFactories.clear();
        }
        this.containers.clear();
        this.localHomes.clear();
        this.containerOrdering.clear();
        this.moduleData.clear();
        this.serviceController = null;
    }

    private Container createContainer(BeanMetaData bean, DeploymentUnit unit) throws Exception {
        Container container = null;
        container = bean.isMessageDriven() ? this.createMessageDrivenContainer(bean, unit) : (bean.isSession() ? (((SessionMetaData)bean).isStateless() ? this.createStatelessSessionContainer((SessionMetaData)bean, unit) : this.createStatefulSessionContainer((SessionMetaData)bean, unit)) : this.createEntityContainer(bean, unit));
        container.setDeploymentUnit(unit);
        return container;
    }

    private MessageDrivenContainer createMessageDrivenContainer(BeanMetaData bean, DeploymentUnit unit) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        MessageDrivenContainer container = new MessageDrivenContainer();
        int transType = bean.isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, unit);
        EjbModule.createProxyFactories(bean, container);
        container.setInstancePool(EjbModule.createInstancePool(conf, unit.getClassLoader()));
        return container;
    }

    private StatelessSessionContainer createStatelessSessionContainer(SessionMetaData bean, DeploymentUnit unit) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        StatelessSessionContainer container = new StatelessSessionContainer();
        int transType = bean.isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, unit);
        if (bean.getHome() != null || bean.getServiceEndpoint() != null) {
            EjbModule.createProxyFactories(bean, container);
        }
        container.setInstancePool(EjbModule.createInstancePool(conf, unit.getClassLoader()));
        return container;
    }

    private StatefulSessionContainer createStatefulSessionContainer(SessionMetaData bean, DeploymentUnit unit) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        StatefulSessionContainer container = new StatefulSessionContainer();
        int transType = bean.isContainerManagedTx() ? 2 : 1;
        this.initializeContainer(container, conf, bean, transType, unit);
        if (bean.getHome() != null || bean.getServiceEndpoint() != null) {
            EjbModule.createProxyFactories(bean, container);
        }
        ClassLoader cl = unit.getClassLoader();
        container.setInstanceCache(EjbModule.createInstanceCache(conf, cl));
        StatefulSessionInstancePool ip = new StatefulSessionInstancePool();
        ip.importXml(conf.getContainerPoolConf());
        container.setInstancePool(ip);
        container.setPersistenceManager((StatefulSessionPersistenceManager)cl.loadClass(conf.getPersistenceManager()).newInstance());
        container.setLockManager(EjbModule.createBeanLockManager(container, false, conf.getLockClass(), cl));
        return container;
    }

    private EntityContainer createEntityContainer(BeanMetaData bean, DeploymentUnit unit) throws Exception {
        ConfigurationMetaData conf = bean.getContainerConfiguration();
        EntityContainer container = new EntityContainer();
        int transType = 2;
        this.initializeContainer(container, conf, bean, transType, unit);
        if (bean.getHome() != null) {
            EjbModule.createProxyFactories(bean, container);
        }
        ClassLoader cl = unit.getClassLoader();
        container.setInstanceCache(EjbModule.createInstanceCache(conf, cl));
        container.setInstancePool(EjbModule.createInstancePool(conf, cl));
        boolean reentrant = ((EntityMetaData)bean).isReentrant();
        BeanLockManager lockMgr = EjbModule.createBeanLockManager(container, reentrant, conf.getLockClass(), cl);
        container.setLockManager(lockMgr);
        if (((EntityMetaData)bean).isBMP()) {
            Class<?> pmClass = cl.loadClass(conf.getPersistenceManager());
            EntityPersistenceManager pm = (EntityPersistenceManager)pmClass.newInstance();
            container.setPersistenceManager(pm);
        } else {
            CMPPersistenceManager persistenceManager = new CMPPersistenceManager();
            Class<?> pmClass = cl.loadClass(conf.getPersistenceManager());
            EntityPersistenceStore pm = (EntityPersistenceStore)pmClass.newInstance();
            persistenceManager.setPersistenceStore(pm);
            container.setPersistenceManager(persistenceManager);
        }
        return container;
    }

    private void initializeContainer(Container container, ConfigurationMetaData conf, BeanMetaData bean, int transType, DeploymentUnit unit) throws NamingException, DeploymentException {
        String securityProxyClassName;
        container.setEjbModule(this);
        container.setBeanMetaData(bean);
        ClassLoader unitCl = unit.getClassLoader();
        String webClassLoaderName = EjbModule.getWebClassLoader(conf, bean);
        log.debug("Creating WebClassLoader of class " + webClassLoaderName);
        WebClassLoader wcl = null;
        try {
            Class<?> clazz = unitCl.loadClass(webClassLoaderName);
            Constructor<?> constructor = clazz.getConstructor(ObjectName.class, RepositoryClassLoader.class);
            wcl = (WebClassLoader)constructor.newInstance(container.getJmxName(), unitCl);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create WebClassLoader of class " + webClassLoaderName + ": ", e);
        }
        if (this.webServiceName != null) {
            WebServiceMBean webServer = (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
            URL[] codebase = new URL[]{webServer.addClassLoader(wcl)};
            wcl.setWebURLs(codebase);
        }
        container.setWebClassLoader(wcl);
        container.setClassLoader(new DelegatingClassLoader(wcl));
        InitialContext iniCtx = new InitialContext();
        container.setTransactionManager(this.tmFactory.getTransactionManager());
        String securityDomain = bean.getApplicationMetaData().getSecurityDomain();
        String confSecurityDomain = conf.getSecurityDomain();
        if (confSecurityDomain == null) {
            confSecurityDomain = securityDomain;
        }
        if (confSecurityDomain != null && confSecurityDomain.length() == 0) {
            confSecurityDomain = null;
        }
        if (confSecurityDomain != null) {
            try {
                log.debug("Setting security domain from: " + confSecurityDomain);
                Object securityMgr = iniCtx.lookup(confSecurityDomain);
                AuthenticationManager ejbS = (AuthenticationManager)securityMgr;
                RealmMapping rM = (RealmMapping)securityMgr;
                container.setSecurityManager(ejbS);
                container.setRealmMapping(rM);
                container.setAuthorizationManager(Util.getAuthorizationManager(confSecurityDomain));
            }
            catch (NamingException e) {
                throw new DeploymentException("Could not find the security-domain, name=" + confSecurityDomain, e);
            }
            catch (Exception e) {
                throw new DeploymentException("Invalid security-domain specified, name=" + confSecurityDomain, e);
            }
        }
        if ((securityProxyClassName = bean.getSecurityProxy()) != null) {
            try {
                Class<?> proxyClass = unitCl.loadClass(securityProxyClassName);
                Object proxy = proxyClass.newInstance();
                container.setSecurityProxy(proxy);
                log.debug("setSecurityProxy, " + proxy);
            }
            catch (Exception e) {
                throw new DeploymentException("Failed to create SecurityProxy of type: " + securityProxyClassName, e);
            }
        }
        this.addInterceptors(container, transType, conf.getContainerInterceptorsConf());
    }

    private static String getWebClassLoader(ConfigurationMetaData conf, BeanMetaData bmd) throws DeploymentException {
        String webClassLoader = null;
        Iterator it = bmd.getInvokerBindings();
        int count = 0;
        while (it.hasNext()) {
            String invoker = (String)it.next();
            ApplicationMetaData amd = bmd.getApplicationMetaData();
            InvokerProxyBindingMetaData imd = amd.getInvokerProxyBindingMetaDataByName(invoker);
            if (imd == null) {
                String msg = "Failed to find InvokerProxyBindingMetaData for: '" + invoker + "'. Check the invoker-proxy-binding-name to " + "invoker-proxy-binding/name mappings in jboss.xml";
                throw new DeploymentException(msg);
            }
            Element proxyFactoryConfig = imd.getProxyFactoryConfig();
            String webCL = MetaData.getOptionalChildContent(proxyFactoryConfig, "web-class-loader");
            if (webCL == null) continue;
            log.debug("Invoker " + invoker + " specified WebClassLoader class" + webCL);
            webClassLoader = webCL;
            ++count;
        }
        if (count > 1) {
            log.warn(count + " invokers have WebClassLoader specifications.");
            log.warn("Using the last specification seen (" + webClassLoader + ").");
        } else if (count == 0) {
            webClassLoader = conf.getWebClassLoader();
        }
        return webClassLoader;
    }

    private void addInterceptors(Container container, int transType, Element element) throws DeploymentException {
        Iterator interceptorElements = MetaData.getChildrenByTagName(element, "interceptor");
        String transTypeString = EjbModule.stringTransactionValue(transType);
        ClassLoader loader = container.getClassLoader();
        ArrayList<Interceptor> istack = new ArrayList<Interceptor>();
        while (interceptorElements != null && interceptorElements.hasNext()) {
            Element ielement = (Element)interceptorElements.next();
            String transAttr = ielement.getAttribute("transaction");
            if (transAttr == null || transAttr.length() == 0) {
                transAttr = ANY_VALUE;
            }
            if (!transAttr.equalsIgnoreCase(ANY_VALUE) && !transAttr.equalsIgnoreCase(transTypeString)) continue;
            String className = null;
            try {
                className = MetaData.getFirstElementContent(ielement, null);
                Class<?> clazz = loader.loadClass(className);
                Interceptor interceptor = (Interceptor)clazz.newInstance();
                if (interceptor instanceof XmlLoadable) {
                    ((XmlLoadable)((Object)interceptor)).importXml(ielement);
                }
                istack.add(interceptor);
            }
            catch (ClassNotFoundException e) {
                log.warn("Could not load the " + className + " interceptor", e);
            }
            catch (Exception e) {
                log.warn("Could not load the " + className + " interceptor for this container", e);
            }
        }
        if (istack.size() == 0) {
            log.warn("There are no interceptors configured. Check the standardjboss.xml file");
        }
        for (int i = 0; i < istack.size(); ++i) {
            Interceptor interceptor = (Interceptor)istack.get(i);
            container.addInterceptor(interceptor);
        }
        if (container.getSecurityProxy() != null) {
            container.addInterceptor(new SecurityProxyInterceptor());
        }
        container.addInterceptor(container.createContainerInterceptor());
    }

    void createMissingPermissions(Container con, BeanMetaData bean) throws ClassNotFoundException, PolicyContextException {
        boolean exclude;
        String contextID = con.getJaccContextID();
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(contextID, false);
        Class clazz = con.getHomeClass();
        boolean hasSecurityDomain = con.getSecurityManager() != null;
        boolean bl = exclude = hasSecurityDomain ? bean.isExcludeMissingMethods() : false;
        if (clazz != null) {
            this.addMissingMethodPermissions(bean, exclude, clazz, InvocationType.HOME, pc);
        }
        if ((clazz = con.getLocalHomeClass()) != null) {
            this.addMissingMethodPermissions(bean, exclude, clazz, InvocationType.LOCALHOME, pc);
        }
        if ((clazz = con.getLocalClass()) != null) {
            this.addMissingMethodPermissions(bean, exclude, clazz, InvocationType.LOCAL, pc);
        }
        if ((clazz = con.getRemoteClass()) != null) {
            this.addMissingMethodPermissions(bean, exclude, clazz, InvocationType.REMOTE, pc);
        }
        pc.commit();
    }

    private void getInterfaces(Class iface, HashSet tmp) {
        tmp.add(iface);
        Class<?>[] ifaces = iface.getInterfaces();
        for (int n = 0; n < ifaces.length; ++n) {
            Class<?> iface2 = ifaces[n];
            tmp.add(iface2);
            this.getInterfaces(iface2, tmp);
        }
    }

    private void addMissingMethodPermissions(BeanMetaData bean, boolean exclude, Class iface, InvocationType type, PolicyConfiguration pc) throws PolicyContextException {
        String ejbName = bean.getEjbName();
        HashSet tmp = new HashSet();
        this.getInterfaces(iface, tmp);
        Class[] ifaces = new Class[tmp.size()];
        tmp.toArray(ifaces);
        for (int n = 0; n < ifaces.length; ++n) {
            Class c = ifaces[n];
            Method[] methods = c.getDeclaredMethods();
            for (int m = 0; m < methods.length; ++m) {
                Class[] params;
                String methodName = methods[m].getName();
                if (bean.hasMethodPermission(methodName, params = methods[m].getParameterTypes(), type)) continue;
                EJBMethodPermission p = new EJBMethodPermission(ejbName, type.toInterfaceString(), methods[m]);
                if (exclude) {
                    pc.addToExcludedPolicy(p);
                    continue;
                }
                pc.addToUncheckedPolicy(p);
            }
        }
    }

    private static String stringTransactionValue(int transType) {
        String transaction = ANY_VALUE;
        switch (transType) {
            case 1: {
                transaction = BMT_VALUE;
                break;
            }
            case 2: {
                transaction = CMT_VALUE;
            }
        }
        return transaction;
    }

    private static void createProxyFactories(BeanMetaData conf, Container container) throws Exception {
        ClassLoader cl = container.getClassLoader();
        Iterator it = conf.getInvokerBindings();
        boolean foundOne = false;
        while (it.hasNext()) {
            String invoker = (String)it.next();
            String jndiBinding = conf.getInvokerBinding(invoker);
            log.debug("creating binding for " + jndiBinding + ":" + invoker);
            InvokerProxyBindingMetaData imd = conf.getApplicationMetaData().getInvokerProxyBindingMetaDataByName(invoker);
            EJBProxyFactory ci = null;
            try {
                ci = (EJBProxyFactory)cl.loadClass(imd.getProxyFactory()).newInstance();
                ci.setContainer(container);
                ci.setInvokerMetaData(imd);
                ci.setInvokerBinding(jndiBinding);
                if (ci instanceof XmlLoadable) {
                    ((XmlLoadable)((Object)ci)).importXml(imd.getProxyFactoryConfig());
                }
                container.addProxyFactory(invoker, ci);
                foundOne = true;
            }
            catch (Exception e) {
                log.warn("The Container Invoker " + invoker + " (in jboss.xml or standardjboss.xml) could not be created because of " + e + " We will ignore this error, but you may miss a transport for this bean.");
            }
        }
        if (!foundOne) {
            throw new DeploymentException("Missing or invalid Container Invokers (in jboss.xml or standardjboss.xml).");
        }
    }

    private static BeanLockManager createBeanLockManager(Container container, boolean reentrant, String beanLock, ClassLoader cl) throws Exception {
        BeanLockManager lockManager = new BeanLockManager(container);
        Class<?> lockClass = null;
        try {
            lockClass = cl.loadClass(beanLock);
        }
        catch (Exception e) {
            throw new DeploymentException("Missing or invalid lock class (in jboss.xml or standardjboss.xml): " + beanLock + " - " + e);
        }
        lockManager.setLockCLass(lockClass);
        lockManager.setReentrant(reentrant);
        return lockManager;
    }

    private static InstancePool createInstancePool(ConfigurationMetaData conf, ClassLoader cl) throws Exception {
        InstancePool ip = null;
        try {
            ip = (InstancePool)cl.loadClass(conf.getInstancePool()).newInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Missing or invalid Instance Pool (in jboss.xml or standardjboss.xml)", e);
        }
        if (ip instanceof XmlLoadable) {
            ((XmlLoadable)((Object)ip)).importXml(conf.getContainerPoolConf());
        }
        return ip;
    }

    private static InstanceCache createInstanceCache(ConfigurationMetaData conf, ClassLoader cl) throws Exception {
        InstanceCache ic = null;
        try {
            ic = (InstanceCache)cl.loadClass(conf.getInstanceCache()).newInstance();
        }
        catch (Exception e) {
            throw new DeploymentException("Missing or invalid Instance Cache (in jboss.xml or standardjboss.xml)", e);
        }
        if (ic instanceof XmlLoadable) {
            ((XmlLoadable)((Object)ic)).importXml(conf.getContainerCacheConf());
        }
        return ic;
    }
}

