/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.deployers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.deployers.plugins.deployers.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.ejb.EjbModule;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ConfigurationMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceDependencyValueMetaData;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbDeployer
extends AbstractSimpleRealDeployer<ApplicationMetaData> {
    private String transactionManagerServiceName;
    private String webServiceName;
    private String ccmServiceName;
    private String timerServiceName;
    private boolean callByValue;

    public EjbDeployer() {
        super(ApplicationMetaData.class);
    }

    public String getTransactionManagerServiceName() {
        return this.transactionManagerServiceName;
    }

    public void setTransactionManagerServiceName(String transactionManagerServiceName) {
        this.transactionManagerServiceName = transactionManagerServiceName;
    }

    public String getWebServiceName() {
        return this.webServiceName;
    }

    public void setWebServiceName(String webServiceName) {
        this.webServiceName = webServiceName;
    }

    public String getCachedConnectionManagerName() {
        return this.ccmServiceName;
    }

    public void setCachedConnectionManagerName(String ccmServiceName) {
        this.ccmServiceName = ccmServiceName;
    }

    public String getTimerServiceName() {
        return this.timerServiceName;
    }

    public void setTimerServiceName(String timerServiceName) {
        this.timerServiceName = timerServiceName;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    @Override
    public void deploy(DeploymentUnit unit, ApplicationMetaData deployment) throws DeploymentException {
        if (deployment.getEjbVersion() > 2) {
            return;
        }
        if (unit.getName().startsWith("jboss:") && unit.getName().contains("id=")) {
            return;
        }
        ServiceMetaData ejbModule = new ServiceMetaData();
        ejbModule.setCode(EjbModule.class.getName());
        ObjectName moduleObjectName = null;
        try {
            moduleObjectName = this.getObjectName(unit, deployment);
        }
        catch (MalformedObjectNameException e) {
            throw new DeploymentException("Failed to create EJB module " + unit.getName() + ": malformed EjbModule name", e);
        }
        ejbModule.setObjectName(moduleObjectName);
        ServiceConstructorMetaData ctor = new ServiceConstructorMetaData();
        ctor.setSignature(new String[]{DeploymentUnit.class.getName(), ApplicationMetaData.class.getName()});
        ctor.setParameters(new Object[]{unit, deployment});
        ejbModule.setConstructor(ctor);
        ArrayList<ServiceAttributeMetaData> attrs = new ArrayList<ServiceAttributeMetaData>();
        ServiceAttributeMetaData attr = new ServiceAttributeMetaData();
        attr.setName("TransactionManagerFactory");
        ServiceDependencyValueMetaData dependencyValue = new ServiceDependencyValueMetaData();
        dependencyValue.setDependency(this.getTransactionManagerServiceName());
        dependencyValue.setProxyType("attribute");
        attr.setValue(dependencyValue);
        attrs.add(attr);
        ServiceAttributeMetaData ws = new ServiceAttributeMetaData();
        ws.setName("WebServiceName");
        ServiceDependencyValueMetaData wsDepends = new ServiceDependencyValueMetaData();
        wsDepends.setDependency(this.getWebServiceName());
        ws.setValue(wsDepends);
        attrs.add(ws);
        JaccPolicyUtil.getServiceAttributeMetaData(unit, attrs);
        ejbModule.setAttributes(attrs);
        ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
        if (this.ccmServiceName != null && this.ccmServiceName.length() > 0) {
            ServiceDependencyMetaData ccm = new ServiceDependencyMetaData();
            ccm.setIDependOn(this.ccmServiceName);
            dependencies.add(ccm);
        }
        if (this.timerServiceName != null && this.timerServiceName.length() > 0) {
            ServiceDependencyMetaData tms = new ServiceDependencyMetaData();
            tms.setIDependOn(this.timerServiceName);
            dependencies.add(tms);
        }
        Iterator beans = deployment.getEnterpriseBeans();
        HashSet<String> invokerNames = new HashSet<String>();
        while (beans.hasNext()) {
            String[] invokers;
            BeanMetaData bmd = (BeanMetaData)beans.next();
            String configName = bmd.getConfigurationName();
            ConfigurationMetaData cmd = deployment.getConfigurationMetaDataByName(configName);
            for (String iname : invokers = cmd.getInvokers()) {
                InvokerProxyBindingMetaData imd = deployment.getInvokerProxyBindingMetaDataByName(iname);
                String invokerName = imd.getInvokerMBean();
                if (invokerName.equalsIgnoreCase("default") || invokerNames.contains(invokerName)) continue;
                invokerNames.add(invokerName);
                ServiceDependencyMetaData invoker = new ServiceDependencyMetaData();
                invoker.setIDependOn(invokerName);
                dependencies.add(invoker);
            }
        }
        Set<ObjectName> moduleDepends = deployment.getDependencies();
        for (ObjectName n : moduleDepends) {
            ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
            sdmd.setIDependOn(n.toString());
            dependencies.add(sdmd);
        }
        ejbModule.setDependencies(dependencies);
        unit.addAttachment(ServiceMetaData.class, ejbModule);
        if (this.callByValue) {
            unit.addAttachment("EJB.callByValue", Boolean.TRUE, Boolean.class);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, ApplicationMetaData deployment) {
    }

    protected ObjectName getObjectName(DeploymentUnit unit, ApplicationMetaData metaData) throws MalformedObjectNameException {
        String name = metaData.getJmxName();
        if (name == null) {
            String unitShortName = unit.getName();
            if (unitShortName.endsWith("/")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            if (unitShortName.endsWith("!")) {
                unitShortName = unitShortName.substring(0, unitShortName.length() - 1);
            }
            unitShortName = unitShortName.substring(unitShortName.lastIndexOf("/") + 1);
            unitShortName = ObjectName.quote(unitShortName);
            name = "jboss.j2ee:service=EjbModule,module=" + unitShortName;
        }
        return new ObjectName(name);
    }
}

