/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.AnnotatedElement;
import javax.naming.Context;
import javax.xml.ws.WebServiceException;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.serviceref.ServiceRefDelegate;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.ws.integration.ServiceRefMetaData;

public class ServiceRefInjector
implements EncInjector {
    private static final Logger log = Logger.getLogger(ServiceRefInjector.class);
    private String name;
    private ServiceRefMetaData sref;

    public ServiceRefInjector(String name, AnnotatedElement anElement, ServiceRefMetaData sref) {
        this.name = name;
        this.sref = sref;
        sref.setAnnotatedElement(anElement);
    }

    public void inject(InjectionContainer container) {
        try {
            Context envCtx = container.getEnc();
            ClassLoader loader = container.getClassloader();
            VirtualFileAdaptor vfsRoot = new VirtualFileAdaptor(container.getRootFile());
            new ServiceRefDelegate().bindServiceRef(envCtx, this.name, vfsRoot, loader, this.sref);
        }
        catch (Exception e) {
            throw new WebServiceException("Unable to bind ServiceRef [enc=" + this.name + "]", e);
        }
    }

    public String toString() {
        return super.toString() + "{enc=" + this.name + "}";
    }
}

