/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.joinpoint.plugins;

import java.util.Arrays;
import org.jboss.joinpoint.spi.ConstructorJoinpoint;
import org.jboss.joinpoint.spi.FieldGetJoinpoint;
import org.jboss.joinpoint.spi.FieldSetJoinpoint;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.logging.Logger;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ConstructorInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

public class Config {
    protected static final Logger log = Logger.getLogger(Config.class);
    private static final String[] NO_PARAMS_TYPES = new String[0];
    private static final Object[] NO_PARAMS = new Object[0];

    public static Object instantiate(JoinpointFactory jpf, String[] paramTypes, Object[] params) throws Throwable {
        ConstructorJoinpoint joinpoint = Config.getConstructorJoinpoint(jpf, paramTypes, params);
        return joinpoint.dispatch();
    }

    public static void configure(Object object, JoinpointFactory jpf, String name, Object value) throws Throwable {
        FieldSetJoinpoint joinpoint = Config.getFieldSetJoinpoint(object, jpf, name, value);
        joinpoint.dispatch();
    }

    public static void unconfigure(Object object, JoinpointFactory jpf, String name) throws Throwable {
        FieldSetJoinpoint joinpoint = Config.getFieldSetJoinpoint(object, jpf, name, null);
        joinpoint.dispatch();
    }

    public static Object invoke(Object object, JoinpointFactory jpf, String name, String[] paramTypes, Object[] params) throws Throwable {
        MethodJoinpoint joinpoint = Config.getMethodJoinpoint(object, jpf, name, paramTypes, params);
        return joinpoint.dispatch();
    }

    public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory jpf) throws Throwable {
        return Config.getConstructorJoinpoint(jpf, null, null);
    }

    public static ConstructorJoinpoint getConstructorJoinpoint(JoinpointFactory jpf, String[] paramTypes, Object[] params) throws Throwable {
        boolean trace;
        if (paramTypes == null) {
            paramTypes = NO_PARAMS_TYPES;
        }
        if (params == null) {
            params = NO_PARAMS;
        }
        if (trace = log.isTraceEnabled()) {
            log.trace("Get constructor Joinpoint jpf=" + jpf + " paramTypes=" + Arrays.asList(paramTypes) + " params=" + Arrays.asList(params));
        }
        ConstructorInfo constructorInfo = Config.findConstructorInfo(jpf.getClassInfo(), paramTypes);
        ConstructorJoinpoint joinpoint = jpf.getConstructorJoinpoint(constructorInfo);
        joinpoint.setArguments(params);
        return joinpoint;
    }

    public static FieldGetJoinpoint getFieldGetJoinpoint(Object object, JoinpointFactory jpf, String name) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Get field get Joinpoint jpf=" + jpf + " target=" + object + " name=" + name);
        }
        FieldInfo fieldInfo = Config.findFieldInfo(jpf.getClassInfo(), name);
        FieldGetJoinpoint joinpoint = jpf.getFieldGetJoinpoint(fieldInfo);
        joinpoint.setTarget(object);
        return joinpoint;
    }

    public static FieldSetJoinpoint getFieldSetJoinpoint(Object object, JoinpointFactory jpf, String name, Object value) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Get field set Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " value=" + value);
        }
        FieldInfo fieldInfo = Config.findFieldInfo(jpf.getClassInfo(), name);
        FieldSetJoinpoint joinpoint = jpf.getFieldSetJoinpoint(fieldInfo);
        joinpoint.setTarget(object);
        joinpoint.setValue(value);
        return joinpoint;
    }

    public static MethodJoinpoint getMethodJoinpoint(Object object, JoinpointFactory jpf, String name, String[] paramTypes, Object[] params) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            if (paramTypes != null) {
                log.trace("Get method Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " paramTypes=" + Arrays.asList(paramTypes));
            } else {
                log.trace("Get method Joinpoint jpf=" + jpf + " target=" + object + " name=" + name + " paramTypes=()");
            }
        }
        MethodInfo methodInfo = Config.findMethodInfo(jpf.getClassInfo(), name, paramTypes);
        MethodJoinpoint joinpoint = jpf.getMethodJoinpoint(methodInfo);
        joinpoint.setTarget(object);
        joinpoint.setArguments(params);
        return joinpoint;
    }

    public static MethodJoinpoint getStaticMethodJoinpoint(JoinpointFactory jpf, String name, String[] paramTypes, Object[] params) throws Throwable {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            if (paramTypes != null) {
                log.trace("Get method Joinpoint jpf=" + jpf + " name=" + name + " paramTypes=" + Arrays.asList(paramTypes));
            } else {
                log.trace("Get method Joinpoint jpf=" + jpf + " name=" + name + " paramTypes=()");
            }
        }
        MethodInfo methodInfo = Config.findMethodInfo(jpf.getClassInfo(), name, paramTypes, true, true);
        MethodJoinpoint joinpoint = jpf.getMethodJoinpoint(methodInfo);
        joinpoint.setArguments(params);
        return joinpoint;
    }

    public static ConstructorInfo findConstructorInfo(ClassInfo classInfo, String[] paramTypes) throws JoinpointException {
        ConstructorInfo[] constructors = classInfo.getDeclaredConstructors();
        if (constructors != null) {
            for (int i = 0; i < constructors.length; ++i) {
                if (!Config.equals(paramTypes, constructors[i].getParameterTypes())) continue;
                return constructors[i];
            }
            throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(paramTypes) + " in " + Arrays.asList(constructors));
        }
        throw new JoinpointException("Constructor not found " + classInfo.getName() + Arrays.asList(paramTypes) + " no constructors");
    }

    public static FieldInfo findFieldInfo(ClassInfo classInfo, String name) throws JoinpointException {
        if (classInfo == null) {
            throw new IllegalArgumentException("ClassInfo cannot be null!");
        }
        for (ClassInfo current = classInfo; current != null; current = current.getSuperclass()) {
            FieldInfo result = Config.locateFieldInfo(current, name);
            if (result == null) continue;
            return result;
        }
        throw new JoinpointException("Field not found '" + name + "' for class " + classInfo.getName());
    }

    private static FieldInfo locateFieldInfo(ClassInfo classInfo, String name) {
        FieldInfo[] fields = classInfo.getDeclaredFields();
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (!name.equals(fields[i].getName())) continue;
                return fields[i];
            }
        }
        return null;
    }

    public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes) throws JoinpointException {
        return Config.findMethodInfo(classInfo, name, paramTypes, false, true);
    }

    public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean strict) throws JoinpointException {
        return Config.findMethodInfo(classInfo, name, paramTypes, false, true, strict);
    }

    public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic) throws JoinpointException {
        return Config.findMethodInfo(classInfo, name, paramTypes, isStatic, isPublic, true);
    }

    public static MethodInfo findMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict) throws JoinpointException {
        if (classInfo == null) {
            throw new IllegalArgumentException("ClassInfo cannot be null!");
        }
        if (paramTypes == null) {
            paramTypes = NO_PARAMS_TYPES;
        }
        for (ClassInfo current = classInfo; current != null; current = current.getSuperclass()) {
            MethodInfo result = Config.locateMethodInfo(current, name, paramTypes, isStatic, isPublic, strict);
            if (result == null) continue;
            return result;
        }
        throw new JoinpointException("Method not found " + name + Arrays.asList(paramTypes) + " for class " + classInfo.getName());
    }

    private static MethodInfo locateMethodInfo(ClassInfo classInfo, String name, String[] paramTypes, boolean isStatic, boolean isPublic, boolean strict) {
        MethodInfo[] methods = classInfo.getDeclaredMethods();
        if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                if (!name.equals(methods[i].getName()) || !Config.equals(paramTypes, methods[i].getParameterTypes()) || strict && (methods[i].isStatic() != isStatic || methods[i].isPublic() != isPublic)) continue;
                return methods[i];
            }
        }
        return null;
    }

    public static boolean equals(String[] typeNames, TypeInfo[] typeInfos) {
        if (!Config.simpleCheck(typeNames, typeInfos)) {
            return false;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            if (typeNames[i] == null || typeNames[i].equals(typeInfos[i].getName())) continue;
            return false;
        }
        return true;
    }

    protected static boolean simpleCheck(String[] typeNames, TypeInfo[] typeInfos) {
        if (typeNames == null || typeInfos == null) {
            return false;
        }
        return typeNames.length == typeInfos.length;
    }
}

