/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.messaging.core.plugin.postoffice.cluster.BindingInfo;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Streamable;

class SharedState
implements Streamable {
    private List bindings;
    private Map replicatedData;

    SharedState() {
    }

    SharedState(List bindings, Map replicatedData) {
        this.bindings = bindings;
        this.replicatedData = replicatedData;
    }

    List getBindings() {
        return this.bindings;
    }

    Map getReplicatedData() {
        return this.replicatedData;
    }

    public void read(DataInputStream in) throws Exception {
        int i;
        int size = in.readInt();
        this.bindings = new ArrayList(size);
        for (i = 0; i < size; ++i) {
            BindingInfo bb = new BindingInfo();
            bb.read(in);
            this.bindings.add(bb);
        }
        size = in.readInt();
        this.replicatedData = new HashMap(size);
        for (i = 0; i < size; ++i) {
            Serializable key = (Serializable)StreamUtils.readObject(in, true);
            HashMap replicants = StreamUtils.readMap(in, false);
            this.replicatedData.put(key, replicants);
        }
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.bindings.size());
        Iterator<Object> iter = this.bindings.iterator();
        while (iter.hasNext()) {
            BindingInfo info = (BindingInfo)iter.next();
            info.write(out);
        }
        out.writeInt(this.replicatedData.size());
        iter = this.replicatedData.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Serializable key = (Serializable)entry.getKey();
            StreamUtils.writeObject(out, key, true, true);
            Map replicants = (Map)entry.getValue();
            StreamUtils.writeMap(out, replicants, false);
        }
    }
}

