/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;

public class MethodAttributes
implements Serializable {
    private static final long serialVersionUID = 1L;
    String pattern;
    boolean readOnly;
    boolean idempotent;
    int txTimeout;
    public static MethodAttributes kDefaultMethodAttributes = new MethodAttributes();

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setIdempotent(boolean idempotent) {
        this.idempotent = idempotent;
    }

    public void setTxTimeout(int txTimeout) {
        this.txTimeout = txTimeout;
    }

    public boolean patternMatches(String methodName) {
        int ct;
        int end = this.pattern.length();
        if (end > methodName.length()) {
            return false;
        }
        for (ct = 0; ct < end; ++ct) {
            char c = this.pattern.charAt(ct);
            if (c == '*') {
                return true;
            }
            if (c == methodName.charAt(ct)) continue;
            return false;
        }
        return ct == methodName.length();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public int getTransactionTimeout() {
        return this.txTimeout;
    }

    static {
        MethodAttributes.kDefaultMethodAttributes.pattern = "*";
        MethodAttributes.kDefaultMethodAttributes.readOnly = false;
        MethodAttributes.kDefaultMethodAttributes.idempotent = false;
        MethodAttributes.kDefaultMethodAttributes.txTimeout = 0;
    }
}

