/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import java.util.Iterator;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationshipRoleMetaData;
import org.w3c.dom.Element;

public class RelationMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description;
    private String displayName;
    private String relationName;
    private RelationshipRoleMetaData left;
    private RelationshipRoleMetaData right;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public void setRelationName(String name) {
        this.relationName = name;
        if (this.relationName != null && this.relationName.length() == 0) {
            this.relationName = null;
        }
    }

    public RelationshipRoleMetaData getLeftRelationshipRole() {
        return this.left;
    }

    public void setLeftRelationshipRole(RelationshipRoleMetaData left) {
        this.left = left;
    }

    public RelationshipRoleMetaData getRightRelationshipRole() {
        return this.right;
    }

    public void setRightRelationshipRole(RelationshipRoleMetaData left) {
        this.right = left;
    }

    public RelationshipRoleMetaData getOtherRelationshipRole(RelationshipRoleMetaData role) {
        if (this.left == role) {
            return this.right;
        }
        if (this.right == role) {
            return this.left;
        }
        throw new IllegalArgumentException("Specified role is not the left or right role. role=" + role);
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        Iterator iter;
        this.relationName = RelationMetaData.getOptionalChildContent(element, "ejb-relation-name");
        if ("".equals(this.relationName)) {
            this.relationName = null;
        }
        if (!(iter = RelationMetaData.getChildrenByTagName(element, "ejb-relationship-role")).hasNext()) {
            throw new DeploymentException("Expected 2 ejb-relationship-role roles but found none");
        }
        this.left = new RelationshipRoleMetaData(this);
        this.left.importEjbJarXml((Element)iter.next());
        if (!iter.hasNext()) {
            throw new DeploymentException("Expected 2 ejb-relationship-role but only found one");
        }
        this.right = new RelationshipRoleMetaData(this);
        this.right.importEjbJarXml((Element)iter.next());
        if (iter.hasNext()) {
            throw new DeploymentException("Expected only 2 ejb-relationship-role but found more then 2");
        }
        if (this.relationName == null) {
            this.setDefaultRelationName();
        }
        String leftName = this.left.getRelationshipRoleName();
        String rightName = this.right.getRelationshipRoleName();
        if (leftName != null && leftName.equals(rightName)) {
            throw new DeploymentException("ejb-relationship-role-name must be unique in ejb-relation: ejb-relationship-role-name is " + leftName);
        }
        if (this.left.isCascadeDelete() && this.right.isMultiplicityMany()) {
            throw new DeploymentException("cascade-delete is only allowed in ejb-relationship-role where the other role has a multiplicity One");
        }
        if (this.right.isCascadeDelete() && this.left.isMultiplicityMany()) {
            throw new DeploymentException("cascade-delete is only allowed in ejb-relationship-role where the other role has a multiplicity One");
        }
    }

    public void setDefaultRelationName() {
        this.relationName = this.left.getEntityName() + (this.left.getCMRFieldName() == null ? "" : "_" + this.left.getCMRFieldName()) + "-" + this.right.getEntityName() + (this.right.getCMRFieldName() == null ? "" : "_" + this.right.getCMRFieldName());
    }
}

