/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.Ref;
import org.w3c.dom.Element;

public class ResourceRefMetaData
extends Ref
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String refName;
    private String name;
    private String jndiName;
    private String resURL;
    private String type;
    private boolean containerAuth;
    private boolean isShareable;

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public String getResURL() {
        return this.resURL;
    }

    public void setResURL(String resURL) {
        this.resURL = resURL;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getResourceName() {
        if (this.name == null) {
            this.name = this.refName;
        }
        return this.name;
    }

    public void setResourceName(String resName) {
        this.name = resName;
    }

    public boolean isContainerAuth() {
        return this.containerAuth;
    }

    public void setContainerAuth(String value) {
        this.containerAuth = value.equalsIgnoreCase("Container");
    }

    public void setContainerAuth(boolean flag) {
        this.containerAuth = flag;
    }

    public boolean isShareable() {
        return this.isShareable;
    }

    public void setSharable(String value) {
        this.isShareable = value.equalsIgnoreCase("Shareable");
    }

    public void setSharable(boolean flag) {
        this.isShareable = flag;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.refName = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-ref-name"));
        this.type = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-type"));
        String auth = MetaData.getElementContent(MetaData.getUniqueChild(element, "res-auth"));
        if (auth.equalsIgnoreCase("Container")) {
            this.containerAuth = true;
        } else if (auth.equals("Application") || auth.equals("SERVLET")) {
            this.containerAuth = false;
        } else {
            throw new DeploymentException("res-auth tag should be 'Container' or 'Application' or 'SERVLET'");
        }
        String sharing = MetaData.getElementContent(MetaData.getOptionalChild(element, "res-sharing-scope"), "Shareable");
        this.isShareable = sharing.equals("Shareable");
    }

    public void importJbossXml(Element element) throws DeploymentException {
        Element child = MetaData.getOptionalChild(element, "resource-name");
        if (child == null) {
            if (this.type.equals("java.net.URL")) {
                Element resUrl = MetaData.getOptionalChild(element, "res-url");
                if (resUrl != null) {
                    this.resURL = MetaData.getElementContent(resUrl);
                } else {
                    Element name = MetaData.getUniqueChild(element, "jndi-name");
                    this.jndiName = MetaData.getElementContent(name);
                }
            } else {
                this.jndiName = MetaData.getElementContent(MetaData.getUniqueChild(element, "jndi-name"));
            }
        } else {
            this.name = MetaData.getElementContent(child);
        }
    }
}

