/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;

public class SessionMetaData
extends BeanMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_STATEFUL_INVOKER = "stateful-unified-invoker";
    public static final String DEFAULT_CLUSTERED_STATEFUL_INVOKER = "clustered-stateful-unfied-invoker";
    public static final String DEFAULT_STATELESS_INVOKER = "stateless-unified-invoker";
    public static final String DEFAULT_CLUSTERED_STATELESS_INVOKER = "clustered-stateless-unified-invoker";
    private boolean stateful;

    public SessionMetaData(ApplicationMetaData app) {
        super(app, 'S');
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public boolean isStateless() {
        return !this.stateful;
    }

    public String getDefaultConfigurationName() {
        if (this.isStateful()) {
            if (this.isClustered()) {
                return "Clustered Stateful SessionBean";
            }
            return "Standard Stateful SessionBean";
        }
        if (this.isClustered()) {
            return "Clustered Stateless SessionBean";
        }
        return "Standard Stateless SessionBean";
    }

    protected void defaultInvokerBindings() {
        this.invokerBindings = new HashMap();
        if (this.isClustered()) {
            if (this.stateful) {
                this.invokerBindings.put(DEFAULT_CLUSTERED_STATEFUL_INVOKER, this.getJndiName());
            } else {
                this.invokerBindings.put(DEFAULT_CLUSTERED_STATELESS_INVOKER, this.getJndiName());
            }
        } else if (this.stateful) {
            this.invokerBindings.put(DEFAULT_STATEFUL_INVOKER, this.getJndiName());
        } else {
            this.invokerBindings.put(DEFAULT_STATELESS_INVOKER, this.getJndiName());
        }
    }
}

