/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.server.registry;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.metadata.MBeanCapability;
import org.jboss.mx.modelmbean.RequiredModelMBeanInvoker;
import org.jboss.mx.modelmbean.XMBean;
import org.jboss.mx.server.AbstractMBeanInvoker;
import org.jboss.mx.server.MBeanInvoker;
import org.jboss.mx.server.RawDynamicInvoker;
import org.jboss.mx.server.ServerConfig;
import org.jboss.mx.server.ServerObjectInstance;
import org.jboss.mx.server.registry.MBeanEntry;
import org.jboss.mx.server.registry.MBeanRegistry;
import org.jboss.mx.util.ObjectNamePatternHelper;
import org.jboss.util.NestedRuntimeException;

public class BasicMBeanRegistry
implements MBeanRegistry {
    private static ServerConfig serverConfig = ServerConfig.getInstance();
    private static String JMI_DOMAIN = serverConfig.getJMIDomain();
    private Map domainMap = new ConcurrentReaderHashMap();
    private String defaultDomain;
    private MBeanServer server;
    private LoaderRepository loaderRepository;
    protected final SynchronizedLong registrationNotificationSequence = new SynchronizedLong(1L);
    protected final SynchronizedLong unregistrationNotificationSequence = new SynchronizedLong(1L);
    protected MBeanServerDelegate delegate;
    protected Vector fMbInfosToStore;
    private ObjectName mbeanInfoService;
    protected static Logger log = Logger.getLogger(BasicMBeanRegistry.class);

    public BasicMBeanRegistry(MBeanServer server, String defaultDomain, ClassLoaderRepository clr) {
        this.server = server;
        this.defaultDomain = defaultDomain;
        try {
            this.loaderRepository = (LoaderRepository)clr;
            this.mbeanInfoService = new ObjectName("user:service=MBeanInfoDB");
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error instantiating registry", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectInstance registerMBean(Object object, ObjectName name, Map valueMap) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName regName = name;
        boolean registrationDone = true;
        boolean invokedPreRegister = false;
        String magicToken = null;
        MBeanRegistration invoker = null;
        if (object == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attempting to register null object"));
        }
        MBeanCapability mbcap = MBeanCapability.of(object.getClass());
        try {
            int mbeanType;
            if (valueMap != null) {
                magicToken = (String)valueMap.get(JMI_DOMAIN);
            }
            if ((mbeanType = mbcap.getMBeanType()) == 291) {
                invoker = new XMBean(object, "StandardMBean");
            } else if (object instanceof MBeanInvoker) {
                invoker = (MBeanInvoker)object;
            } else if (mbeanType == 801) {
                invoker = object instanceof RequiredModelMBean ? new RequiredModelMBeanInvoker((DynamicMBean)object) : new RawDynamicInvoker((DynamicMBean)object);
            }
            MBeanEntry entry = new MBeanEntry(regName, (MBeanInvoker)invoker, object, valueMap);
            AbstractMBeanInvoker.setMBeanEntry(entry);
            regName = this.invokePreRegister((MBeanInvoker)invoker, regName, magicToken);
            invokedPreRegister = true;
            MBeanInfo info = invoker.getMBeanInfo();
            this.verifyMBeanInfo(info, name);
            entry.setResourceClassName(info.getClassName());
            entry.setObjectName(regName);
            this.add(entry);
            if (object instanceof ClassLoader) {
                this.registerClassLoader((ClassLoader)object);
            }
            try {
                if (this.delegate != null) {
                    this.sendRegistrationNotification(regName);
                } else if (serverConfig.getMBeanServerDelegateName().equals(name)) {
                    this.delegate = (MBeanServerDelegate)object;
                }
                ServerObjectInstance serverObjInst = new ServerObjectInstance(regName, entry.getResourceClassName(), this.delegate.getMBeanServerId());
                this.persistIfRequired(invoker.getMBeanInfo(), regName);
                ServerObjectInstance serverObjectInstance = serverObjInst;
                return serverObjectInstance;
            }
            catch (Throwable t) {
                try {
                    try {
                        try {
                            if (object instanceof ClassLoader) {
                                this.loaderRepository.removeClassLoader((ClassLoader)object);
                            }
                            throw t;
                        }
                        catch (Throwable t2) {
                            this.remove(regName);
                            throw t2;
                        }
                    }
                    catch (NotCompliantMBeanException e) {
                        throw e;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        throw e;
                    }
                    catch (Throwable t3) {
                        log.error("Unexpected Exception:", t3);
                        throw t3;
                    }
                }
                catch (NotCompliantMBeanException e) {
                    registrationDone = false;
                    throw e;
                }
                catch (InstanceAlreadyExistsException e) {
                    registrationDone = false;
                    throw e;
                }
                catch (MBeanRegistrationException e) {
                    registrationDone = false;
                    log.warn(e.toString());
                    throw e;
                }
                catch (RuntimeOperationsException e) {
                    registrationDone = false;
                    throw e;
                }
                catch (Exception ex) {
                    registrationDone = false;
                    NotCompliantMBeanException ncex = new NotCompliantMBeanException("Cannot register MBean: " + name);
                    ncex.initCause(ex);
                    throw ncex;
                }
                catch (Throwable t4) {
                    log.error("Cannot register MBean", t4);
                    registrationDone = false;
                    ObjectInstance objectInstance = null;
                    return objectInstance;
                }
            }
        }
        finally {
            block41: {
                if (invoker != null) {
                    try {
                        invoker.postRegister(new Boolean(registrationDone));
                    }
                    catch (Exception e) {
                        if (!invokedPreRegister) break block41;
                        if (e instanceof RuntimeException) {
                            throw new RuntimeMBeanException((RuntimeException)e);
                        }
                        throw new MBeanRegistrationException(e);
                    }
                }
            }
            AbstractMBeanInvoker.setMBeanEntry(null);
        }
    }

    private void verifyMBeanInfo(MBeanInfo info, ObjectName name) throws NotCompliantMBeanException {
        try {
            if (info == null) {
                throw new NotCompliantMBeanException("MBeanInfo cannot be null, for: " + name);
            }
            if (info.getClassName() == null) {
                throw new NotCompliantMBeanException("Classname returned from MBeanInfo cannot be null, for: " + name);
            }
        }
        catch (NotCompliantMBeanException ncex) {
            throw ncex;
        }
        catch (Throwable t) {
            NotCompliantMBeanException ncex = new NotCompliantMBeanException("Cannot verify MBeanInfo, for: " + name);
            ncex.initCause(t);
            throw ncex;
        }
    }

    protected void sendRegistrationNotification(ObjectName regName) {
        long sequence = this.registrationNotificationSequence.increment();
        this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.registered", (Object)this.delegate, sequence, regName));
    }

    protected ObjectName handlePreRegistration(MBeanRegistration registrationInterface, ObjectName regName) throws Exception {
        ObjectName mbean = registrationInterface.preRegister(this.server, regName);
        if (regName == null) {
            return mbean;
        }
        return regName;
    }

    protected void handlePreDeregister(MBeanRegistration registrationInterface) throws Exception {
        registrationInterface.preDeregister();
    }

    protected void registerClassLoader(ClassLoader cl) {
        if (!(cl instanceof RepositoryClassLoader)) {
            this.loaderRepository.addClassLoader(cl);
        }
    }

    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        if ((name = this.qualifyName(name)).getDomain().equals(JMI_DOMAIN)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Not allowed to unregister: " + name.toString()));
        }
        MBeanEntry entry = this.get(name);
        Object resource = entry.getResourceInstance();
        try {
            this.handlePreDeregister(entry.getInvoker());
        }
        catch (Exception e) {
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            throw new MBeanRegistrationException(e, "preDeregister");
        }
        if (resource instanceof ClassLoader) {
            this.loaderRepository.removeClassLoader((ClassLoader)resource);
        }
        this.remove(name);
        this.sendUnRegistrationNotification(name);
        entry.getInvoker().postDeregister();
    }

    protected void sendUnRegistrationNotification(ObjectName name) {
        long sequence = this.unregistrationNotificationSequence.increment();
        this.delegate.sendNotification(new MBeanServerNotification("JMX.mbean.unregistered", (Object)this.delegate, sequence, name));
    }

    public MBeanEntry get(ObjectName name) throws InstanceNotFoundException {
        Object o;
        block6: {
            block5: {
                if (name == null) {
                    throw new RuntimeOperationsException(new IllegalArgumentException("null object name"));
                }
                String domain = name.getDomain();
                if (domain.length() == 0) {
                    domain = this.defaultDomain;
                }
                String props = name.getCanonicalKeyPropertyListString();
                Map mbeanMap = this.getMBeanMap(domain, false);
                o = null;
                if (null == mbeanMap) break block5;
                Object v = mbeanMap.get(props);
                o = v;
                if (null != v) break block6;
            }
            throw new InstanceNotFoundException(name + " is not registered.");
        }
        return o;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public String[] getDomains() {
        ArrayList<String> domains = new ArrayList<String>(this.domainMap.size());
        for (Map.Entry entry : this.domainMap.entrySet()) {
            String domainName = (String)entry.getKey();
            Map mbeans = (Map)entry.getValue();
            if (mbeans == null || mbeans.isEmpty()) continue;
            domains.add(domainName);
        }
        return domains.toArray(new String[domains.size()]);
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        if (!this.contains(name)) {
            throw new InstanceNotFoundException(name + " not registered.");
        }
        return new ServerObjectInstance(this.qualifyName(name), this.get(name).getResourceClassName(), this.delegate.getMBeanServerId());
    }

    public Object getValue(ObjectName name, String key) throws InstanceNotFoundException {
        return this.get(name).getValue(key);
    }

    public boolean contains(ObjectName name) {
        if (name == null) {
            return false;
        }
        String domain = name.getDomain();
        if (domain.length() == 0) {
            domain = this.defaultDomain;
        }
        String props = name.getCanonicalKeyPropertyListString();
        Map mbeanMap = this.getMBeanMap(domain, false);
        return null != mbeanMap && mbeanMap.containsKey(props);
    }

    public int getSize() {
        int retval = 0;
        Iterator iterator = this.domainMap.values().iterator();
        while (iterator.hasNext()) {
            retval += ((Map)iterator.next()).size();
        }
        return retval;
    }

    public List findEntries(ObjectName pattern) {
        ArrayList<Object> retval = new ArrayList<Object>();
        if (pattern == null || pattern.getCanonicalName().equals("*:*")) {
            Iterator domainIter = this.domainMap.values().iterator();
            while (domainIter.hasNext()) {
                retval.addAll(((Map)domainIter.next()).values());
            }
        } else if (!pattern.isPattern()) {
            try {
                retval.add(this.get(pattern));
            }
            catch (InstanceNotFoundException e) {}
        } else {
            String patternDomain = pattern.getDomain();
            if (patternDomain.length() == 0) {
                patternDomain = this.defaultDomain;
            }
            ObjectNamePatternHelper.PropertyPattern propertyPattern = new ObjectNamePatternHelper.PropertyPattern(pattern);
            for (Map.Entry mapEntry : this.domainMap.entrySet()) {
                Map value = (Map)mapEntry.getValue();
                if (value == null || value.isEmpty() || !ObjectNamePatternHelper.patternMatch((String)mapEntry.getKey(), patternDomain)) continue;
                for (MBeanEntry entry : value.values()) {
                    if (!propertyPattern.patternMatch(entry.getObjectName())) continue;
                    retval.add(entry);
                }
            }
        }
        return retval;
    }

    public void releaseRegistry() {
        this.server = null;
        this.delegate = null;
        Iterator iterator = this.domainMap.keySet().iterator();
        while (iterator.hasNext()) {
            Map nextMap = (Map)this.domainMap.get(iterator.next());
            if (nextMap.size() <= 0) continue;
            nextMap.clear();
        }
        this.domainMap.clear();
        this.domainMap = null;
    }

    protected ObjectName invokePreRegister(MBeanInvoker invoker, ObjectName regName, String magicToken) throws MBeanRegistrationException, NotCompliantMBeanException {
        if (regName != null) {
            regName = this.qualifyName(regName);
        }
        ObjectName mbeanName = null;
        try {
            mbeanName = invoker.preRegister(this.server, regName);
        }
        catch (NotCompliantMBeanException ncex) {
            throw ncex;
        }
        catch (Exception e) {
            if (e instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)e;
            }
            throw new MBeanRegistrationException(e, "preRegister() failed: [ObjectName='" + regName + "', Class=" + invoker.getResource().getClass().getName() + " (" + invoker.getResource() + ")]");
        }
        catch (Throwable t) {
            log.warn("preRegister() failed for " + regName + ": ", t);
            if (t instanceof Error) {
                throw new RuntimeErrorException((Error)t);
            }
            throw new RuntimeException(t.toString());
        }
        if (regName == null) {
            regName = mbeanName;
        }
        return this.validateAndQualifyName(regName, magicToken);
    }

    protected synchronized void add(MBeanEntry entry) throws InstanceAlreadyExistsException {
        ObjectName name = entry.getObjectName();
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        Map mbeanMap = this.getMBeanMap(domain, true);
        if (mbeanMap.get(props) != null) {
            throw new InstanceAlreadyExistsException(name + " already registered.");
        }
        mbeanMap.put(props, entry);
    }

    protected synchronized void remove(ObjectName name) throws InstanceNotFoundException {
        String domain = name.getDomain();
        String props = name.getCanonicalKeyPropertyListString();
        Map mbeanMap = this.getMBeanMap(domain, false);
        if (null == mbeanMap || null == mbeanMap.remove(props)) {
            throw new InstanceNotFoundException(name + " not registered.");
        }
    }

    protected ObjectName validateAndQualifyName(ObjectName name, String magicToken) {
        ObjectName result = this.qualifyName(name);
        if (result.isPattern()) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name is a pattern:" + name));
        }
        if (magicToken != JMI_DOMAIN && result.getDomain().equals(JMI_DOMAIN)) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Domain " + JMI_DOMAIN + " is reserved"));
        }
        return result;
    }

    protected ObjectName qualifyName(ObjectName name) {
        if (name == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null object name"));
        }
        try {
            if (name.getDomain().length() == 0) {
                return new ObjectName(this.defaultDomain + ":" + name.getCanonicalKeyPropertyListString());
            }
            return name;
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeOperationsException(new IllegalArgumentException(e.toString()));
        }
    }

    protected void persistIfRequired(MBeanInfo info, ObjectName name) throws MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        Descriptor descriptor;
        if (!(info instanceof ModelMBeanInfo)) {
            return;
        }
        ModelMBeanInfo mmbInfo = (ModelMBeanInfo)((Object)info);
        try {
            descriptor = mmbInfo.getMBeanDescriptor();
        }
        catch (MBeanException cause) {
            log.error("Error trying to get descriptors.", cause);
            return;
        }
        if (descriptor == null) {
            return;
        }
        String persistInfo = (String)descriptor.getFieldValue("persistmbeaninfo");
        if (persistInfo == null) {
            return;
        }
        log.debug("persistInfo: " + persistInfo);
        Boolean shouldPersist = new Boolean(persistInfo);
        if (!shouldPersist.booleanValue()) {
            return;
        }
        this.mbInfosToStore().add(name);
        if (this.contains(this.mbeanInfoService)) {
            log.debug("flushing queue");
            this.server.invoke(this.mbeanInfoService, "add", new Object[]{this.mbInfosToStore().clone()}, new String[]{this.mbInfosToStore().getClass().getName()});
            log.debug("clearing queue");
            this.mbInfosToStore().clear();
        } else {
            log.debug("service is not registered.  items remain in queue");
        }
    }

    protected Vector mbInfosToStore() {
        if (this.fMbInfosToStore == null) {
            this.fMbInfosToStore = new Vector(10);
        }
        return this.fMbInfosToStore;
    }

    private Map getMBeanMap(String domain, boolean createIfMissing) {
        Map mbeanMap = (Map)this.domainMap.get(domain);
        if (mbeanMap == null && createIfMissing) {
            mbeanMap = new ConcurrentReaderHashMap();
            this.domainMap.put(domain, mbeanMap);
        }
        return mbeanMap;
    }
}

