/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public class ObjectInputStreamWithClassLoader
extends ObjectInputStream {
    private ClassLoader cl;
    private static final HashMap primClasses = new HashMap(8, 1.0f);

    public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException, StreamCorruptedException {
        super(in);
        this.cl = cl;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
        if (this.cl == null) {
            return super.resolveClass(v);
        }
        try {
            return Class.forName(v.getName(), false, this.cl);
        }
        catch (ClassNotFoundException ex) {
            Class cl = (Class)primClasses.get(v.getName());
            if (cl != null) {
                return cl;
            }
            throw ex;
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        if (this.cl == null) {
            return super.resolveProxyClass(interfaces);
        }
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classObjs[i] = Class.forName(interfaces[i], false, this.cl);
        }
        try {
            return Proxy.getProxyClass(this.cl, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }
}

