/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.sslbisocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.security.SSLSocketBuilder;
import org.jboss.remoting.socketfactory.SocketFactoryWrapper;
import org.jboss.remoting.transport.bisocket.BisocketClientInvoker;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class SSLBisocketClientInvoker
extends BisocketClientInvoker {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$sslbisocket$SSLBisocketClientInvoker == null ? (class$org$jboss$remoting$transport$sslbisocket$SSLBisocketClientInvoker = SSLBisocketClientInvoker.class$("org.jboss.remoting.transport.sslbisocket.SSLBisocketClientInvoker")) : class$org$jboss$remoting$transport$sslbisocket$SSLBisocketClientInvoker);
    static /* synthetic */ Class class$org$jboss$remoting$transport$sslbisocket$SSLBisocketClientInvoker;

    public SSLBisocketClientInvoker(InvokerLocator locator) throws IOException {
        super(locator);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.error("Error setting up ssl bisocket client invoker.", ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    public SSLBisocketClientInvoker(InvokerLocator locator, Map configuration) throws IOException {
        super(locator, configuration);
        try {
            this.setup();
        }
        catch (Exception ex) {
            log.error("Error setting up ssl bisocket client invoker.", ex);
            throw new RuntimeException(ex.getMessage());
        }
    }

    protected SocketFactory createSocketFactory(Map configuration) {
        SocketFactory sf = super.createSocketFactory(configuration);
        if (SSLBisocketClientInvoker.isCompleteSocketFactory(sf)) {
            return sf;
        }
        SocketFactory wrapper = sf;
        try {
            SSLSocketBuilder server = new SSLSocketBuilder(configuration);
            sf = server.createSSLSocketFactory();
        }
        catch (Exception e) {
            log.error("Error creating SSL Socket Factory for client invoker.", e);
        }
        if (wrapper != null) {
            ((SocketFactoryWrapper)((Object)wrapper)).setSocketFactory(sf);
            return wrapper;
        }
        return sf;
    }

    protected Socket createSocket(String address, int port, int timeout) throws IOException {
        Object obj;
        if (this.isCallbackInvoker) {
            return super.createSocket(address, port, timeout);
        }
        SocketFactory sf = this.getSocketFactory();
        if (sf == null) {
            sf = this.createSocketFactory(this.configuration);
        }
        Socket s = sf.createSocket();
        s.setReuseAddress(this.getReuseAddress());
        InetSocketAddress inetAddr = new InetSocketAddress(address, port);
        if (timeout < 0 && (timeout = this.getTimeout()) < 0) {
            timeout = 0;
        }
        s.connect(inetAddr, timeout);
        if (s instanceof SSLSocket && (obj = this.configuration.get("handshakeCompletedListener")) != null && obj instanceof HandshakeCompletedListener) {
            SSLSocket sslSocket = (SSLSocket)s;
            HandshakeCompletedListener listener = (HandshakeCompletedListener)obj;
            this.establishHandshake(sslSocket, listener);
        }
        return s;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener(repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

