/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.logging.Logger;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SimpleGroup;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBJACCPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Subject callerSubject = null;
    private String methodInterface = null;
    private CodeSource ejbCS = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    private Group securityContextRoles = null;

    public EJBJACCPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    @Override
    public int authorize(Resource resource) {
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        if (map.size() == 0) {
            throw new IllegalStateException("Map from the Resource is size zero");
        }
        PolicyRegistration pr = (PolicyRegistration)map.get("authorizationManager");
        if (pr != null) {
            this.authzManager = pr;
        }
        this.callerSubject = (Subject)map.get("caller.subject");
        this.ejbCS = (CodeSource)map.get("ejb.codeSource");
        this.ejbMethod = (Method)map.get("ejb.method");
        this.ejbName = (String)map.get("ejb.name");
        this.methodInterface = (String)map.get("ejb.methodInterface");
        this.roleName = (String)map.get("roleName");
        AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
        if (am != null) {
            Principal ejbPrincipal = (Principal)map.get("ejb.principal");
            Set roleset = am.getUserRoles(ejbPrincipal);
            this.securityContextRoles = this.getGroupFromRoleSet(roleset);
        }
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef();
        }
        return this.process();
    }

    @Override
    public void setPolicyRegistrationManager(PolicyRegistration authzM) {
        this.authzManager = authzM;
    }

    private int process() {
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, this.methodInterface, this.ejbMethod);
        boolean policyDecision = this.checkWithPolicy(methodPerm);
        if (!policyDecision) {
            String msg = "Denied: " + methodPerm + ", caller=" + this.callerSubject;
            if (this.trace) {
                log.trace("EJB Jacc Delegate:" + msg);
            }
        }
        return policyDecision ? 1 : -1;
    }

    private int checkRoleRef() {
        EJBRoleRefPermission ejbRoleRefPerm = new EJBRoleRefPermission(this.ejbName, this.roleName);
        boolean policyDecision = this.checkWithPolicy(ejbRoleRefPerm);
        if (!policyDecision) {
            String msg = "Denied: " + ejbRoleRefPerm + ", caller=" + this.callerSubject;
            if (this.trace) {
                log.trace("EJB Jacc Delegate:" + msg);
            }
        }
        return policyDecision ? 1 : -1;
    }

    private Principal[] getPrincipalSet() {
        Principal[] principals = null;
        if (this.trace) {
            log.trace("Roles used for checking from the context:" + this.securityContextRoles);
        }
        if (this.securityContextRoles != null) {
            HashSet<Principal> principalsSet = new HashSet<Principal>();
            Enumeration en = this.securityContextRoles.members();
            while (en.hasMoreElements()) {
                principalsSet.add((Principal)en.nextElement());
            }
            principals = new Principal[principalsSet.size()];
            principalsSet.toArray(principals);
        }
        return principals;
    }

    private boolean checkWithPolicy(Permission ejbPerm) {
        Principal[] principals = this.getPrincipalSet();
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
        return Policy.getPolicy().implies(pd, ejbPerm);
    }

    private Group getGroupFromRoleSet(Set<Principal> roleset) {
        SimpleGroup gp = new SimpleGroup("Roles");
        for (Principal p : roleset) {
            gp.addMember(p);
        }
        return gp;
    }
}

