/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.jacc;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.net.URL;
import java.security.Policy;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.security.jacc.DelegatingPolicy;
import org.jboss.security.jacc.JBossPolicyConfiguration;
import org.jboss.util.state.StateMachine;
import org.jboss.util.state.xml.StateMachineParser;

public class JBossPolicyConfigurationFactory
extends PolicyConfigurationFactory {
    private StateMachine configStateMachine;
    private ConcurrentReaderHashMap policyConfigMap = new ConcurrentReaderHashMap();
    private DelegatingPolicy policy;

    public JBossPolicyConfigurationFactory() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            URL states = loader.getResource("org/jboss/security/jacc/jacc-policy-config-states.xml");
            StateMachineParser smp = new StateMachineParser();
            this.configStateMachine = smp.parse(states);
        }
        catch (Exception e) {
            IllegalStateException ex = new IllegalStateException("Failed to parse jacc-policy-config-states.xml", e);
            ex.initCause(e);
            throw ex;
        }
        Policy p = Policy.getPolicy();
        if (!(p instanceof DelegatingPolicy)) {
            p = DelegatingPolicy.getInstance();
        }
        this.policy = (DelegatingPolicy)p;
    }

    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get((Object)contextID);
        if (pc == null) {
            StateMachine sm = (StateMachine)this.configStateMachine.clone();
            pc = new JBossPolicyConfiguration(contextID, this.policy, sm);
            this.policyConfigMap.put((Object)contextID, (Object)pc);
        }
        pc.initPolicyConfiguration(remove);
        return pc;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        boolean inService = false;
        JBossPolicyConfiguration pc = (JBossPolicyConfiguration)this.policyConfigMap.get((Object)contextID);
        if (pc != null) {
            inService = pc.inService();
        }
        return inService;
    }
}

