/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.TransactionManagerInitializer;
import org.jboss.tm.TransactionManagerServiceMBean;
import org.jboss.tm.XAExceptionFormatter;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.integrity.TransactionIntegrityFactory;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.RecoveryLoggerInstance;

public class TransactionManagerService
extends ServiceMBeanSupport
implements TransactionManagerServiceMBean {
    private ObjectName xidFactory;
    private TransactionManagerInitializer initializer = new TransactionManagerInitializer();
    public static String JNDI_NAME = "java:/TransactionManager";
    public static String JNDI_IMPORTER = "java:/TransactionPropagationContextImporter";
    public static String JNDI_EXPORTER = "java:/TransactionPropagationContextExporter";

    protected void startService() throws Exception {
        XidFactoryMBean xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        this.initializer.setXidFactory(xidFactoryObj);
        this.initializer.start();
    }

    protected void stopService() {
        this.initializer.stop();
    }

    public void setRecoveryLogger(RecoveryLoggerInstance recoveryLogger) {
        this.initializer.setRecoveryLogger(recoveryLogger.getInstance());
    }

    public void setTransactionIntegrityFactory(TransactionIntegrityFactory factory) {
        this.initializer.setTransactionIntegrityFactory(factory);
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    public void setRecoveryLogger(RecoveryLogger recoveryLogger) {
        this.initializer.setRecoveryLogger(recoveryLogger);
    }

    public boolean getGlobalIdsEnabled() {
        return this.initializer.getGlobalIdsEnabled();
    }

    public void setGlobalIdsEnabled(boolean newValue) {
        this.initializer.setGlobalIdsEnabled(newValue);
    }

    public boolean isInterruptThreads() {
        return this.initializer.isInterruptThreads();
    }

    public void setInterruptThreads(boolean interruptThreads) {
        this.initializer.setInterruptThreads(interruptThreads);
    }

    public int getTransactionTimeout() {
        return this.initializer.getTransactionTimeout();
    }

    public void setTransactionTimeout(int timeout) {
        this.initializer.setTransactionTimeout(timeout);
    }

    public int getCompletionRetryLimit() {
        return this.initializer.getCompletionRetryLimit();
    }

    public void setCompletionRetryLimit(int limit) {
        this.initializer.setCompletionRetryLimit(limit);
    }

    public int getCompletionRetryTimeout() {
        return this.initializer.getCompletionRetryTimeout();
    }

    public void setCompletionRetryTimeout(int timeout) {
        this.initializer.setCompletionRetryTimeout(timeout);
    }

    public int getXARetryTimeout() {
        return this.initializer.getXARetryTimeout();
    }

    public void setXARetryTimeout(int timeout) {
        this.initializer.setXARetryTimeout(timeout);
    }

    public int getPreparedTimeout() {
        return this.initializer.getPreparedTimeout();
    }

    public void setPreparedTimeout(int timeout) {
        this.initializer.setPreparedTimeout(timeout);
    }

    public boolean isRootBranchRemembersHeuristicDecisions() {
        return this.initializer.isRootBranchRemembersHeuristicDecisions();
    }

    public void setRootBranchRemembersHeuristicDecisions(boolean newValue) {
        this.initializer.setRootBranchRemembersHeuristicDecisions(newValue);
    }

    public boolean isReportHeuristicHazardAsHeuristicMixed() {
        return this.initializer.isReportHeuristicHazardAsHeuristicMixed();
    }

    public void setReportHeuristicHazardAsHeuristicMixed(boolean newValue) {
        this.initializer.setReportHeuristicHazardAsHeuristicMixed(newValue);
    }

    public TransactionManager getTransactionManager() {
        return this.initializer.getTransactionManager();
    }

    public JBossXATerminator getXATerminator() {
        return this.initializer.getXATerminator();
    }

    public long getTransactionCount() {
        return this.initializer.getTransactionCount();
    }

    public long getCommitCount() {
        return this.initializer.getCommitCount();
    }

    public long getRollbackCount() {
        return this.initializer.getRollbackCount();
    }

    public String listInDoubtTransactions() {
        return this.initializer.listInDoubtTransactions();
    }

    public void heuristicallyCommit(long localTransactionId) {
        this.initializer.heuristicallyCommit(localTransactionId);
    }

    public void heuristicallyCommitAll() {
        this.initializer.heuristicallyCommitAll();
    }

    public void heuristicallyRollback(long localTransactionId) {
        this.initializer.heuristicallyRollback(localTransactionId);
    }

    public void heuristicallyRollbackAll() {
        this.initializer.heuristicallyRollbackAll();
    }

    public String listHeuristicallyCompletedTransactions() {
        return this.initializer.listHeuristicallyCompletedTransactions();
    }

    public void forget(long localTransactionId) {
        this.initializer.forget(localTransactionId);
    }

    public void forgetAll() {
        this.initializer.forgetAll();
    }

    public void registerXAExceptionFormatter(Class clazz, XAExceptionFormatter formatter) {
        this.initializer.registerXAExceptionFormatter(clazz, formatter);
    }

    public void unregisterXAExceptionFormatter(Class clazz) {
        this.initializer.unregisterXAExceptionFormatter(clazz);
    }
}

