/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.transaction.xa.Xid;
import org.jboss.tm.XidFactoryBase;
import org.jboss.tm.recovery.BatchRecoveryLogReader;
import org.jboss.tm.recovery.BatchWriter;
import org.jboss.tm.recovery.HeuristicStatus;
import org.jboss.tm.recovery.HeuristicStatusLog;
import org.jboss.tm.recovery.HeuristicStatusLogReader;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.LogRestarter;
import org.jboss.tm.recovery.RecoveryLogReader;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.SimpleHeuristicStatusLogReader;
import org.jboss.tm.recovery.TxCompletionHandler;

public class BatchRecoveryLogger
implements RecoveryLogger {
    private String[] stringDirectoryList;
    private File[] directoryList;
    private int logFileSize;
    private File[] existingRecoveryLogFiles;
    private BatchWriter[] writers;
    private int numWriters;
    private volatile int seqNo = 0;
    private String heuristicStatusLogDirectoryName;
    private File heuristicStatusLogDirectory;
    private File[] existingHeuristicStatusLogFiles;
    private HeuristicStatusLog heuristicStatusLogger;
    private XidFactoryBase xidFactory;
    private LogRestarter logCleaner;

    String[] getDirectoryList() {
        return this.stringDirectoryList;
    }

    public void setDirectoryList(String[] directoryList) {
        this.stringDirectoryList = directoryList;
        File[] list2 = new File[directoryList.length];
        for (int i = 0; i < directoryList.length; ++i) {
            list2[i] = new File(directoryList[i]);
            list2[i] = list2[i].getAbsoluteFile();
            if (list2[i].exists() || list2[i].mkdirs()) continue;
            throw new RuntimeException("Unable to create recovery directory: " + directoryList[i]);
        }
        this.directoryList = list2;
    }

    int getLogFileSize() {
        return this.logFileSize;
    }

    public void setLogFileSize(int logFileSize) {
        this.logFileSize = logFileSize;
    }

    String getHeuristicStatusLogDirectory() {
        return this.heuristicStatusLogDirectoryName;
    }

    public void setHeuristicStatusLogDirectory(String heuristicStatusLogDirectoryName) {
        this.heuristicStatusLogDirectoryName = heuristicStatusLogDirectoryName;
        this.heuristicStatusLogDirectory = new File(heuristicStatusLogDirectoryName);
        this.heuristicStatusLogDirectory = this.heuristicStatusLogDirectory.getAbsoluteFile();
        if (!this.heuristicStatusLogDirectory.exists() && !this.heuristicStatusLogDirectory.mkdirs()) {
            throw new RuntimeException("Unable to create heuristic status log directory: " + heuristicStatusLogDirectoryName);
        }
    }

    XidFactoryBase getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(XidFactoryBase xidFactory) {
        this.xidFactory = xidFactory;
    }

    public void start() throws Exception {
        ArrayList<File> list2 = new ArrayList<File>();
        for (int i = 0; i < this.directoryList.length; ++i) {
            File dir = this.directoryList[i];
            File[] files = dir.listFiles();
            for (int j = 0; j < files.length; ++j) {
                list2.add(files[j]);
            }
        }
        this.existingRecoveryLogFiles = list2.toArray(new File[list2.size()]);
        this.logCleaner = new LogRestarter();
        new Thread((Runnable)this.logCleaner, "Log file cleaner").start();
        this.writers = new BatchWriter[this.directoryList.length];
        String branchQualifier = this.xidFactory.getBranchQualifier();
        for (int i = 0; i < this.directoryList.length; ++i) {
            this.writers[i] = new BatchWriter(branchQualifier, this.logFileSize / 128, this.directoryList[i], this.logFileSize, this.logCleaner);
            new Thread((Runnable)this.writers[i], "Batch Recovery Log " + i).start();
        }
        this.numWriters = this.writers.length;
        this.existingHeuristicStatusLogFiles = this.heuristicStatusLogDirectory.listFiles();
        this.heuristicStatusLogger = new HeuristicStatusLog(this.heuristicStatusLogDirectory);
    }

    public void stop() throws Exception {
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].stop();
        }
        this.logCleaner.stop();
        this.heuristicStatusLogger.close();
    }

    public TxCompletionHandler saveCommitDecision(long localTransactionId, String[] resources) {
        if (resources == null || resources.length == 0) {
            ByteBuffer buffer = LogRecord.createTxCommittedRecord(localTransactionId);
            return this.writers[++this.seqNo % this.numWriters].addBatch(buffer, false);
        }
        ByteBuffer buffer = LogRecord.createTxCommittedRecord(localTransactionId, resources);
        return this.writers[++this.seqNo % this.numWriters].addBatch(buffer, true);
    }

    public TxCompletionHandler savePrepareDecision(long localTransactionId, int inboundFormatId, byte[] globalTransactionId, String recoveryCoordinator, String[] resources) {
        ByteBuffer buffer = LogRecord.createTxPreparedRecord(localTransactionId, inboundFormatId, globalTransactionId, recoveryCoordinator, resources);
        return this.writers[++this.seqNo % this.numWriters].addBatch(buffer, true);
    }

    public TxCompletionHandler savePrepareDecision(long localTransactionId, Xid inboundXid, String[] resources) {
        ByteBuffer buffer = LogRecord.createJcaTxPreparedRecord(localTransactionId, inboundXid, resources);
        return this.writers[++this.seqNo % this.numWriters].addBatch(buffer, true);
    }

    public void saveHeuristicStatus(long localTransactionId, boolean foreignTx, int formatId, byte[] globalTransactionId, byte[] inboundBranchQualifier, int transactionStatus, int heurStatusCode, boolean locallyDetectedHeuristicHazard, int[] xaResourceHeuristics, HeuristicStatus[] remoteResourceHeuristics) {
        ByteBuffer buffer = LogRecord.createHeurStatusRecord(localTransactionId, foreignTx, formatId, globalTransactionId, inboundBranchQualifier, transactionStatus, heurStatusCode, locallyDetectedHeuristicHazard, xaResourceHeuristics, remoteResourceHeuristics);
        this.heuristicStatusLogger.write(buffer);
    }

    public void clearHeuristicStatus(long localTransactionId) {
        ByteBuffer buffer = LogRecord.createHeurForgottenRecord(localTransactionId);
        this.heuristicStatusLogger.write(buffer);
    }

    public RecoveryLogReader[] getRecoveryLogs() {
        if (this.existingRecoveryLogFiles == null || this.existingRecoveryLogFiles.length == 0) {
            return null;
        }
        RecoveryLogReader[] readers = new RecoveryLogReader[this.existingRecoveryLogFiles.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = new BatchRecoveryLogReader(this.existingRecoveryLogFiles[i], this.xidFactory);
        }
        return readers;
    }

    public HeuristicStatusLogReader[] getHeuristicStatusLogs() {
        if (this.existingHeuristicStatusLogFiles == null || this.existingHeuristicStatusLogFiles.length == 0) {
            return null;
        }
        HeuristicStatusLogReader[] readers = new HeuristicStatusLogReader[this.existingHeuristicStatusLogFiles.length];
        for (int i = 0; i < readers.length; ++i) {
            readers[i] = new SimpleHeuristicStatusLogReader(this.existingHeuristicStatusLogFiles[i]);
        }
        return readers;
    }
}

