/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Adler32;
import javax.transaction.xa.Xid;
import org.jboss.tm.TxUtils;
import org.jboss.tm.recovery.CorruptedLogRecordException;
import org.jboss.tm.recovery.HeuristicStatus;

public class LogRecord {
    public static final byte[] HEADER = "Log".getBytes();
    public static final int HEADER_LEN = HEADER.length;
    private static final byte[] NULL_HEADER = new byte[]{0, 0, 0};
    private static final int SIZEOF_BYTE = 1;
    static final int SIZEOF_SHORT = 2;
    private static final int SIZEOF_LONG = 8;
    private static final int FORMAT_ID_LEN = 4;
    private static final int CHKSUM_LEN = 4;
    static final int FULL_HEADER_LEN = HEADER_LEN + 4;
    static final byte TX_COMMITTED = 67;
    static final byte MULTI_TM_TX_COMMITTED = 77;
    static final byte TX_PREPARED = 80;
    static final byte JCA_TX_PREPARED = 82;
    static final byte TX_END = 69;
    static final byte HEUR_STATUS = 72;
    static final byte HEUR_FORGOTTEN = 70;
    private static final int SIZEOF_DIR_ENTRY = 4;
    private static final int MIN_MULTI_TM_TX_COMMITTED_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 2 + 4;
    private static final int MIN_TX_PREPARED_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 2 + 4 + 2 + 4;
    private static final int TX_COMMITED_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 4;
    static final int TX_END_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 4;
    private static final int MIN_HEUR_STATUS_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 2 + 1 + 1 + 1 + 1 + 4 + 2 + 4 + 4 + 4;
    static final int HEUR_FORGOTTEN_LEN = HEADER_LEN + 2 + 2 + 1 + 8 + 4;

    private LogRecord() {
    }

    static ByteBuffer createTxCommittedRecord(long localTransactionId) {
        ByteBuffer buffer = ByteBuffer.allocate(TX_COMMITED_LEN);
        buffer.put(HEADER).putShort((short)(TX_COMMITED_LEN - FULL_HEADER_LEN)).putShort((short)(-(TX_COMMITED_LEN - FULL_HEADER_LEN))).put((byte)67).putLong(localTransactionId);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, 9);
        buffer.putInt(TX_COMMITED_LEN - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    static ByteBuffer createTxCommittedRecord(long localTransactionId, String[] resources) {
        int recordLen = MIN_MULTI_TM_TX_COMMITTED_LEN;
        int resourceCount = 0;
        if (resources != null && (resourceCount = resources.length) > 0) {
            for (int i = 0; i < resourceCount; ++i) {
                recordLen += 4 + resources[i].length();
            }
        } else {
            throw new RuntimeException("No remote resources were specified");
        }
        ByteBuffer buffer = ByteBuffer.allocate(recordLen);
        buffer.put(HEADER).putShort((short)(recordLen - FULL_HEADER_LEN)).putShort((short)(-(recordLen - FULL_HEADER_LEN))).put((byte)77).putLong(localTransactionId).putShort((short)resourceCount);
        for (int i = 0; i < resourceCount; ++i) {
            int offset = buffer.position();
            int length = resources[i].length();
            byte[] resourceBytes = new byte[length];
            resources[i].getBytes(0, length, resourceBytes, 0);
            buffer.put(resourceBytes).putShort(recordLen - 4 - 2 - 4 * i, (short)length).putShort(recordLen - 4 - 4 - 4 * i, (short)offset);
        }
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, recordLen - FULL_HEADER_LEN - 4);
        buffer.putInt(recordLen - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    private static ByteBuffer createTxPreparedRecord(long localTransactionId, int inboundFormatId, byte[] globalTransactionId, boolean jcaInboundTransaction, byte[] recoveryCoordOrInboundBranchQual, String[] resources) {
        int recordLen = MIN_TX_PREPARED_LEN;
        int globalTxIdLen = 0;
        int resourceCount = 0;
        if (globalTransactionId != null && (globalTxIdLen = globalTransactionId.length) > 0) {
            recordLen += globalTxIdLen;
        } else {
            throw new RuntimeException("The global transaction id was not specified");
        }
        if (resources != null && (resourceCount = resources.length) > 0) {
            for (int i = 0; i < resourceCount; ++i) {
                recordLen += 4 + resources[i].length();
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(recordLen += 4 + recoveryCoordOrInboundBranchQual.length);
        buffer.put(HEADER).putShort((short)(recordLen - FULL_HEADER_LEN)).putShort((short)(-(recordLen - FULL_HEADER_LEN))).put(jcaInboundTransaction ? (byte)82 : 80).putLong(localTransactionId).putShort((short)(resourceCount + 1)).putInt(inboundFormatId).putShort((short)globalTxIdLen).put(globalTransactionId);
        int offset = buffer.position();
        int length = recoveryCoordOrInboundBranchQual.length;
        buffer.put(recoveryCoordOrInboundBranchQual).putShort(recordLen - 4 - 2, (short)length).putShort(recordLen - 4 - 4, (short)offset);
        int i = 0;
        while (i < resourceCount) {
            offset = buffer.position();
            length = resources[i].length();
            byte[] byteArray = new byte[length];
            resources[i].getBytes(0, length, byteArray, 0);
            buffer.put(byteArray).putShort(recordLen - 4 - 2 - 4 * ++i, (short)length).putShort(recordLen - 4 - 4 - 4 * i, (short)offset);
        }
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, recordLen - FULL_HEADER_LEN - 4);
        buffer.putInt(recordLen - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    static ByteBuffer createTxPreparedRecord(long localTransactionId, int inboundFormatId, byte[] globalTransactionId, String recoveryCoordinator, String[] resources) {
        int len = recoveryCoordinator.length();
        byte[] coordinatorByteArray = new byte[len];
        recoveryCoordinator.getBytes(0, len, coordinatorByteArray, 0);
        return LogRecord.createTxPreparedRecord(localTransactionId, inboundFormatId, globalTransactionId, false, coordinatorByteArray, resources);
    }

    static ByteBuffer createJcaTxPreparedRecord(long localTransactionId, Xid inboundXid, String[] resources) {
        return LogRecord.createTxPreparedRecord(localTransactionId, inboundXid.getFormatId(), inboundXid.getGlobalTransactionId(), true, inboundXid.getBranchQualifier(), resources);
    }

    static ByteBuffer createTxEndRecord(long localTransactionId) {
        ByteBuffer buffer = ByteBuffer.allocate(TX_END_LEN);
        buffer.put(HEADER).putShort((short)(TX_END_LEN - FULL_HEADER_LEN)).putShort((short)(-(TX_END_LEN - FULL_HEADER_LEN))).put((byte)69).putLong(localTransactionId);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, 9);
        buffer.putInt(TX_END_LEN - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    static ByteBuffer createHeurStatusRecord(long localTransactionId, boolean foreignTx, int formatId, byte[] globalTransactionId, byte[] inboundBranchQualifier, int transactionStatus, int heurStatusCode, boolean locallyDetectedHeuristicHazard, int[] xaResourceHeuristics, HeuristicStatus[] remoteResourceHeuristics) {
        int length;
        int recordLen = MIN_HEUR_STATUS_LEN;
        int globalTxIdLen = 0;
        int remoteResourceHeuristicsCount = 0;
        if (globalTransactionId != null) {
            globalTxIdLen = globalTransactionId.length;
            recordLen += globalTxIdLen;
        }
        if (inboundBranchQualifier != null) {
            recordLen += inboundBranchQualifier.length;
        }
        if (xaResourceHeuristics != null) {
            recordLen += xaResourceHeuristics.length;
        }
        if (remoteResourceHeuristics != null) {
            remoteResourceHeuristicsCount = remoteResourceHeuristics.length;
            for (int i = 0; i < remoteResourceHeuristicsCount; ++i) {
                recordLen += 5 + remoteResourceHeuristics[i].resourceRef.length();
            }
        }
        ByteBuffer buffer = ByteBuffer.allocate(recordLen);
        buffer.put(HEADER).putShort((short)(recordLen - FULL_HEADER_LEN)).putShort((short)(-(recordLen - FULL_HEADER_LEN))).put((byte)72).putLong(localTransactionId).putShort((short)(remoteResourceHeuristicsCount + 2)).put((byte)transactionStatus).put((byte)heurStatusCode).put(locallyDetectedHeuristicHazard ? (byte)1 : 0).put(foreignTx ? (byte)1 : 0).putInt(formatId).putShort((short)globalTxIdLen).put(globalTransactionId);
        int offset = buffer.position();
        int n = length = inboundBranchQualifier == null ? 0 : inboundBranchQualifier.length;
        if (length > 0) {
            buffer.put(inboundBranchQualifier);
        }
        buffer.putShort(recordLen - 4 - 2, (short)length).putShort(recordLen - 4 - 4, (short)offset);
        offset = buffer.position();
        int n2 = length = xaResourceHeuristics == null ? 0 : xaResourceHeuristics.length;
        if (length > 0) {
            byte[] xaResHeurCodes = new byte[length];
            for (int i = 0; i < length; ++i) {
                xaResHeurCodes[i] = (byte)xaResourceHeuristics[i];
            }
            buffer.put(xaResHeurCodes);
        }
        buffer.putShort(recordLen - 4 - 2 - 4, (short)length).putShort(recordLen - 4 - 4 - 4, (short)offset);
        for (int i = 0; i < remoteResourceHeuristicsCount; ++i) {
            String resourceRef = remoteResourceHeuristics[i].resourceRef;
            offset = buffer.position();
            length = resourceRef.length() + 1;
            byte[] heurStatus = new byte[length];
            heurStatus[0] = (byte)remoteResourceHeuristics[i].code;
            resourceRef.getBytes(0, resourceRef.length(), heurStatus, 1);
            buffer.put(heurStatus).putShort(recordLen - 4 - 2 - 4 * (i + 2), (short)length).putShort(recordLen - 4 - 4 - 4 * (i + 2), (short)offset);
        }
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, recordLen - FULL_HEADER_LEN - 4);
        buffer.putInt(recordLen - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    static ByteBuffer createHeurForgottenRecord(long localTransactionId) {
        ByteBuffer buffer = ByteBuffer.allocate(HEUR_FORGOTTEN_LEN);
        buffer.put(HEADER).putShort((short)(HEUR_FORGOTTEN_LEN - FULL_HEADER_LEN)).putShort((short)(-(HEUR_FORGOTTEN_LEN - FULL_HEADER_LEN))).put((byte)70).putLong(localTransactionId);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), FULL_HEADER_LEN, 9);
        buffer.putInt(TX_END_LEN - 4, (int)checksum.getValue());
        return (ByteBuffer)buffer.position(0);
    }

    static void getData(ByteBuffer buffer, int recLen, Data data) {
        if (recLen > buffer.limit()) {
            return;
        }
        int checksumField = buffer.getInt(recLen - 4);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), 0, recLen - 4);
        if ((int)checksum.getValue() != checksumField) {
            throw new CorruptedLogRecordException("Wrong checksum.");
        }
        data.recordType = buffer.get();
        switch (data.recordType) {
            case 77: {
                data.localTransactionId = buffer.getLong();
                int countOfDirEntries = buffer.getShort();
                data.resources = new String[countOfDirEntries];
                for (int i = 0; i < countOfDirEntries; ++i) {
                    short length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    short offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    offset = (short)(offset - FULL_HEADER_LEN);
                    data.resources[i] = new String(buffer.array(), 0, (int)offset, (int)length);
                }
                data.globalTransactionId = null;
                data.inboundFormatId = -1;
                data.recoveryCoordinator = null;
                data.inboundBranchQualifier = null;
                break;
            }
            case 80: 
            case 82: {
                data.localTransactionId = buffer.getLong();
                int countOfDirEntries = buffer.getShort();
                data.inboundFormatId = buffer.getInt();
                short gidLength = buffer.getShort();
                data.globalTransactionId = new byte[gidLength];
                buffer.get(data.globalTransactionId);
                short length = buffer.getShort(recLen - 4 - 2);
                short offset = buffer.getShort(recLen - 4 - 4);
                offset = (short)(offset - FULL_HEADER_LEN);
                if (data.recordType == 80) {
                    data.recoveryCoordinator = new String(buffer.array(), 0, (int)offset, (int)length);
                    data.inboundBranchQualifier = null;
                } else {
                    data.recoveryCoordinator = null;
                    data.inboundBranchQualifier = new byte[length];
                    buffer.get(data.inboundBranchQualifier);
                }
                data.resources = new String[countOfDirEntries - 1];
                for (int i = 1; i < countOfDirEntries; ++i) {
                    length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    offset = (short)(offset - FULL_HEADER_LEN);
                    data.resources[i - 1] = new String(buffer.array(), 0, (int)offset, (int)length);
                }
                break;
            }
            case 67: 
            case 69: {
                data.localTransactionId = buffer.getLong();
                data.globalTransactionId = null;
                data.inboundFormatId = -1;
                data.recoveryCoordinator = null;
                data.inboundBranchQualifier = null;
                data.resources = null;
                break;
            }
            case 70: 
            case 72: {
                throw new RuntimeException("Log record with unexpected type");
            }
            default: {
                throw new RuntimeException("Log record with invalid type");
            }
        }
    }

    static void getHeurData(ByteBuffer buffer, int recLen, HeurData data) {
        if (recLen > buffer.limit()) {
            return;
        }
        int checksumField = buffer.getInt(recLen - 4);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), 0, recLen - 4);
        if ((int)checksum.getValue() != checksumField) {
            throw new CorruptedLogRecordException("Wrong checksum.");
        }
        data.recordType = buffer.get();
        switch (data.recordType) {
            case 72: {
                data.localTransactionId = buffer.getLong();
                int countOfDirEntries = buffer.getShort();
                data.transactionStatus = buffer.get();
                data.heuristicStatusCode = buffer.get();
                data.locallyDetectedHeuristicHazard = buffer.get() != 0;
                data.foreignTx = buffer.get() != 0;
                data.formatId = buffer.getInt();
                short gidLength = buffer.getShort();
                data.globalTransactionId = new byte[gidLength];
                buffer.get(data.globalTransactionId);
                int length = buffer.getShort(recLen - 4 - 2);
                short offset = buffer.getShort(recLen - 4 - 4);
                offset = (short)(offset - FULL_HEADER_LEN);
                if (length == 0) {
                    data.inboundBranchQualifier = null;
                } else {
                    data.inboundBranchQualifier = new byte[length];
                    buffer.get(data.inboundBranchQualifier);
                }
                length = buffer.getShort(recLen - 4 - 2 - 4);
                offset = buffer.getShort(recLen - 4 - 4 - 4);
                offset = (short)(offset - FULL_HEADER_LEN);
                if (length == 0) {
                    data.xaResourceHeuristics = null;
                } else {
                    byte[] xaResHeurCodes = new byte[length];
                    buffer.position(offset);
                    buffer.get(xaResHeurCodes);
                    data.xaResourceHeuristics = new int[length];
                    for (int i = 0; i < length; ++i) {
                        data.xaResourceHeuristics[i] = xaResHeurCodes[i];
                    }
                }
                data.remoteResourceHeuristics = countOfDirEntries > 2 ? new HeuristicStatus[countOfDirEntries - 2] : null;
                for (int i = 2; i < countOfDirEntries; ++i) {
                    length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    offset = (short)(offset - FULL_HEADER_LEN);
                    byte remoteResourceHeurCode = buffer.get(offset);
                    String remoteResourceRef = new String(buffer.array(), 0, offset + 1, length - 1);
                    data.remoteResourceHeuristics[i - 2] = new HeuristicStatus(remoteResourceHeurCode, remoteResourceRef);
                }
                break;
            }
            case 70: {
                data.localTransactionId = buffer.getLong();
                data.heuristicStatusCode = 0;
                data.xaResourceHeuristics = null;
                data.remoteResourceHeuristics = null;
                break;
            }
            case 67: 
            case 69: 
            case 77: 
            case 80: 
            case 82: {
                throw new RuntimeException("Log record with unexpected type");
            }
            default: {
                throw new RuntimeException("Log record with invalid type");
            }
        }
    }

    static int getNextRecordLength(ByteBuffer buffer, int currentRecordLength) {
        buffer.position(currentRecordLength);
        if (buffer.remaining() < FULL_HEADER_LEN) {
            return 0;
        }
        byte[] header = new byte[HEADER_LEN];
        buffer.get(header);
        if (!Arrays.equals(header, HEADER)) {
            if (Arrays.equals(header, NULL_HEADER)) {
                return 0;
            }
            throw new CorruptedLogRecordException("Invalid header.");
        }
        short recLen = buffer.getShort();
        short recLenCheck = buffer.getShort();
        if (recLenCheck != -recLen) {
            throw new CorruptedLogRecordException("Record lenght check failed.");
        }
        return recLen;
    }

    static boolean hasValidChecksum(byte[] buf) {
        int bufLen = buf.length;
        int checksumField = ByteBuffer.wrap(buf).getInt(bufLen - 4);
        Adler32 checksum = new Adler32();
        checksum.update(buf, 0, bufLen - 4);
        return (int)checksum.getValue() == checksumField;
    }

    static String toString(ByteBuffer buffer) {
        int recLen = buffer.limit();
        buffer.position(FULL_HEADER_LEN);
        StringBuffer sb = new StringBuffer("Record Info:\n    Type: ");
        byte recordType = buffer.get();
        switch (recordType) {
            case 77: {
                sb.append("MULTI_TM_TX_COMMITTED\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                int countOfDirEntries = buffer.getShort();
                if (countOfDirEntries <= 0) break;
                sb.append("    Resources:\n");
                for (int i = 0; i < countOfDirEntries; ++i) {
                    short length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    short offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    sb.append("        ");
                    sb.append(new String(buffer.array(), 0, (int)offset, (int)length));
                    sb.append("\n");
                }
                break;
            }
            case 80: {
                sb.append("TX_PREPARED\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                int countOfDirEntries = buffer.getShort();
                sb.append("    Inbound format id: ");
                sb.append(buffer.getInt());
                sb.append("\n");
                short gidLen = buffer.getShort();
                sb.append("    Global transaction id: ");
                byte[] gid = new byte[gidLen];
                buffer.get(gid);
                sb.append(new String(gid, 0));
                sb.append("\n");
                sb.append("    Recovery coordinator: ");
                short length = buffer.getShort(recLen - 4 - 2);
                short offset = buffer.getShort(recLen - 4 - 4);
                sb.append(new String(buffer.array(), 0, (int)offset, (int)length));
                sb.append("\n");
                if (countOfDirEntries <= 1) break;
                sb.append("    Resources:\n");
                for (int i = 1; i < countOfDirEntries; ++i) {
                    length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    sb.append("        ");
                    sb.append(new String(buffer.array(), 0, (int)offset, (int)length));
                }
                break;
            }
            case 82: {
                sb.append("JCA_TX_PREPARED\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                int countOfDirEntries = buffer.getShort();
                sb.append("    Inbound format id: ");
                sb.append(buffer.getInt());
                sb.append("\n");
                short gidLen = buffer.getShort();
                sb.append("    Global transaction id: ");
                byte[] gid = new byte[gidLen];
                buffer.get(gid);
                sb.append(new String(gid, 0));
                sb.append("\n");
                sb.append("    Inbound branch qualifier: ");
                short length = buffer.getShort(recLen - 4 - 2);
                short offset = buffer.getShort(recLen - 4 - 4);
                sb.append(new String(buffer.array(), 0, (int)offset, (int)length));
                sb.append("\n");
                if (countOfDirEntries <= 1) break;
                sb.append("    Resources:\n");
                for (int i = 1; i < countOfDirEntries; ++i) {
                    length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    sb.append("        ");
                    sb.append(new String(buffer.array(), 0, (int)offset, (int)length));
                }
                break;
            }
            case 67: {
                sb.append("TX_COMMITTED\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                break;
            }
            case 69: {
                sb.append("TX_END\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                break;
            }
            case 72: {
                int i;
                short offset;
                sb.append("HEUR_STATUS\n");
                sb.append("    Local transaction id: ");
                sb.append(buffer.getLong());
                sb.append("\n");
                int countOfDirEntries = buffer.getShort();
                sb.append("    Transaction status: ");
                byte status = buffer.get();
                sb.append(TxUtils.getStatusAsString(status));
                sb.append("\n");
                sb.append("    Heuristic status: ");
                byte heurCode = buffer.get();
                if (heurCode != 0) {
                    sb.append(TxUtils.getXAErrorCodeAsString(heurCode));
                } else {
                    sb.append("NONE");
                }
                sb.append("\n");
                sb.append("    Locally-detected heuristic hazard: ");
                sb.append(buffer.get() != 0 ? "yes" : "no");
                sb.append("\n");
                sb.append("    Foreign transaction: ");
                boolean foreignTransaction = buffer.get() != 0;
                sb.append(foreignTransaction ? "yes" : "no");
                sb.append("\n");
                sb.append(foreignTransaction ? "    Inbound format id: " : "    Format id: ");
                sb.append(buffer.getInt());
                sb.append("\n");
                short gidLen = buffer.getShort();
                sb.append("    Global transaction id: ");
                byte[] gid = new byte[gidLen];
                buffer.get(gid);
                sb.append(new String(gid, 0));
                sb.append("\n");
                int length = buffer.getShort(recLen - 4 - 2);
                if (length > 0) {
                    sb.append("    Inbound branch qualifier: ");
                    offset = buffer.getShort(recLen - 4 - 4);
                    sb.append(new String(buffer.array(), 0, (int)offset, length));
                    sb.append("\n");
                }
                if ((length = buffer.getShort(recLen - 4 - 2 - 4)) > 0) {
                    offset = buffer.getShort(recLen - 4 - 4 - 4);
                    sb.append("    XAResource heuristics:\n");
                    for (i = 0; i < length; ++i) {
                        sb.append("        ");
                        heurCode = buffer.get(offset + i);
                        sb.append(TxUtils.getXAErrorCodeAsString(heurCode));
                        sb.append("\n");
                    }
                }
                if (countOfDirEntries <= 2) break;
                sb.append("    Remote resource heuristics:\n");
                for (i = 2; i < countOfDirEntries; ++i) {
                    length = buffer.getShort(recLen - 4 - 2 - 4 * i);
                    offset = buffer.getShort(recLen - 4 - 4 - 4 * i);
                    heurCode = buffer.get(offset);
                    sb.append("        ");
                    sb.append(TxUtils.getXAErrorCodeAsString(heurCode));
                    sb.append(" - ");
                    sb.append(new String(buffer.array(), 0, offset + 1, length - 1));
                    sb.append("\n");
                }
                break;
            }
            case 70: {
                sb.append("HEUR_FORGOTTEN\n");
                sb.append("Local transaction id: ");
                sb.append(buffer.getLong(FULL_HEADER_LEN + 1));
                sb.append("\n");
                break;
            }
            default: {
                sb.append("INVALID\n");
            }
        }
        buffer.position(0);
        return sb.toString();
    }

    public static class HeurData {
        public byte recordType;
        public long localTransactionId;
        public boolean foreignTx;
        public int formatId;
        public byte[] globalTransactionId;
        public byte[] inboundBranchQualifier;
        public int transactionStatus;
        public int heuristicStatusCode;
        public boolean locallyDetectedHeuristicHazard;
        public int[] xaResourceHeuristics;
        public HeuristicStatus[] remoteResourceHeuristics;
    }

    public static class Data {
        public byte recordType;
        public long localTransactionId;
        public byte[] globalTransactionId;
        public int inboundFormatId;
        public String recoveryCoordinator;
        public byte[] inboundBranchQualifier;
        public String[] resources;
    }
}

