/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.recovery;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import javax.management.ObjectName;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.LocalId;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.recovery.XidFactoryInitializationServiceMBean;

public class XidFactoryInitializationService
extends ServiceMBeanSupport
implements XidFactoryInitializationServiceMBean {
    private ObjectName xidFactory;
    private String filename;
    private int nextTxGenerationNumber = 0;

    protected void startService() throws Exception {
        super.startService();
        XidFactoryMBean xidFactoryObj = (XidFactoryMBean)this.getServer().getAttribute(this.xidFactory, "Instance");
        File nextTxGenerationFile = new File(this.filename);
        nextTxGenerationFile = nextTxGenerationFile.getAbsoluteFile();
        if (!nextTxGenerationFile.createNewFile()) {
            FileInputStream in = new FileInputStream(nextTxGenerationFile);
            DataInputStream dataIn = new DataInputStream(in);
            int txGenNumberFromFile = dataIn.readInt();
            int checksumFromFile = dataIn.readInt();
            dataIn.close();
            ByteBuffer buffer = ByteBuffer.allocate(4);
            buffer.putInt(txGenNumberFromFile);
            Adler32 checksum = new Adler32();
            checksum.update(buffer.array(), 0, 4);
            if ((int)checksum.getValue() != checksumFromFile) {
                throw new RuntimeException("Incorrect checksum in file " + nextTxGenerationFile + ". Could not " + "obtain the next transaction " + "generation number.");
            }
            File backupFile = new File(this.filename + ".bak");
            backupFile.delete();
            nextTxGenerationFile.renameTo(backupFile);
            this.nextTxGenerationNumber = txGenNumberFromFile;
        }
        xidFactoryObj.setGlobalIdNumber(LocalId.assemble(this.nextTxGenerationNumber, 0L));
        ++this.nextTxGenerationNumber;
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(this.nextTxGenerationNumber);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), 0, 4);
        FileOutputStream out = new FileOutputStream(nextTxGenerationFile);
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.writeInt(this.nextTxGenerationNumber);
        dataOut.writeInt((int)checksum.getValue());
        dataOut.flush();
        out.getFD().sync();
        dataOut.close();
    }

    public ObjectName getXidFactory() {
        return this.xidFactory;
    }

    public void setXidFactory(ObjectName xidFactory) {
        this.xidFactory = xidFactory;
    }

    public String getNextTxGenerationFile() {
        return this.filename;
    }

    public void setNextTxGenerationFile(String filename) {
        this.filename = filename;
    }

    public int getNextTxGenerationNumber() {
        return this.nextTxGenerationNumber;
    }
}

