/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.mgmt;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventSource
implements Serializable {
    private State state;
    private long maxExpirationTime = -1L;
    private String name;
    private URI nameSpace;
    private URI managerAddress;
    private List<URI> supportedFilter = new ArrayList<URI>();
    private String[] notificationSchema;
    private String notificationRootElementNS;

    public EventSource(String name, URI nameSpace) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.state = State.CREATED;
    }

    public EventSource(String name, URI nameSpace, String[] schema, String notificationRootElementNS) {
        this.name = name;
        this.nameSpace = nameSpace;
        this.notificationSchema = schema;
        this.notificationRootElementNS = notificationRootElementNS;
        this.state = State.CREATED;
    }

    State getState() {
        return this.state;
    }

    void setState(State state) {
        if (state == State.STARTED) {
            this.assertConfiguration();
        }
        this.state = state;
    }

    private void assertConfiguration() {
        if (this.getManagerAddress() == null) {
            throw new IllegalArgumentException("SubscriptionManager address unknown. Unable to start event source.");
        }
    }

    long getMaxExpirationTime() {
        return this.maxExpirationTime;
    }

    void setMaxExpirationTime(long maxExpirationTime) {
        this.maxExpirationTime = maxExpirationTime;
    }

    public List<URI> getSupportedFilterDialects() {
        return this.supportedFilter;
    }

    public String[] getNotificationSchema() {
        return this.notificationSchema;
    }

    public String getName() {
        return this.name;
    }

    public URI getNameSpace() {
        return this.nameSpace;
    }

    public URI getManagerAddress() {
        return this.managerAddress;
    }

    public String getNotificationRootElementNS() {
        return this.notificationRootElementNS;
    }

    public void setManagerAddress(String managerAddress) {
        try {
            if (managerAddress != null) {
                this.managerAddress = new URI(managerAddress);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal subscription manager endpoint address: " + e.getMessage());
        }
    }

    public String toString() {
        return "EventSource {nameSpace=" + this.nameSpace + ", state=" + (Object)((Object)this.state) + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        CREATED,
        STARTED,
        STOPED,
        DESTROYED;

    }
}

