/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.GenericInterceptorFactory;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.PointcutExpression;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ParseException;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;

public class AdviceBinding {
    private static volatile long counter = 0L;
    protected String name;
    protected Pointcut pointcut;
    protected ASTCFlowExpression cflow;
    protected String cflowString;
    protected Collection advisors = new HashSet();
    protected InterceptorFactory[] interceptorFactories = new InterceptorFactory[0];

    public AdviceBinding() {
    }

    public AdviceBinding(String name, Pointcut p, ASTCFlowExpression cflow, String cflowString, InterceptorFactory[] factories) throws ParseException {
        this.name = name;
        this.interceptorFactories = factories;
        this.cflow = cflow;
        this.pointcut = p;
        this.cflowString = cflowString;
    }

    public AdviceBinding(String pointcutExpression, String cflow) throws ParseException {
        this(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression, cflow);
    }

    public AdviceBinding(String name, String pointcutExpression, String cflow) throws ParseException {
        this.name = name;
        this.setPointcutExpression(pointcutExpression);
        this.setCFlowExpression(cflow);
        this.interceptorFactories = new InterceptorFactory[0];
    }

    public void setCFlowExpression(String cflow) throws ParseException {
        if (cflow != null) {
            this.cflowString = cflow;
            this.cflow = new PointcutExpressionParser(new StringReader(this.cflowString)).CFlowExpression();
        }
    }

    public void setPointcutExpression(String pointcutExpression) throws ParseException {
        this.pointcut = new PointcutExpression(Long.toString(System.currentTimeMillis()) + ":" + Long.toString(counter++), pointcutExpression);
    }

    public void addInterceptorFactory(InterceptorFactory factory) {
        List<InterceptorFactory> list2 = Arrays.asList(this.interceptorFactories);
        list2 = new ArrayList<InterceptorFactory>(list2);
        list2.add(factory);
        this.interceptorFactories = list2.toArray(new InterceptorFactory[list2.size()]);
    }

    public void addInterceptor(Class clazz) {
        this.addInterceptorFactory(new GenericInterceptorFactory(clazz));
    }

    public String getName() {
        return this.name;
    }

    public InterceptorFactory[] getInterceptorFactories() {
        return this.interceptorFactories;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdvisor(Advisor advisor) {
        if (AspectManager.verbose) {
            System.out.println("[debug] added advisor: " + advisor.getName() + " from binding: " + this.name);
        }
        Collection collection = this.advisors;
        synchronized (collection) {
            if (this.advisors.size() > 0) {
                Iterator it = this.advisors.iterator();
                while (it.hasNext()) {
                    WeakReference ref = (WeakReference)it.next();
                    Object obj = ref.get();
                    if (obj == null) {
                        it.remove();
                        continue;
                    }
                    if (!obj.equals(advisor)) continue;
                    return;
                }
            }
            this.advisors.add(new WeakReference<Advisor>(advisor));
        }
    }

    public boolean hasAdvisors() {
        return this.advisors.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getAdvisors() {
        ArrayList list2 = new ArrayList(this.advisors.size());
        Collection collection = this.advisors;
        synchronized (collection) {
            Iterator it = this.advisors.iterator();
            while (it.hasNext()) {
                WeakReference ref = (WeakReference)it.next();
                Object advisor = ref.get();
                if (advisor != null) {
                    list2.add(advisor);
                    continue;
                }
                it.remove();
            }
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAdvisors() {
        Collection collection = this.advisors;
        synchronized (collection) {
            for (WeakReference ref : this.advisors) {
                Advisor advisor;
                Object obj = ref.get();
                if (obj == null || !(advisor = (Advisor)obj).getManager().isAdvisorRegistered(advisor)) continue;
                advisor.removeAdviceBinding(this);
            }
            this.advisors.clear();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdviceBinding)) {
            return false;
        }
        return ((AdviceBinding)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public ASTCFlowExpression getCFlow() {
        return this.cflow;
    }

    public String getCFlowString() {
        return this.cflowString;
    }
}

