/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.integration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ConstructorInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocation;
import org.jboss.aop.proxy.container.AOPProxyFactory;
import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
import org.jboss.aop.proxy.container.ContainerCache;
import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
import org.jboss.joinpoint.plugins.BasicConstructorJoinPoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.context.MetaDataContext;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.stack.MetaDataStack;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.TypeInfo;

public class AOPConstructorJoinpoint
extends BasicConstructorJoinPoint
implements KernelControllerContextAware {
    private static final String[] EMPTY_PARAM_ARRAY = new String[0];
    AOPProxyFactory proxyFactory = new GeneratedAOPProxyFactory();
    KernelControllerContext context;

    public AOPConstructorJoinpoint(org.jboss.reflect.spi.ConstructorInfo constructorInfo) {
        super(constructorInfo);
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch() throws Throwable {
        Class clazz = this.constructorInfo.getDeclaringClass().getType();
        AspectManager manager = AspectManager.instance();
        MetaData metaData = MetaDataStack.peek();
        MetaDataStack.mask();
        try {
            boolean hasInstanceMetaData = this.hasInstanceOrJoinpointMetaData(metaData);
            ContainerCache cache = ContainerCache.initialise(manager, clazz, metaData, hasInstanceMetaData);
            AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
            Object target = this.createTarget(cache, params);
            params.setProxiedClass(target.getClass());
            params.setMetaData(metaData);
            params.setTarget(target);
            params.setContainerCache(cache);
            params.setMetaDataHasInstanceLevelData(hasInstanceMetaData);
            Object object = this.proxyFactory.createAdvisedProxy(params);
            return object;
        }
        finally {
            MetaDataStack.unmask();
        }
    }

    private boolean hasInstanceOrJoinpointMetaData(MetaData metaData) {
        if (metaData == null) {
            return false;
        }
        MetaDataRetrieval retrieval = null;
        if (this.context != null) {
            Kernel kernel = this.context.getKernel();
            KernelMetaDataRepository repository = kernel.getMetaDataRepository();
            retrieval = repository.getMetaDataRetrieval(this.context);
            if (retrieval instanceof MetaDataContext) {
                ScopeKey instanceKey = new ScopeKey(CommonLevels.INSTANCE, (String)this.context.getName());
                List<MetaDataRetrieval> retrievals = ((MetaDataContext)retrieval).getLocalRetrievals();
                for (MetaDataRetrieval ret : retrievals) {
                    Annotation[] anns;
                    ScopeKey key = ret.getScope();
                    if (!instanceKey.equals(key) || (anns = (Annotation[])ret.retrieveAnnotations().getValue()) == MetaData.NO_ANNOTATIONS) continue;
                    return true;
                }
            }
            if (this.hasMethodMetaData(metaData)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasMethodMetaData(MetaData metaData) {
        for (ClassInfo info = this.constructorInfo.getDeclaringClass(); info != null; info = info.getSuperclass()) {
            MethodInfo[] methods = info.getDeclaredMethods();
            if (methods == null) continue;
            for (MethodInfo mi : methods) {
                if (!this.methodHasAnnotations(metaData, mi)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean methodHasAnnotations(MetaData metaData, MethodInfo mi) {
        TypeInfo[] types = mi.getParameterTypes();
        String[] typeStrings = null;
        if (types.length == 0) {
            typeStrings = EMPTY_PARAM_ARRAY;
        } else {
            typeStrings = new String[types.length];
            for (int j = 0; j < types.length; ++j) {
                typeStrings[j] = types[j].getName();
            }
        }
        MethodSignature sig = new MethodSignature(mi.getName(), typeStrings);
        MetaData methodMD = metaData.getComponentMetaData(sig);
        if (methodMD != null) {
            return methodMD.getAnnotations() != MetaData.NO_ANNOTATIONS;
        }
        return false;
    }

    private Object createTarget(ContainerCache cache, AOPProxyFactoryParameters params) throws Throwable {
        Advisor advisor = cache.getAdvisor();
        if (advisor != null) {
            Interceptor[] interceptors;
            ConstructorInfo aopinfo = this.findAopConstructorInfo(advisor);
            Interceptor[] interceptorArray = interceptors = aopinfo != null ? aopinfo.getInterceptors() : null;
            if (interceptors != null) {
                ConstructorInvocation inv = new ConstructorInvocation(aopinfo, aopinfo.getInterceptors());
                inv.setArguments(this.getArguments());
                return inv.invokeNext();
            }
            if (this.getConstructorInfo().getParameterTypes().length > 0) {
                Constructor<?> constructor = null;
                if (aopinfo == null) {
                    Constructor<?>[] ctors;
                    Class clazz = advisor.getClazz();
                    for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
                        if (!this.matchConstructor(ctor)) continue;
                        constructor = ctor;
                        break;
                    }
                } else {
                    constructor = aopinfo.getConstructor();
                }
                params.setCtor(constructor.getParameterTypes(), this.getArguments());
            }
        }
        return super.dispatch();
    }

    private ConstructorInfo findAopConstructorInfo(Advisor advisor) {
        ConstructorInfo[] infos = advisor.getConstructorInfos();
        for (int i = 0; i < infos.length; ++i) {
            if (!this.matchConstructor(infos[i].getConstructor())) continue;
            return infos[i];
        }
        return null;
    }

    private boolean matchConstructor(Constructor ctor) {
        Class<?>[] ctorParams;
        TypeInfo[] params = this.constructorInfo.getParameterTypes();
        if (params.length == (ctorParams = ctor.getParameterTypes()).length) {
            boolean match = true;
            for (int p = 0; p < params.length; ++p) {
                if (params[p].getName().equals(ctorParams[p].getName())) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
        }
        return false;
    }
}

