/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.vfs.StructureDeployer;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicStructuredDeployers
implements StructuredDeployers {
    private SortedSet<StructureDeployer> structureDeployers;

    public BasicStructuredDeployers() {
        this(new TreeSet<StructureDeployer>(StructureDeployer.COMPARATOR));
    }

    public BasicStructuredDeployers(SortedSet<StructureDeployer> structureDeployers) {
        this.structureDeployers = structureDeployers;
    }

    @Override
    public boolean isEmpty() {
        return this.structureDeployers == null ? true : this.structureDeployers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean determineStructure(VirtualFile file, StructureMetaData metaData) throws DeploymentException {
        StructureDeployer[] theDeployers;
        BasicStructuredDeployers basicStructuredDeployers = this;
        synchronized (basicStructuredDeployers) {
            if (this.structureDeployers.isEmpty()) {
                throw new IllegalStateException("No structure deployers");
            }
            theDeployers = this.structureDeployers.toArray(new StructureDeployer[this.structureDeployers.size()]);
        }
        boolean result = false;
        for (StructureDeployer deployer : theDeployers) {
            if (!deployer.determineStructure(file, metaData, this)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public SortedSet<StructureDeployer> getDeployers() {
        return this.structureDeployers;
    }

    public void setDeployers(Set<StructureDeployer> deployers) {
        HashSet<StructureDeployer> oldDeployers = new HashSet<StructureDeployer>(this.structureDeployers);
        oldDeployers.removeAll(deployers);
        for (StructureDeployer deployer : oldDeployers) {
            this.removeDeployer(deployer);
        }
        HashSet<StructureDeployer> newDeployers = new HashSet<StructureDeployer>(deployers);
        newDeployers.removeAll(this.structureDeployers);
        for (StructureDeployer deployer : newDeployers) {
            this.addDeployer(deployer);
        }
    }

    public synchronized void addDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.add(deployer);
    }

    public synchronized void removeDeployer(StructureDeployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("Null deployer");
        }
        this.structureDeployers.remove(deployer);
    }
}

