/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.deployers.plugins.attachments.AttachmentsImpl;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.classloader.ClassLoaderFactory;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployers.spi.structure.DeploymentContextVisitor;
import org.jboss.deployers.spi.structure.DeploymentState;
import org.jboss.deployers.spi.structure.StructureDetermined;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentDeploymentContext
implements DeploymentContext,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Logger log = Logger.getLogger(this.getClass());
    private String name;
    private DeploymentUnit unit;
    private DeploymentContext parent;
    private Set<DeploymentContext> components = new CopyOnWriteArraySet<DeploymentContext>();
    private transient Attachments transientAttachments = new AttachmentsImpl();
    private transient Attachments transientManagedObjects = new AttachmentsImpl();

    public ComponentDeploymentContext(String name, DeploymentContext parent) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSimpleName() {
        return this.parent.getSimpleName();
    }

    @Override
    public String getRelativePath() {
        return this.parent.getRelativePath();
    }

    @Override
    public Set<String> getTypes() {
        return this.parent.getTypes();
    }

    @Override
    public StructureDetermined getStructureDetermined() {
        return this.parent.getStructureDetermined();
    }

    @Override
    public void setStructureDetermined(StructureDetermined determined) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean isCandidate() {
        return this.parent.isCandidate();
    }

    @Override
    public DeploymentState getState() {
        return this.parent.getState();
    }

    @Override
    public void setState(DeploymentState state) {
        this.parent.setState(state);
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        if (this.unit == null) {
            throw new IllegalStateException("Deployment unit has not been set");
        }
        return this.unit;
    }

    @Override
    public void setDeploymentUnit(DeploymentUnit unit) {
        this.unit = unit;
    }

    @Override
    public VirtualFile getRoot() {
        return this.parent.getRoot();
    }

    public void setRoot(VirtualFile root) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public void setMetaDataPath(String path) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public VirtualFile getMetaDataLocation() {
        return this.parent.getMetaDataLocation();
    }

    @Override
    public void setMetaDataLocation(VirtualFile location) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.parent.getClassLoader();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        return false;
    }

    @Override
    public void removeClassLoader() {
    }

    @Override
    public List<VirtualFile> getClassPath() {
        return this.parent.getClassPath();
    }

    @Override
    public void setClassPath(List<VirtualFile> paths) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean isTopLevel() {
        return false;
    }

    @Override
    public DeploymentContext getTopLevel() {
        return this.parent.getTopLevel();
    }

    @Override
    public DeploymentContext getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DeploymentContext parent) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public Set<DeploymentContext> getChildren() {
        return Collections.emptySet();
    }

    @Override
    public void addChild(DeploymentContext child) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean removeChild(DeploymentContext child) {
        throw new UnsupportedOperationException("Not supported for components");
    }

    @Override
    public boolean isComponent() {
        return true;
    }

    @Override
    public Set<DeploymentContext> getComponents() {
        return Collections.unmodifiableSet(this.components);
    }

    @Override
    public void addComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        this.components.add(component);
    }

    @Override
    public boolean removeComponent(DeploymentContext component) {
        if (component == null) {
            throw new IllegalArgumentException("Null component");
        }
        return this.components.remove(component);
    }

    @Override
    public void visit(DeploymentContextVisitor visitor) throws DeploymentException {
        if (visitor == null) {
            throw new IllegalArgumentException("Null visitor");
        }
        this.visit(this, visitor);
    }

    private void visit(DeploymentContext context, DeploymentContextVisitor visitor) throws DeploymentException {
        visitor.visit(context);
        try {
            Set<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            DeploymentContext[] childContexts = children.toArray(new DeploymentContext[children.size()]);
            for (int i = 0; i < childContexts.length; ++i) {
                if (childContexts[i] == null) {
                    throw new IllegalStateException("Null child context for " + context.getName() + " children=" + children);
                }
                try {
                    this.visit(childContexts[i], visitor);
                    continue;
                }
                catch (Throwable t) {
                    for (int j = i - 1; j >= 0; --j) {
                        this.visitError(childContexts[j], visitor, true);
                    }
                    throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + childContexts[i].getName(), t);
                }
            }
        }
        catch (Throwable t) {
            this.visitError(context, visitor, false);
            throw DeploymentException.rethrowAsDeploymentException("Error visiting: " + context.getName(), t);
        }
    }

    private void visitError(DeploymentContext context, DeploymentContextVisitor visitor, boolean visitChildren) throws DeploymentException {
        if (visitChildren) {
            Set<DeploymentContext> children = context.getChildren();
            if (children.isEmpty()) {
                return;
            }
            for (DeploymentContext child : children) {
                try {
                    this.visitError(child, visitor, true);
                }
                catch (Throwable t) {
                    this.log.warn("Error during visit error: " + child.getName(), t);
                }
            }
        }
        try {
            visitor.error(context);
        }
        catch (Throwable t) {
            this.log.warn("Error during visit error: " + context.getName(), t);
        }
    }

    @Override
    public Attachments getPredeterminedManagedObjects() {
        return this.parent.getPredeterminedManagedObjects();
    }

    @Override
    public void setPredeterminedManagedObjects(Attachments objects) {
    }

    @Override
    public Attachments getTransientManagedObjects() {
        return this.transientManagedObjects;
    }

    @Override
    public Attachments getTransientAttachments() {
        return this.transientAttachments;
    }

    @Override
    public Throwable getProblem() {
        return this.parent.getProblem();
    }

    @Override
    public void setProblem(Throwable problem) {
        this.parent.setProblem(problem);
    }

    @Override
    public VirtualFile getMetaDataFile(String name) {
        return this.parent.getMetaDataFile(name);
    }

    @Override
    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        return this.parent.getMetaDataFiles(name, suffix);
    }

    @Override
    public void deployed() {
        this.parent.deployed();
    }

    @Override
    public boolean isDeployed() {
        return this.parent.isDeployed();
    }

    @Override
    public void reset() {
        this.components.clear();
        this.transientManagedObjects.clear();
        this.transientAttachments.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('@');
        buffer.append(System.identityHashCode(this));
        buffer.append('{').append(this.name).append('}');
        return buffer.toString();
    }
}

