/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.management.ObjectName;
import javax.transaction.Transaction;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.EJBProxyFactoryContainer;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityCache;
import org.jboss.ejb.EntityContainerMBean;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.GlobalTxEntityMap;
import org.jboss.ejb.InstanceCache;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.InstancePoolContainer;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.metadata.EntityMetaData;
import org.jboss.monitor.StatisticsProvider;
import org.jboss.proxy.ejb.ClusterProxyFactory;
import org.jboss.util.UnreachableStatementException;
import org.jboss.util.collection.SerializableEnumeration;

public class EntityContainer
extends Container
implements EJBProxyFactoryContainer,
InstancePoolContainer,
EntityContainerMBean {
    protected Map homeMapping = new HashMap();
    protected Map beanMapping = new HashMap();
    protected EntityPersistenceManager persistenceManager;
    protected InstanceCache instanceCache;
    protected InstancePool instancePool;
    protected Interceptor interceptor;
    protected boolean readOnly = false;
    protected static GlobalTxEntityMap globalTxEntityMap = new GlobalTxEntityMap();

    public static GlobalTxEntityMap getGlobalTxEntityMap() {
        return globalTxEntityMap;
    }

    public static void synchronizeEntitiesWithinTransaction(Transaction tx) {
        if (tx != null) {
            EntityContainer.getGlobalTxEntityMap().synchronizeEntities(tx);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public LocalProxyFactory getLocalProxyFactory() {
        return this.localProxyFactory;
    }

    public void setInstancePool(InstancePool ip) {
        if (ip == null) {
            throw new IllegalArgumentException("Null pool");
        }
        this.instancePool = ip;
        ip.setContainer(this);
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public void setInstanceCache(InstanceCache ic) {
        if (ic == null) {
            throw new IllegalArgumentException("Null cache");
        }
        this.instanceCache = ic;
        ic.setContainer(this);
    }

    public InstanceCache getInstanceCache() {
        return this.instanceCache;
    }

    public EntityPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void setPersistenceManager(EntityPersistenceManager pm) {
        if (pm == null) {
            throw new IllegalArgumentException("Null persistence manager");
        }
        this.persistenceManager = pm;
        pm.setContainer(this);
    }

    public void addInterceptor(Interceptor in) {
        if (this.interceptor == null) {
            this.interceptor = in;
        } else {
            Interceptor current = this.interceptor;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(in);
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Class getHomeClass() {
        return this.homeInterface;
    }

    public Class getRemoteClass() {
        return this.remoteInterface;
    }

    public Object createBeanClassInstance() throws Exception {
        return this.persistenceManager.createBeanClassInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            Hashtable props;
            ObjectName containerName;
            if (this.metaData.getHome() != null) {
                this.homeInterface = this.classLoader.loadClass(this.metaData.getHome());
            }
            if (this.metaData.getRemote() != null) {
                this.remoteInterface = this.classLoader.loadClass(this.metaData.getRemote());
            }
            super.createService();
            this.checkCoherency();
            this.setupBeanMapping();
            this.setupHomeMapping();
            this.setupMarshalledInvocationMapping();
            try {
                containerName = super.getJmxName();
                props = containerName.getKeyPropertyList();
                props.put("plugin", "pool");
                ObjectName poolName = new ObjectName(containerName.getDomain(), props);
                this.server.registerMBean(this.instancePool, poolName);
            }
            catch (Throwable t) {
                this.log.debug("Failed to register cache as mbean", t);
            }
            this.instancePool.create();
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.create();
            }
            try {
                containerName = super.getJmxName();
                props = containerName.getKeyPropertyList();
                props.put("plugin", "cache");
                ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
                this.server.registerMBean(this.instanceCache, cacheName);
            }
            catch (Throwable t) {
                this.log.debug("Failed to register cache as mbean", t);
            }
            this.instanceCache.create();
            this.persistenceManager.create();
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.setContainer(this);
                in.create();
            }
            this.readOnly = ((EntityMetaData)this.metaData).isReadOnly();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.startService();
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.start();
            }
            this.instanceCache.start();
            this.instancePool.start();
            for (Interceptor i = this.interceptor; i != null; i = i.getNext()) {
                i.start();
            }
            this.restoreTimers();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.stop();
            }
            this.instancePool.stop();
            this.persistenceManager.stop();
            this.instanceCache.stop();
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.stop();
            }
            super.stopService();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            Hashtable props;
            ObjectName containerName;
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                ci.destroy();
            }
            this.instanceCache.destroy();
            this.instanceCache.setContainer(null);
            try {
                containerName = super.getJmxName();
                props = containerName.getKeyPropertyList();
                props.put("plugin", "cache");
                ObjectName cacheName = new ObjectName(containerName.getDomain(), props);
                this.server.unregisterMBean(cacheName);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            this.persistenceManager.destroy();
            this.persistenceManager.setContainer(null);
            this.instancePool.destroy();
            this.instancePool.setContainer(null);
            try {
                containerName = super.getJmxName();
                props = containerName.getKeyPropertyList();
                props.put("plugin", "pool");
                ObjectName poolName = new ObjectName(containerName.getDomain(), props);
                this.server.unregisterMBean(poolName);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
                in.destroy();
                in.setContainer(null);
            }
            MarshalledInvocation.removeHashes(this.homeInterface);
            MarshalledInvocation.removeHashes(this.remoteInterface);
            super.destroyService();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    public Object internalInvokeHome(Invocation mi) throws Exception {
        Method method = mi.getMethod();
        if (method != null && method.getName().equals("remove")) {
            InvocationType type = mi.getType();
            if (type == InvocationType.HOME) {
                mi.setType(InvocationType.REMOTE);
            } else if (type == InvocationType.LOCALHOME) {
                mi.setType(InvocationType.LOCAL);
            }
            mi.setMethod(EJBOBJECT_REMOVE);
            Object arg = mi.getArguments()[0];
            if (arg instanceof Handle) {
                if (arg == null) {
                    throw new RemoteException("Null handle");
                }
                Handle handle = (Handle)arg;
                EJBObject ejbObject = handle.getEJBObject();
                mi.setId(ejbObject.getPrimaryKey());
            } else {
                mi.setId(arg);
            }
            mi.setArguments(new Object[0]);
            return this.getInterceptor().invoke(mi);
        }
        return this.getInterceptor().invokeHome(mi);
    }

    public Object internalInvoke(Invocation mi) throws Exception {
        return this.getInterceptor().invoke(mi);
    }

    public void remove(Invocation mi) throws RemoteException, RemoveException {
        Transaction tx = mi.getTransaction();
        if (!this.getBeanMetaData().getContainerConfiguration().getSyncOnCommitOnly()) {
            EntityContainer.synchronizeEntitiesWithinTransaction(tx);
        }
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        this.getPersistenceManager().removeEntity(ctx);
        Object pk = ctx.getId();
        this.removeTimerService(pk);
        ctx.setId(null);
        ++this.removeCount;
    }

    public Handle getHandle(Invocation mi) throws RemoteException {
        throw new Error("Not yet implemented");
    }

    public Object getPrimaryKey(Invocation mi) throws RemoteException {
        return mi.getId();
    }

    public EJBHome getEJBHome(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return (EJBHome)ci.getEJBHome();
    }

    public boolean isIdentical(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return ci.isIdentical(this, mi);
    }

    public EJBLocalHome getEJBLocalHome(Invocation mi) {
        return this.localProxyFactory.getEJBLocalHome();
    }

    public void removeLocalHome(Invocation mi) throws RemoteException, RemoveException {
        throw new Error("Not Yet Implemented");
    }

    public EJBLocalObject createLocalHome(Invocation mi) throws Exception {
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        this.getPersistenceManager().createEntity(mi.getMethod(), mi.getArguments(), ctx);
        ++this.createCount;
        return this.localProxyFactory.getEntityEJBLocalObject(ctx.getId(), true);
    }

    public void postCreateLocalHome(Invocation mi) throws Exception {
        this.getPersistenceManager().postCreateEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
    }

    public Object findLocal(Invocation mi) throws Exception {
        Method method = mi.getMethod();
        Object[] args = mi.getArguments();
        EntityEnterpriseContext instance = (EntityEnterpriseContext)mi.getEnterpriseContext();
        boolean syncOnCommitOnly = this.metaData.getContainerConfiguration().getSyncOnCommitOnly();
        Transaction tx = mi.getTransaction();
        Class<?> returnType = method.getReturnType();
        if (Collection.class.isAssignableFrom(returnType) || returnType == Enumeration.class) {
            if (!syncOnCommitOnly) {
                EntityContainer.synchronizeEntitiesWithinTransaction(tx);
            }
            Collection c = this.getPersistenceManager().findEntities(method, args, instance, this.localProxyFactory);
            if (returnType == Enumeration.class) {
                return Collections.enumeration(c);
            }
            return c;
        }
        return this.findSingleObject(tx, method, args, instance, this.localProxyFactory);
    }

    public Object find(Invocation mi) throws Exception {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        Method method = mi.getMethod();
        Object[] args = mi.getArguments();
        EntityEnterpriseContext instance = (EntityEnterpriseContext)mi.getEnterpriseContext();
        boolean syncOnCommitOnly = this.metaData.getContainerConfiguration().getSyncOnCommitOnly();
        Transaction tx = mi.getTransaction();
        Class<?> returnType = method.getReturnType();
        if (Collection.class.isAssignableFrom(returnType) || returnType == Enumeration.class) {
            if (!syncOnCommitOnly) {
                EntityContainer.synchronizeEntitiesWithinTransaction(tx);
            }
            Collection c = this.getPersistenceManager().findEntities(method, args, instance, ci);
            if (returnType == Enumeration.class) {
                return new SerializableEnumeration(c);
            }
            return c;
        }
        return this.findSingleObject(tx, method, args, instance, ci);
    }

    public void invokeEjbStore(EntityEnterpriseContext ctx) throws Exception {
        if (ctx.getId() != null) {
            EntityPersistenceManager pm = this.getPersistenceManager();
            pm.invokeEjbStore(ctx);
        }
    }

    public void storeEntity(EntityEnterpriseContext ctx) throws Exception {
        EntityPersistenceManager pm;
        if (ctx.getId() != null && (pm = this.getPersistenceManager()).isStoreRequired(ctx)) {
            pm.storeEntity(ctx);
        }
    }

    public void postCreateHome(Invocation mi) throws Exception {
        this.getPersistenceManager().postCreateEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
    }

    public EJBObject createHome(Invocation mi) throws Exception {
        this.getPersistenceManager().createEntity(mi.getMethod(), mi.getArguments(), (EntityEnterpriseContext)mi.getEnterpriseContext());
        ++this.createCount;
        return ((EntityEnterpriseContext)mi.getEnterpriseContext()).getEJBObject();
    }

    public EJBObject getEJBObject(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return (EJBObject)ci.getEntityEJBObject(((EntityCache)this.instanceCache).createCacheKey(mi.getId()));
    }

    public void removeHome(Invocation mi) throws RemoteException, RemoveException {
        throw new Error("Not yet implemented");
    }

    public EJBMetaData getEJBMetaDataHome(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return ci.getEJBMetaData();
    }

    public HomeHandle getHomeHandleHome(Invocation mi) throws RemoteException {
        throw new Error("Not yet implemented");
    }

    public long getCacheSize() {
        return this.instanceCache.getCacheSize();
    }

    public void flushCache() {
        this.instanceCache.flush();
    }

    public Map retrieveStatistic() {
        HashMap lStatistics = new HashMap();
        StatisticsProvider lProvider = (StatisticsProvider)((Object)this.getPersistenceManager());
        lStatistics.putAll(lProvider.retrieveStatistic());
        lProvider = (StatisticsProvider)((Object)this.getInstancePool());
        lStatistics.putAll(lProvider.retrieveStatistic());
        return lStatistics;
    }

    public void resetStatistic() {
    }

    private void setupHomeMappingImpl(Method[] m, String finderName, String append) throws Exception {
        boolean isEJB1x = this.metaData.getApplicationMetaData().isEJB1x();
        for (int i = 0; i < m.length; ++i) {
            String methodName = m[i].getName();
            try {
                String ejbHomeMethodName = "ejbHome" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                this.homeMapping.put(m[i], this.beanClass.getMethod(ejbHomeMethodName, m[i].getParameterTypes()));
                continue;
            }
            catch (NoSuchMethodException ignore) {
                try {
                    if (methodName.startsWith("find")) {
                        this.homeMapping.put(m[i], this.getClass().getMethod(finderName, Invocation.class));
                        continue;
                    }
                    if (methodName.equals("create") || !isEJB1x && methodName.startsWith("create")) {
                        this.homeMapping.put(m[i], this.getClass().getMethod("create" + append, Invocation.class));
                        this.beanMapping.put(m[i], this.getClass().getMethod("postCreate" + append, Invocation.class));
                        continue;
                    }
                    this.homeMapping.put(m[i], this.getClass().getMethod(methodName + append, Invocation.class));
                    continue;
                }
                catch (NoSuchMethodException e) {
                    throw new NoSuchMethodException("Could not find matching method for " + m[i]);
                }
            }
        }
    }

    protected void setupHomeMapping() throws Exception {
        try {
            Method[] m;
            if (this.homeInterface != null) {
                m = this.homeInterface.getMethods();
                this.setupHomeMappingImpl(m, "find", "Home");
            }
            if (this.localHomeInterface != null) {
                m = this.localHomeInterface.getMethods();
                this.setupHomeMappingImpl(m, "findLocal", "LocalHome");
            }
            Class<?> handleClass = Class.forName("javax.ejb.Handle");
            Method[] handleMethods = handleClass.getMethods();
            for (int j = 0; j < handleMethods.length; ++j) {
                if (!handleMethods[j].getName().equals("getEJBObject")) continue;
                this.homeMapping.put(handleMethods[j], this.getClass().getMethod("getEJBObject", Invocation.class));
            }
        }
        catch (Exception e) {
            this.homeMapping.clear();
            this.beanMapping.clear();
            throw e;
        }
    }

    private void setupBeanMappingImpl(Method[] m, String intfName) throws Exception {
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getDeclaringClass().getName().equals(intfName)) {
                this.beanMapping.put(m[i], this.beanClass.getMethod(m[i].getName(), m[i].getParameterTypes()));
                continue;
            }
            this.beanMapping.put(m[i], this.getClass().getMethod(m[i].getName(), Invocation.class));
        }
    }

    protected void setupBeanMapping() throws Exception {
        try {
            Method[] m;
            if (this.remoteInterface != null) {
                m = this.remoteInterface.getMethods();
                this.setupBeanMappingImpl(m, "javax.ejb.EJBObject");
            }
            if (this.localInterface != null) {
                m = this.localInterface.getMethods();
                this.setupBeanMappingImpl(m, "javax.ejb.EJBLocalObject");
            }
            if (TimedObject.class.isAssignableFrom(this.beanClass)) {
                this.beanMapping.put(TimedObject.class.getMethod("ejbTimeout", Timer.class), this.beanClass.getMethod("ejbTimeout", Timer.class));
            }
        }
        catch (Exception e) {
            this.homeMapping.clear();
            this.beanMapping.clear();
            throw e;
        }
    }

    protected void setupMarshalledInvocationMapping() throws Exception {
        Method[] m;
        if (this.homeInterface != null) {
            m = this.homeInterface.getMethods();
            for (int i = 0; i < m.length; ++i) {
                this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[i])), m[i]);
            }
        }
        if (this.remoteInterface != null) {
            m = this.remoteInterface.getMethods();
            for (int j = 0; j < m.length; ++j) {
                this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[j])), m[j]);
            }
        }
        Method getEJBObjectMethod = Class.forName("javax.ejb.Handle").getMethod("getEJBObject", new Class[0]);
        this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(getEJBObjectMethod)), getEJBObjectMethod);
    }

    Interceptor createContainerInterceptor() {
        return new ContainerInterceptor();
    }

    protected void checkCoherency() throws Exception {
        if (this.metaData.isClustered()) {
            boolean clusteredProxyFactoryFound = false;
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                if (!(ci instanceof ClusterProxyFactory)) continue;
                clusteredProxyFactoryFound = true;
            }
            if (!clusteredProxyFactoryFound) {
                this.log.warn("*** EJB '" + this.metaData.getEjbName() + "' deployed as CLUSTERED but not a single clustered-invoker is bound to container ***");
            }
        }
    }

    private Object findSingleObject(Transaction tx, Method method, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws Exception {
        if (method.getName().equals("findByPrimaryKey")) {
            if (args[0] == null) {
                throw new IllegalArgumentException("findByPrimaryKey called with null argument.");
            }
            if (this.metaData.getContainerConfiguration().getCommitOption() != 1) {
                Object key = instance.getCacheKey();
                if (key == null) {
                    key = ((EntityCache)this.instanceCache).createCacheKey(args[0]);
                }
                if (this.instanceCache.isActive(key)) {
                    return factory.getEntityEJBObject(key);
                }
            }
        } else if (!this.metaData.getContainerConfiguration().getSyncOnCommitOnly()) {
            EntityContainer.synchronizeEntitiesWithinTransaction(tx);
        }
        return this.getPersistenceManager().findEntity(method, args, instance, factory);
    }

    class ContainerInterceptor
    extends Container.AbstractContainerInterceptor {
        ContainerInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invokeHome(Invocation mi) throws Exception {
            block9: {
                Method miMethod = mi.getMethod();
                Method m = (Method)EntityContainer.this.homeMapping.get(miMethod);
                if (m == null) {
                    String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                    throw new EJBException(msg);
                }
                if (m.getDeclaringClass().equals(EntityContainer.class)) {
                    try {
                        return mi.performCall(EntityContainer.this, m, new Object[]{mi});
                    }
                    catch (Exception e) {
                        this.rethrow(e);
                        break block9;
                    }
                }
                EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
                try {
                    AllowedOperationsAssociation.pushInMethodFlag(AllowedOperationsAssociation.IN_EJB_HOME);
                    Object object = mi.performCall(ctx.getInstance(), m, mi.getArguments());
                    return object;
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
                finally {
                    AllowedOperationsAssociation.popInMethodFlag();
                }
            }
            throw new UnreachableStatementException();
        }

        public Object invoke(Invocation mi) throws Exception {
            Method miMethod = mi.getMethod();
            Method m = (Method)EntityContainer.this.beanMapping.get(miMethod);
            if (m == null) {
                String msg = "Invalid invocation, check your deployment packaging, method=" + miMethod;
                throw new EJBException(msg);
            }
            if (m.getDeclaringClass().equals(EntityContainer.class)) {
                try {
                    return mi.performCall(EntityContainer.this, m, new Object[]{mi});
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            } else {
                try {
                    EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
                    Object instance = ctx.getInstance();
                    return mi.performCall(instance, m, mi.getArguments());
                }
                catch (Exception e) {
                    this.rethrow(e);
                }
            }
            throw new UnreachableStatementException();
        }
    }
}

