/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCParameterSetter;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCResultSetReader;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;

public final class JDBCUtil {
    private static final Logger log = Logger.getLogger(JDBCUtil.class.getName());
    private static final Map jdbcTypeNames;
    private static final Map csTypes;
    private static final String SQL_ERROR = "SQL error";
    private static final String GET_TIMESTAMP = "getTimestamp";
    private static final String GET_DATE = "getDate";
    private static final String GET_TIME = "getTime";
    private static final String GET_BIGDECIMAL = "getBigDecimal";
    private static final String GET_REF = "getRef";
    private static final String GET_STRING = "getString";
    private static final String GET_BOOLEAN = "getBoolean";
    private static final String GET_BYTE = "getByte";
    private static final String GET_SHORT = "getShort";
    private static final String GET_INT = "getInt";
    private static final String GET_LONG = "getLong";
    private static final String GET_FLOAT = "getFloat";
    private static final String GET_DOUBLE = "getDouble";
    private static final String GET_BYTES = "getBytes";

    public static void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static void safeClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static void safeClose(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static void safeClose(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                log.error(SQL_ERROR, e);
            }
        }
    }

    public static Object coerceToSQLType(int jdbcType, Object value) {
        if (value.getClass() == java.util.Date.class) {
            if (jdbcType == 91) {
                return new Date(((java.util.Date)value).getTime());
            }
            if (jdbcType == 92) {
                return new Time(((java.util.Date)value).getTime());
            }
            if (jdbcType == 93) {
                return new Timestamp(((java.util.Date)value).getTime());
            }
        } else if (value.getClass() == Character.class && jdbcType == 12) {
            value = value.toString();
        }
        return value;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] convertObjectToByteArray(Object value) throws SQLException {
        byte[] byArray;
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        try {
            if (value instanceof EJBObject) {
                value = ((EJBObject)value).getHandle();
            }
            value = new MarshalledValue(value);
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            byArray = baos.toByteArray();
        }
        catch (RemoteException e) {
            try {
                throw new SQLException("Cannot get Handle of EJBObject: " + e);
                catch (IOException e2) {
                    throw new SQLException("Can't serialize binary object: " + e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(oos);
                JDBCUtil.safeClose(baos);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(oos);
        JDBCUtil.safeClose(baos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertToObject(byte[] input) throws SQLException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        try {
            Object object = JDBCUtil.convertToObject(bais);
            return object;
        }
        finally {
            JDBCUtil.safeClose(bais);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object convertToObject(InputStream input) throws SQLException {
        Object value = null;
        if (input == null) return value;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(input);
            value = ois.readObject();
            if (value instanceof MarshalledValue) {
                value = ((MarshalledValue)value).get();
            } else if (value instanceof MarshalledObject) {
                value = ((MarshalledObject)value).get();
            }
            if (value instanceof Handle) {
                value = ((Handle)value).getEJBObject();
            }
        }
        catch (RemoteException e) {
            try {
                throw new SQLException("Unable to load EJBObject back from Handle: " + e);
                catch (IOException e2) {
                    throw new SQLException("Unable to load to deserialize result: " + e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new SQLException("Unable to load to deserialize result: " + e3);
                }
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ois);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ois);
        return value;
    }

    public static String getLongString(ResultSet rs, int index) throws SQLException {
        String value;
        Reader textData = rs.getCharacterStream(index);
        if (textData != null) {
            try {
                int charsRead;
                StringBuffer textBuffer = new StringBuffer();
                char[] tmpBuffer = new char[1000];
                while ((charsRead = textData.read(tmpBuffer)) != -1) {
                    textBuffer.append(tmpBuffer, 0, charsRead);
                }
                value = textBuffer.toString();
            }
            catch (IOException ioException) {
                throw new SQLException(ioException.getMessage());
            }
            finally {
                JDBCUtil.safeClose(textData);
            }
        } else {
            value = null;
        }
        return value;
    }

    public static byte[] getByteArray(InputStream input) throws SQLException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] tmpBuffer = new byte[1000];
            while ((bytesRead = input.read(tmpBuffer)) != -1) {
                baos.write(tmpBuffer, 0, bytesRead);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException ioException) {
            throw new SQLException(ioException.getMessage());
        }
        finally {
            JDBCUtil.safeClose(baos);
            JDBCUtil.safeClose(input);
        }
    }

    public static JDBCResultSetReader getResultSetReader(int jdbcType, Class destination) {
        JDBCResultSetReader reader;
        switch (jdbcType) {
            case 2005: {
                reader = JDBCResultSetReader.CLOB_READER;
                break;
            }
            case -1: {
                reader = JDBCResultSetReader.LONGVARCHAR_READER;
                break;
            }
            case -2: {
                reader = JDBCResultSetReader.BINARY_READER;
                break;
            }
            case -3: {
                reader = JDBCResultSetReader.VARBINARY_READER;
                break;
            }
            case 2004: {
                reader = JDBCResultSetReader.BLOB_READER;
                break;
            }
            case -4: {
                reader = JDBCResultSetReader.LONGVARBINARY_READER;
                break;
            }
            case 2000: {
                reader = JDBCResultSetReader.JAVA_OBJECT_READER;
                break;
            }
            case 2002: {
                reader = JDBCResultSetReader.STRUCT_READER;
                break;
            }
            case 2003: {
                reader = JDBCResultSetReader.ARRAY_READER;
                break;
            }
            case 1111: {
                reader = JDBCResultSetReader.OTHER_READER;
                break;
            }
            default: {
                reader = JDBCUtil.getResultReaderByType(destination);
            }
        }
        return reader;
    }

    public static JDBCResultSetReader getResultReaderByType(Class destination) {
        JDBCResultSetReader reader = destination == java.util.Date.class ? JDBCResultSetReader.JAVA_UTIL_DATE_READER : (destination == Date.class ? JDBCResultSetReader.JAVA_SQL_DATE_READER : (destination == Time.class ? JDBCResultSetReader.JAVA_SQL_TIME_READER : (destination == Timestamp.class ? JDBCResultSetReader.JAVA_SQL_TIMESTAMP_READER : (destination == BigDecimal.class ? JDBCResultSetReader.BIGDECIMAL_READER : (destination == Ref.class ? JDBCResultSetReader.REF_READER : (destination == String.class ? JDBCResultSetReader.STRING_READER : (destination == Boolean.class || destination == Boolean.TYPE ? JDBCResultSetReader.BOOLEAN_READER : (destination == Byte.class || destination == Byte.TYPE ? JDBCResultSetReader.BYTE_READER : (destination == Character.class || destination == Character.TYPE ? JDBCResultSetReader.CHARACTER_READER : (destination == Short.class || destination == Short.TYPE ? JDBCResultSetReader.SHORT_READER : (destination == Integer.class || destination == Integer.TYPE ? JDBCResultSetReader.INT_READER : (destination == Long.class || destination == Long.TYPE ? JDBCResultSetReader.LONG_READER : (destination == Float.class || destination == Float.TYPE ? JDBCResultSetReader.FLOAT_READER : (destination == Double.class || destination == Double.TYPE ? JDBCResultSetReader.DOUBLE_READER : JDBCResultSetReader.OBJECT_READER))))))))))))));
        return reader;
    }

    public static JDBCParameterSetter getParameterSetter(int jdbcType, Class javaType) {
        JDBCParameterSetter ps;
        switch (jdbcType) {
            case -1: 
            case 2005: {
                ps = JDBCParameterSetter.CLOB;
                break;
            }
            case -3: 
            case -2: {
                ps = JDBCParameterSetter.BINARY;
                break;
            }
            case -4: 
            case 2004: {
                ps = JDBCParameterSetter.BLOB;
                break;
            }
            case 2: 
            case 3: {
                ps = JDBCParameterSetter.NUMERIC;
                break;
            }
            default: {
                ps = JDBCParameterSetter.OBJECT;
            }
        }
        return ps;
    }

    public static String getJDBCTypeName(int jdbcType) {
        return (String)jdbcTypeNames.get(new Integer(jdbcType));
    }

    public static Object getParameter(Logger log, CallableStatement cs, int index, int jdbcType, Class destination) throws SQLException {
        Object value = null;
        switch (jdbcType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                throw new UnsupportedOperationException();
            }
            case -3: 
            case -2: {
                byte[] bytes = cs.getBytes(index);
                if (!cs.wasNull()) {
                    value = destination == byte[].class ? (Object)bytes : JDBCUtil.convertToObject(bytes);
                }
                if (!log.isTraceEnabled()) break;
                log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Binary, value=" + value);
                break;
            }
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                value = cs.getObject(index);
                if (!log.isTraceEnabled()) break;
                log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Object, value=" + value);
                break;
            }
            default: {
                Method method = (Method)csTypes.get(destination.getName());
                if (method != null) {
                    try {
                        value = method.invoke((Object)cs, new Integer(index));
                        if (cs.wasNull()) {
                            value = null;
                        }
                        if (!log.isTraceEnabled()) break;
                        log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Simple, value=" + value);
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (InvocationTargetException e) {}
                    break;
                }
                value = cs.getObject(index);
                if (!log.isTraceEnabled()) break;
                log.trace("Get result: index=" + index + ", javaType=" + destination.getName() + ", Object, value=" + value);
            }
        }
        return JDBCUtil.coerceToJavaType(value, destination);
    }

    private static Object coerceToJavaType(Object value, Class destination) throws SQLException {
        try {
            if (value == null) {
                return null;
            }
            if (value instanceof MarshalledObject && !destination.equals(MarshalledObject.class)) {
                value = ((MarshalledObject)value).get();
            }
            if (value instanceof Handle) {
                value = ((Handle)value).getEJBObject();
            }
            if (destination.isPrimitive()) {
                if (value == null) {
                    throw new IllegalStateException("Loaded NULL value for a field of a primitive type.");
                }
                if (destination.equals(Byte.TYPE) && value instanceof Byte || destination.equals(Short.TYPE) && value instanceof Short || destination.equals(Character.TYPE) && value instanceof Character || destination.equals(Boolean.TYPE) && value instanceof Boolean || destination.equals(Integer.TYPE) && value instanceof Integer || destination.equals(Long.TYPE) && value instanceof Long || destination.equals(Float.TYPE) && value instanceof Float || destination.equals(Double.TYPE) && value instanceof Double) {
                    return value;
                }
            }
            if (destination == java.util.Date.class && value instanceof java.util.Date) {
                if (value instanceof Timestamp) {
                    Timestamp ts = (Timestamp)value;
                    long temp = ts.getTime();
                    if (temp % 1000L == 0L) {
                        temp += (long)(ts.getNanos() / 1000000);
                    }
                    return new java.util.Date(temp);
                }
                return new java.util.Date(((java.util.Date)value).getTime());
            }
            if (destination == Time.class && value instanceof Time) {
                return new Time(((Time)value).getTime());
            }
            if (destination == Date.class && value instanceof Date) {
                return new Date(((Date)value).getTime());
            }
            if (destination == Timestamp.class && value instanceof Timestamp) {
                Timestamp orignal = (Timestamp)value;
                Timestamp copy = new Timestamp(orignal.getTime());
                copy.setNanos(orignal.getNanos());
                return copy;
            }
            if (value instanceof String && (destination == Character.class || destination == Character.TYPE)) {
                return new Character(((String)value).charAt(0));
            }
            if (destination.isAssignableFrom(value.getClass())) {
                return value;
            }
            if (destination == BigInteger.class && value.getClass() == BigDecimal.class) {
                return ((BigDecimal)value).toBigInteger();
            }
            throw new SQLException("Got a " + value.getClass().getName() + "[cl=" + System.identityHashCode(value.getClass().getClassLoader()) + ", value=" + value + "] while looking for a " + destination.getName() + "[cl=" + System.identityHashCode(destination) + "]");
        }
        catch (RemoteException e) {
            throw new SQLException("Unable to load EJBObject back from Handle: " + e);
        }
        catch (IOException e) {
            throw new SQLException("Unable to load to deserialize result: " + e);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Unable to load to deserialize result: " + e);
        }
    }

    static {
        Class[] arg = new Class[]{Integer.TYPE};
        csTypes = new HashMap();
        try {
            csTypes.put(java.util.Date.class.getName(), CallableStatement.class.getMethod(GET_TIMESTAMP, arg));
            csTypes.put(Date.class.getName(), CallableStatement.class.getMethod(GET_DATE, arg));
            csTypes.put(Time.class.getName(), CallableStatement.class.getMethod(GET_TIME, arg));
            csTypes.put(Timestamp.class.getName(), CallableStatement.class.getMethod(GET_TIMESTAMP, arg));
            csTypes.put(BigDecimal.class.getName(), CallableStatement.class.getMethod(GET_BIGDECIMAL, arg));
            csTypes.put(Ref.class.getName(), CallableStatement.class.getMethod(GET_REF, arg));
            csTypes.put(String.class.getName(), CallableStatement.class.getMethod(GET_STRING, arg));
            csTypes.put(Boolean.class.getName(), CallableStatement.class.getMethod(GET_BOOLEAN, arg));
            csTypes.put(Boolean.TYPE.getName(), CallableStatement.class.getMethod(GET_BOOLEAN, arg));
            csTypes.put(Byte.class.getName(), CallableStatement.class.getMethod(GET_BYTE, arg));
            csTypes.put(Byte.TYPE.getName(), CallableStatement.class.getMethod(GET_BYTE, arg));
            csTypes.put(Character.class.getName(), CallableStatement.class.getMethod(GET_STRING, arg));
            csTypes.put(Character.TYPE.getName(), CallableStatement.class.getMethod(GET_STRING, arg));
            csTypes.put(Short.class.getName(), CallableStatement.class.getMethod(GET_SHORT, arg));
            csTypes.put(Short.TYPE.getName(), CallableStatement.class.getMethod(GET_SHORT, arg));
            csTypes.put(Integer.class.getName(), CallableStatement.class.getMethod(GET_INT, arg));
            csTypes.put(Integer.TYPE.getName(), CallableStatement.class.getMethod(GET_INT, arg));
            csTypes.put(Long.class.getName(), CallableStatement.class.getMethod(GET_LONG, arg));
            csTypes.put(Long.TYPE.getName(), CallableStatement.class.getMethod(GET_LONG, arg));
            csTypes.put(Float.class.getName(), CallableStatement.class.getMethod(GET_FLOAT, arg));
            csTypes.put(Float.TYPE.getName(), CallableStatement.class.getMethod(GET_FLOAT, arg));
            csTypes.put(Double.class.getName(), CallableStatement.class.getMethod(GET_DOUBLE, arg));
            csTypes.put(Double.TYPE.getName(), CallableStatement.class.getMethod(GET_DOUBLE, arg));
            csTypes.put("[B", CallableStatement.class.getMethod(GET_BYTES, arg));
        }
        catch (NoSuchMethodException e) {
            log.error(SQL_ERROR, e);
        }
        jdbcTypeNames = new HashMap();
        Field[] fields = Types.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                jdbcTypeNames.put(fields[i].get(null), fields[i].getName());
                continue;
            }
            catch (IllegalAccessException e) {
                log.error(SQL_ERROR, e);
            }
        }
    }
}

