/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Identity;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.MessageDrivenContext;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.ejb.TransactionManagementType;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.jboss.annotation.security.SecurityDomain;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.BaseContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.SecurityActions;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.security.SecurityDomainManager;
import org.jboss.ejb3.stateless.StatelessBeanContext;
import org.jboss.ejb3.tx.TxUtil;
import org.jboss.ejb3.tx.UserTransactionImpl;
import org.jboss.logging.Logger;
import org.jboss.metadata.SecurityRoleRefMetaData;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

public class BaseSessionContext
implements SessionContext,
MessageDrivenContext,
Externalizable {
    private static final long serialVersionUID = -2485139227124937217L;
    private static final Logger log = Logger.getLogger(BaseSessionContext.class);
    protected transient EJBContainer container;
    protected transient RealmMapping rm;
    protected BaseContext baseContext;

    public void setBaseContext(BaseContext baseContext) {
        this.baseContext = baseContext;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = (EJBContainer)container;
        try {
            InitialContext ctx = container.getInitialContext();
            this.setupSecurityDomain(container, ctx);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupSecurityDomain(Container container, InitialContext ctx) throws NamingException {
        SecurityDomain securityAnnotation = (SecurityDomain)((Advisor)((Object)container)).resolveAnnotation(SecurityDomain.class);
        if (securityAnnotation == null) {
            return;
        }
        Object domain = SecurityDomainManager.getSecurityManager(securityAnnotation.value(), ctx);
        this.rm = (RealmMapping)domain;
    }

    protected RealmMapping getRm() {
        return this.rm;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.container.getObjectName().getCanonicalName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.container = (EJBContainer)Ejb3Registry.getContainer(in.readUTF());
        InitialContext ctx = this.container.getInitialContext();
        try {
            this.setupSecurityDomain(this.container, ctx);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public Object lookup(String name) {
        String newName = name.startsWith("/") ? "env" + name : "env/" + name;
        try {
            return this.getContainer().getEnc().lookup(newName);
        }
        catch (NamingException ignored) {
            try {
                return this.getContainer().getInitialContext().lookup(name);
            }
            catch (NamingException ignored2) {
                return null;
            }
        }
    }

    public Identity getCallerIdentity() {
        throw new IllegalStateException("deprecated");
    }

    public Principal getCallerPrincipal() {
        Principal principal = null;
        RunAsIdentity runAsIdentity = SecurityActions.peekRunAsIdentity(1);
        principal = SecurityAssociation.getCallerPrincipal();
        if (this.getRm() != null) {
            principal = this.getRm().getPrincipal(principal);
        }
        if (principal == null) {
            throw new IllegalStateException("No valid security context for the caller identity");
        }
        return principal;
    }

    public boolean isCallerInRole(Identity role) {
        throw new IllegalStateException("deprecated");
    }

    public boolean isCallerInRole(String roleName) {
        Principal principal = this.getCallerPrincipal();
        RunAsIdentity runAsIdentity = SecurityActions.peekRunAsIdentity(1);
        if (principal == null && runAsIdentity == null) {
            return false;
        }
        if (this.getRm() == null) {
            String msg = "isCallerInRole() called with no security context. Check that a security-domain has been set for the application.";
            throw new IllegalStateException(msg);
        }
        EJBContainer ejbc = this.container;
        if (ejbc.getXml() != null) {
            ArrayList<SecurityRoleRefMetaData> securityRoleRefs = ejbc.getXml().getSecurityRoleReferences();
            for (SecurityRoleRefMetaData srmd : securityRoleRefs) {
                String rname = srmd.getName();
                if (!roleName.equals(rname)) continue;
                roleName = srmd.getLink();
            }
        }
        HashSet<SimplePrincipal> set = new HashSet<SimplePrincipal>();
        set.add(new SimplePrincipal(roleName));
        boolean doesUserHaveRole = false;
        if (runAsIdentity != null) {
            doesUserHaveRole = runAsIdentity.doesUserHaveRole(set);
        }
        if (!doesUserHaveRole) {
            doesUserHaveRole = this.getRm().doesUserHaveRole(principal, set);
        }
        Set roles = this.getRm().getUserRoles(principal);
        return doesUserHaveRole;
    }

    public TimerService getTimerService() throws IllegalStateException {
        return this.getContainer().getTimerService();
    }

    public UserTransaction getUserTransaction() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)((Object)this.getContainer()));
        if (type != TransactionManagementType.BEAN) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to inject UserTransaction into a CMT bean");
        }
        return new UserTransactionImpl();
    }

    public EJBHome getEJBHome() {
        throw new EJBException("EJB 3.0 does not have a home type.");
    }

    public EJBLocalHome getEJBLocalHome() {
        throw new EJBException("EJB 3.0 does not have a home type.");
    }

    public Properties getEnvironment() {
        throw new EJBException("Deprecated");
    }

    public void setRollbackOnly() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)((Object)this.getContainer()));
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to call setRollbackOnly from BMT: " + (Object)((Object)type));
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("setRollbackOnly() not allowed without a transaction.");
            }
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            log.warn("failed to set rollback only; ignoring", e);
        }
    }

    public boolean getRollbackOnly() throws IllegalStateException {
        TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)((Object)this.getContainer()));
        if (type != TransactionManagementType.CONTAINER) {
            throw new IllegalStateException("Container " + this.getContainer().getEjbName() + ": it is illegal to call getRollbackOnly from BMT: " + (Object)((Object)type));
        }
        try {
            TransactionManager tm = TxUtil.getTransactionManager();
            if (tm.getTransaction() == null) {
                throw new IllegalStateException("getRollbackOnly() not allowed without a transaction.");
            }
            int status = tm.getStatus();
            return status == 1 || status == 9 || status == 4;
        }
        catch (SystemException e) {
            log.warn("failed to get tx manager status; ignoring", e);
            return true;
        }
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        try {
            return (EJBLocalObject)this.container.getInitialContext().lookup(ProxyFactoryHelper.getLocalJndiName(this.container, false));
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        try {
            return (EJBObject)this.container.getInitialContext().lookup(ProxyFactoryHelper.getRemoteJndiName((Container)this.container, false));
        }
        catch (NamingException e) {
            throw new IllegalStateException(e);
        }
    }

    public Object getBusinessObject(Class businessInterface) throws IllegalStateException {
        return this.container.getBusinessObject(this.baseContext, businessInterface);
    }

    public Class getInvokedBusinessInterface() throws IllegalStateException {
        return ((SessionContainer)this.container).getInvokedBusinessInterface();
    }

    public MessageContext getMessageContext() throws IllegalStateException {
        if (this.baseContext instanceof StatelessBeanContext) {
            MessageContext ctx = ((StatelessBeanContext)this.baseContext).getMessageContextJAXRPC();
            if (ctx == null) {
                throw new IllegalStateException("No message context found");
            }
            return ctx;
        }
        throw new UnsupportedOperationException("Only stateless beans can have a message context");
    }
}

