/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache;

import java.util.HashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.stateful.StatefulBeanContext;

public class NoPassivationCache
implements StatefulCache {
    private Pool pool;
    private HashMap cacheMap;

    public void initialize(Container container) throws Exception {
        this.pool = container.getPool();
        this.cacheMap = new HashMap();
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            this.cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            HashMap hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(ctx.getId(), ctx);
            }
        }
        catch (EJBException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            HashMap hashMap = this.cacheMap;
            synchronized (hashMap) {
                this.cacheMap.put(ctx.getId(), ctx);
            }
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            entry = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        if (markInUse) {
            if (entry.isRemoved()) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
            }
            entry.setInUse(true);
            entry.lastUsed = System.currentTimeMillis();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        StatefulBeanContext ctx = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            ctx = (StatefulBeanContext)this.cacheMap.remove(key);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
        }
    }
}

