/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.login.Configuration;
import org.jboss.ejb3.naming.BrainlessContext;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.plugins.JBossAuthorizationManager;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.security.plugins.SecurityDomainContext;

public class JaasSecurityManagerService {
    private static final Logger log = Logger.getLogger(JaasSecurityManager.class);
    private static final String SECURITY_MGR_PATH = "java:/jaas";
    private static Map<String, JaasSecurityManager> cache = new HashMap<String, JaasSecurityManager>();
    private Hashtable initialContextProperties;

    public void setInitialContextProperties(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    private InitialContext getInitialContext() throws NamingException {
        if (this.initialContextProperties != null) {
            return new InitialContext(this.initialContextProperties);
        }
        return new InitialContext();
    }

    public void start() throws Exception {
        XMLLoginConfigImpl configuration = new XMLLoginConfigImpl();
        configuration.setConfigResource("login-config.xml");
        configuration.loadConfig();
        Configuration.setConfiguration(configuration);
        InitialContext ctx = this.getInitialContext();
        String factoryName = SecurityDomainObjectFactory.class.getName();
        Reference ref = new Reference("nl.wolfc.embedded.security.plugins.JaasSecurityManager", factoryName, null);
        ctx.rebind(SECURITY_MGR_PATH, (Object)ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JaasSecurityManager getSecurityManager(String name) {
        JaasSecurityManager manager = cache.get(name);
        if (manager != null) {
            return manager;
        }
        Map<String, JaasSecurityManager> map = cache;
        synchronized (map) {
            if (manager != null) {
                return manager;
            }
            manager = new JaasSecurityManager(name, new SecurityAssociationHandler());
            cache.put(name, manager);
        }
        return manager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SecurityDomainObjectFactory
    implements ObjectFactory {
        private static final Logger log = Logger.getLogger(SecurityDomainObjectFactory.class);

        @Override
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
            String securityDomainName = name.get(1);
            final SecurityDomainContext ctx = new SecurityDomainContext(JaasSecurityManagerService.getSecurityManager(securityDomainName), null);
            ctx.setAuthorizationManager(new JBossAuthorizationManager(securityDomainName, new SecurityAssociationHandler()));
            return new BrainlessContext(){

                public Object lookup(Name name) throws NamingException {
                    log.debug("lookup " + name);
                    if (name.size() < 2) {
                        return this.lookup(name.get(0));
                    }
                    return ctx.lookup(name.get(1));
                }

                public Object lookup(String name) throws NamingException {
                    log.debug("lookup " + name);
                    return JaasSecurityManagerService.getSecurityManager(name);
                }
            };
        }
    }
}

