/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.unified.marshall;

import java.io.IOException;
import java.io.OutputStream;
import javax.transaction.SystemException;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.http.HTTPMarshaller;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextUtil;

public class HTTPInvocationMarshaller
extends HTTPMarshaller {
    static final long serialVersionUID = 1611946070051056241L;
    public static final String DATATYPE = "invocationhttp";
    private static final Logger log = Logger.getLogger(HTTPInvocationMarshaller.class);

    public void write(Object dataObject, OutputStream output) throws IOException {
        if (dataObject instanceof InvocationRequest) {
            InvocationRequest remoteInv = (InvocationRequest)dataObject;
            if (remoteInv.getParameter() instanceof Invocation) {
                Invocation inv = (Invocation)remoteInv.getParameter();
                MarshalledInvocation marshInv = new MarshalledInvocation(inv);
                if (inv != null) {
                    try {
                        marshInv.setTransactionPropagationContext(this.getTransactionPropagationContext());
                    }
                    catch (SystemException e) {
                        log.error("Error setting transaction propagation context.", e);
                        throw new IOException("Error setting transaction context.  Message: " + e.getMessage());
                    }
                    remoteInv.setParameter(marshInv);
                } else {
                    log.error("Attempting to marshall Invocation but is null.  Can not proceed.");
                    throw new IOException("Can not process data object due to the InvocationRequest's parameter being null.");
                }
            }
            super.write(dataObject, output);
        } else {
            super.write(dataObject, output);
        }
    }

    public Object getTransactionPropagationContext() throws SystemException {
        TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
        return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
    }

    public Marshaller cloneMarshaller() throws CloneNotSupportedException {
        return new HTTPInvocationMarshaller();
    }
}

