/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jms.InvalidClientIDException;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.jboss.aop.AspectXmlLoader;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.ConnectorManager;
import org.jboss.jms.server.DestinationJNDIMapper;
import org.jboss.jms.server.DestinationManager;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.MessagingTimeoutFactory;
import org.jboss.jms.server.SecurityManager;
import org.jboss.jms.server.ServerPeerMBean;
import org.jboss.jms.server.Version;
import org.jboss.jms.server.connectionfactory.ConnectionFactoryJNDIMapper;
import org.jboss.jms.server.connectionmanager.SimpleConnectionManager;
import org.jboss.jms.server.connectormanager.SimpleConnectorManager;
import org.jboss.jms.server.destination.ManagedQueue;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.server.messagecounter.MessageCounterManager;
import org.jboss.jms.server.plugin.contract.JMSUserManager;
import org.jboss.jms.server.remoting.JMSServerInvocationHandler;
import org.jboss.jms.server.remoting.JMSWireFormat;
import org.jboss.jms.server.security.SecurityMetadataStore;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.memory.MemoryManager;
import org.jboss.messaging.core.memory.SimpleMemoryManager;
import org.jboss.messaging.core.message.SimpleMessageStore;
import org.jboss.messaging.core.plugin.IDManager;
import org.jboss.messaging.core.plugin.contract.ClusteredPostOffice;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.contract.PostOffice;
import org.jboss.messaging.core.plugin.contract.ReplicationListener;
import org.jboss.messaging.core.plugin.contract.Replicator;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.plugin.postoffice.cluster.FailoverStatus;
import org.jboss.messaging.core.tx.TransactionRepository;
import org.jboss.messaging.util.Util;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.system.ServiceCreator;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.JBossStringBuilder;
import org.w3c.dom.Element;

public class ServerPeer
extends ServiceMBeanSupport
implements ServerPeerMBean {
    private static final Logger log = Logger.getLogger(ServerPeer.class);
    public static final String REMOTING_JMS_SUBSYSTEM = "JMS";
    private int serverPeerID;
    private byte[] clientAOPStack;
    private Version version;
    private String defaultQueueJNDIContext;
    private String defaultTopicJNDIContext;
    private boolean started;
    private int objectIDSequence = 1;
    private int defaultMaxDeliveryAttempts = 10;
    private Object failoverStatusLock;
    private long failoverStartTimeout = 60000L;
    private long failoverCompleteTimeout = 300000L;
    private Map sessions;
    private long defaultRedeliveryDelay;
    private long queueStatsSamplePeriod = 10000L;
    private int defaultMessageCounterHistoryDayLimit;
    private DestinationJNDIMapper destinationJNDIMapper;
    private SecurityMetadataStore securityStore;
    private ConnectionFactoryJNDIMapper connFactoryJNDIMapper;
    private TransactionRepository txRepository;
    private ConnectionManager connectionManager;
    private ConnectorManager connectorManager;
    private IDManager messageIDManager;
    private IDManager channelIDManager;
    private IDManager transactionIDManager;
    private MemoryManager memoryManager;
    private MessageStore messageStore;
    private MessageCounterManager messageCounterManager;
    protected ObjectName persistenceManagerObjectName;
    protected PersistenceManager persistenceManager;
    protected ObjectName postOfficeObjectName;
    protected PostOffice postOffice;
    protected ObjectName jmsUserManagerObjectName;
    protected JMSUserManager jmsUserManager;
    protected ObjectName defaultDLQObjectName;
    protected Queue defaultDLQ;
    protected ObjectName defaultExpiryQueueObjectName;
    protected Queue defaultExpiryQueue;
    private JMSServerInvocationHandler handler;

    public ServerPeer(int serverPeerID, String defaultQueueJNDIContext, String defaultTopicJNDIContext) throws Exception {
        if (serverPeerID < 0) {
            throw new IllegalArgumentException("ID cannot be negative");
        }
        log.info(this + " creating server peer with ID " + serverPeerID);
        this.serverPeerID = serverPeerID;
        this.defaultQueueJNDIContext = defaultQueueJNDIContext;
        this.defaultTopicJNDIContext = defaultTopicJNDIContext;
        this.securityStore = new SecurityMetadataStore();
        this.version = Version.instance();
        this.failoverStatusLock = new Object();
        this.sessions = new ConcurrentReaderHashMap();
        this.started = false;
    }

    public synchronized void startService() throws Exception {
        try {
            log.debug("starting ServerPeer");
            if (this.started) {
                return;
            }
            log.debug(this + " starting");
            this.loadClientAOPConfig();
            this.loadServerAOPConfig();
            MBeanServer mbeanServer = this.getServer();
            this.persistenceManager = (PersistenceManager)mbeanServer.getAttribute(this.persistenceManagerObjectName, "Instance");
            this.jmsUserManager = (JMSUserManager)mbeanServer.getAttribute(this.jmsUserManagerObjectName, "Instance");
            this.messageIDManager = new IDManager("MESSAGE_ID", 4096, this.persistenceManager);
            this.channelIDManager = new IDManager("CHANNEL_ID", 10, this.persistenceManager);
            this.transactionIDManager = new IDManager("TRANSACTION_ID", 1024, this.persistenceManager);
            this.destinationJNDIMapper = new DestinationJNDIMapper(this);
            this.connFactoryJNDIMapper = new ConnectionFactoryJNDIMapper(this);
            this.connectionManager = new SimpleConnectionManager();
            this.connectorManager = new SimpleConnectorManager();
            this.memoryManager = new SimpleMemoryManager();
            this.messageStore = new SimpleMessageStore();
            this.txRepository = new TransactionRepository(this.persistenceManager, this.messageStore, this.transactionIDManager);
            this.messageCounterManager = new MessageCounterManager(this.queueStatsSamplePeriod);
            this.messageIDManager.start();
            this.channelIDManager.start();
            this.transactionIDManager.start();
            this.destinationJNDIMapper.start();
            this.connFactoryJNDIMapper.start();
            this.connectionManager.start();
            this.connectorManager.start();
            this.memoryManager.start();
            this.messageStore.start();
            this.securityStore.start();
            this.txRepository.start();
            this.txRepository.loadPreparedTransactions();
            this.initializeRemoting(mbeanServer);
            this.started = true;
            log.info("JBoss Messaging " + this.getVersion().getProviderVersion() + " server [" + this.getServerPeerID() + "] started");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            if (!this.started) {
                return;
            }
            log.debug(this + " stopping");
            this.started = false;
            this.messageIDManager.stop();
            this.messageIDManager = null;
            this.channelIDManager.stop();
            this.channelIDManager = null;
            this.transactionIDManager.stop();
            this.transactionIDManager = null;
            this.destinationJNDIMapper.stop();
            this.destinationJNDIMapper = null;
            this.connFactoryJNDIMapper.stop();
            this.connFactoryJNDIMapper = null;
            this.connectionManager.stop();
            this.connectionManager = null;
            this.connectorManager.start();
            this.connectorManager = null;
            this.memoryManager.stop();
            this.memoryManager = null;
            this.messageStore.stop();
            this.messageStore = null;
            this.securityStore.stop();
            this.securityStore = null;
            this.txRepository.stop();
            this.txRepository = null;
            this.messageCounterManager.stop();
            this.messageCounterManager = null;
            this.unloadServerAOPConfig();
            MessagingTimeoutFactory.instance.reset();
            log.info("JMS " + this + " stopped");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " stopService");
        }
    }

    public synchronized ObjectName getPersistenceManager() {
        return this.persistenceManagerObjectName;
    }

    public synchronized void setPersistenceManager(ObjectName on) {
        if (this.started) {
            log.warn("Cannot set persistence manager on server peer when server peer is started");
            return;
        }
        this.persistenceManagerObjectName = on;
    }

    public synchronized ObjectName getPostOffice() {
        return this.postOfficeObjectName;
    }

    public synchronized void setPostOffice(ObjectName on) {
        if (this.started) {
            log.warn("Cannot set post office on server peer when server peer is started");
            return;
        }
        this.postOfficeObjectName = on;
    }

    public synchronized ObjectName getJmsUserManager() {
        return this.jmsUserManagerObjectName;
    }

    public synchronized void setJMSUserManager(ObjectName on) {
        if (this.started) {
            log.warn("Cannot set jms user manager on server peer when server peer is started");
            return;
        }
        this.jmsUserManagerObjectName = on;
    }

    public synchronized ObjectName getDefaultDLQ() {
        return this.defaultDLQObjectName;
    }

    public synchronized void setDefaultDLQ(ObjectName on) {
        this.defaultDLQObjectName = on;
    }

    public synchronized ObjectName getDefaultExpiryQueue() {
        return this.defaultExpiryQueueObjectName;
    }

    public synchronized void setDefaultExpiryQueue(ObjectName on) {
        this.defaultExpiryQueueObjectName = on;
    }

    public Object getInstance() {
        return this;
    }

    public String getJMSVersion() {
        return this.version.getJMSVersion();
    }

    public int getJMSMajorVersion() {
        return this.version.getJMSMajorVersion();
    }

    public int getJMSMinorVersion() {
        return this.version.getJMSMinorVersion();
    }

    public String getJMSProviderName() {
        return this.version.getJMSProviderName();
    }

    public String getProviderVersion() {
        return this.version.getProviderVersion();
    }

    public int getProviderMajorVersion() {
        return this.version.getProviderMajorVersion();
    }

    public int getProviderMinorVersion() {
        return this.version.getProviderMinorVersion();
    }

    public int getServerPeerID() {
        return this.serverPeerID;
    }

    public String getDefaultQueueJNDIContext() {
        return this.defaultQueueJNDIContext;
    }

    public String getDefaultTopicJNDIContext() {
        return this.defaultTopicJNDIContext;
    }

    public synchronized void setSecurityDomain(String securityDomain) throws Exception {
        try {
            this.securityStore.setSecurityDomain(securityDomain);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " setSecurityDomain");
        }
    }

    public synchronized String getSecurityDomain() {
        return this.securityStore.getSecurityDomain();
    }

    public synchronized void setDefaultSecurityConfig(Element conf) throws Exception {
        this.securityStore.setDefaultSecurityConfig(conf);
    }

    public synchronized Element getDefaultSecurityConfig() {
        return this.securityStore.getDefaultSecurityConfig();
    }

    public synchronized long getFailoverStartTimeout() {
        return this.failoverStartTimeout;
    }

    public synchronized void setFailoverStartTimeout(long timeout) {
        this.failoverStartTimeout = timeout;
    }

    public synchronized long getFailoverCompleteTimeout() {
        return this.failoverCompleteTimeout;
    }

    public synchronized void setFailoverCompleteTimeout(long timeout) {
        this.failoverCompleteTimeout = timeout;
    }

    public synchronized int getDefaultMaxDeliveryAttempts() {
        return this.defaultMaxDeliveryAttempts;
    }

    public synchronized void setDefaultMaxDeliveryAttempts(int attempts) {
        this.defaultMaxDeliveryAttempts = attempts;
    }

    public synchronized long getQueueStatsSamplePeriod() {
        return this.queueStatsSamplePeriod;
    }

    public synchronized void setQueueStatsSamplePeriod(long newPeriod) {
        if (newPeriod < 1000L) {
            throw new IllegalArgumentException("Cannot set QueueStatsSamplePeriod < 1000 ms");
        }
        if (this.messageCounterManager != null && newPeriod != this.queueStatsSamplePeriod) {
            this.messageCounterManager.reschedule(newPeriod);
        }
        this.queueStatsSamplePeriod = newPeriod;
    }

    public synchronized long getDefaultRedeliveryDelay() {
        return this.defaultRedeliveryDelay;
    }

    public synchronized void setDefaultRedeliveryDelay(long delay) {
        this.defaultRedeliveryDelay = delay;
    }

    public synchronized int getDefaultMessageCounterHistoryDayLimit() {
        return this.defaultMessageCounterHistoryDayLimit;
    }

    public void setDefaultMessageCounterHistoryDayLimit(int limit) {
        if (limit < -1) {
            limit = -1;
        }
        this.defaultMessageCounterHistoryDayLimit = limit;
    }

    public void enableMessageCounters() {
        this.messageCounterManager.start();
    }

    public void disableMessageCounters() {
        this.messageCounterManager.stop();
        this.messageCounterManager.resetAllCounters();
        this.messageCounterManager.resetAllCounterHistories();
    }

    public String deployQueue(String name, String jndiName) throws Exception {
        try {
            return this.deployDestinationDefault(true, name, jndiName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " createQueue");
        }
    }

    public String deployQueue(String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        try {
            return this.deployDestination(true, name, jndiName, fullSize, pageSize, downCacheSize);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " createQueue(2)");
        }
    }

    public boolean destroyQueue(String name) throws Exception {
        try {
            return this.destroyDestination(true, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " destroyQueue");
        }
    }

    public boolean undeployQueue(String name) throws Exception {
        try {
            return this.undeployDestination(true, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " destroyQueue");
        }
    }

    public String deployTopic(String name, String jndiName) throws Exception {
        try {
            return this.deployDestinationDefault(false, name, jndiName);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " createTopic");
        }
    }

    public String deployTopic(String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        try {
            return this.deployDestination(false, name, jndiName, fullSize, pageSize, downCacheSize);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " createTopic(2)");
        }
    }

    public boolean destroyTopic(String name) throws Exception {
        try {
            return this.destroyDestination(false, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " destroyTopic");
        }
    }

    public boolean undeployTopic(String name) throws Exception {
        try {
            return this.undeployDestination(false, name);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " destroyTopic");
        }
    }

    public Set getDestinations() throws Exception {
        try {
            return this.destinationJNDIMapper.getDestinations();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getDestinations");
        }
    }

    public List getMessageCounters() throws Exception {
        Set counters = this.messageCounterManager.getMessageCounters();
        return new ArrayList(counters);
    }

    public List getMessageStatistics() throws Exception {
        return MessageCounter.getMessageStatistics(this.getMessageCounters());
    }

    public String listMessageCountersAsHTML() throws Exception {
        List counters = this.getMessageCounters();
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        String strNameLast = null;
        String strTypeLast = null;
        String strDestLast = null;
        String destData = "";
        int destCount = 0;
        int countTotal = 0;
        int countDeltaTotal = 0;
        int depthTotal = 0;
        int depthDeltaTotal = 0;
        int i = 0;
        Iterator iter = counters.iterator();
        while (iter.hasNext()) {
            MessageCounter counter = (MessageCounter)iter.next();
            StringTokenizer tokens = new StringTokenizer(counter.getCounterAsString(), ",");
            String strType = tokens.nextToken();
            String strName = tokens.nextToken();
            String strSub = tokens.nextToken();
            String strDurable = tokens.nextToken();
            String strDest = strType + "-" + strName;
            String strCount = tokens.nextToken();
            String strCountDelta = tokens.nextToken();
            String strDepth = tokens.nextToken();
            String strDepthDelta = tokens.nextToken();
            String strDate = tokens.nextToken();
            countTotal += Integer.parseInt(strCount);
            depthTotal += Integer.parseInt(strDepth);
            countDeltaTotal += Integer.parseInt(strCountDelta);
            depthDeltaTotal += Integer.parseInt(strDepthDelta);
            if (strCountDelta.equalsIgnoreCase("0")) {
                strCountDelta = "-";
            }
            if (strDepthDelta.equalsIgnoreCase("0")) {
                strDepthDelta = "-";
            }
            if (strDestLast != null && strDestLast.equals(strDest)) {
                destData = destData + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ++destCount;
            } else {
                if (strDestLast != null) {
                    ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
                    destData = "";
                }
                destCount = 1;
            }
            destData = destData + "<td>" + strSub + "</td>" + "<td>" + strDurable + "</td>" + "<td>" + strCount + "</td>" + "<td>" + strCountDelta + "</td>" + "<td>" + strDepth + "</td>" + "<td>" + strDepthDelta + "</td>" + "<td>" + strDate + "</td>";
            strTypeLast = strType;
            strNameLast = strName;
            strDestLast = strDest;
        }
        if (strDestLast != null) {
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\"><td rowspan=\"" + destCount + "\">" + strTypeLast + "</td><td rowspan=\"" + destCount + "\">" + strNameLast + "</td>" + destData;
        }
        ret = ret + "<tr><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td><![CDATA[ ]]></td><td>" + countTotal + "</td><td>" + (countDeltaTotal == 0 ? "-" : Integer.toString(countDeltaTotal)) + "</td><td>" + depthTotal + "</td><td>" + (depthDeltaTotal == 0 ? "-" : Integer.toString(depthDeltaTotal)) + "</td><td>Total</td></tr></table>";
        return ret;
    }

    public void resetAllMessageCounters() {
        this.messageCounterManager.resetAllCounters();
    }

    public void resetAllMessageCounterHistories() {
        this.messageCounterManager.resetAllCounterHistories();
    }

    public List retrievePreparedTransactions() {
        return this.txRepository.getPreparedTransactions();
    }

    public String showPreparedTransactionsAsHTML() {
        List txs = this.txRepository.getPreparedTransactions();
        JBossStringBuilder buffer = new JBossStringBuilder();
        buffer.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\">");
        buffer.append("<tr><th>Xid</th></tr>");
        Iterator i = txs.iterator();
        while (i.hasNext()) {
            Xid xid = (Xid)i.next();
            if (xid == null) continue;
            buffer.append("<tr><td>");
            buffer.append(xid);
            buffer.append("</td></tr>");
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    public byte[] getClientAOPStack() {
        return this.clientAOPStack;
    }

    public MessageCounterManager getMessageCounterManager() {
        return this.messageCounterManager;
    }

    public IDManager getMessageIDManager() {
        return this.messageIDManager;
    }

    public IDManager getChannelIDManager() {
        return this.channelIDManager;
    }

    public ServerInvocationHandler getInvocationHandler() {
        return this.handler;
    }

    public ServerSessionEndpoint getSession(Integer sessionID) {
        return (ServerSessionEndpoint)this.sessions.get(sessionID);
    }

    public void addSession(Integer id, ServerSessionEndpoint session) {
        this.sessions.put(id, session);
    }

    public void removeSession(Integer id) {
        if (this.sessions.remove(id) == null) {
            throw new IllegalStateException("Cannot find session with id " + id + " to remove");
        }
    }

    public synchronized Queue getDefaultDLQInstance() throws Exception {
        Queue dlq = null;
        if (this.defaultDLQObjectName != null) {
            PostOffice po;
            Binding binding;
            ManagedQueue dest = null;
            try {
                dest = (ManagedQueue)this.getServer().getAttribute(this.defaultDLQObjectName, "Instance");
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
            if (dest != null && (binding = (po = this.getPostOfficeInstance()).getBindingForQueueName(dest.getName())) != null && binding.getQueue().isActive()) {
                dlq = binding.getQueue();
            }
        }
        return dlq;
    }

    public synchronized Queue getDefaultExpiryQueueInstance() throws Exception {
        Queue expiryQueue = null;
        if (this.defaultExpiryQueueObjectName != null) {
            PostOffice po;
            Binding binding;
            ManagedQueue dest = null;
            try {
                dest = (ManagedQueue)this.getServer().getAttribute(this.defaultExpiryQueueObjectName, "Instance");
            }
            catch (InstanceNotFoundException e) {
                // empty catch block
            }
            if (dest != null && (binding = (po = this.getPostOfficeInstance()).getBindingForQueueName(dest.getName())) != null && binding.getQueue().isActive()) {
                expiryQueue = binding.getQueue();
            }
        }
        return expiryQueue;
    }

    public TransactionRepository getTxRepository() {
        return this.txRepository;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public Version getVersion() {
        return this.version;
    }

    public SecurityManager getSecurityManager() {
        return this.securityStore;
    }

    public DestinationManager getDestinationManager() {
        return this.destinationJNDIMapper;
    }

    public ConnectionFactoryManager getConnectionFactoryManager() {
        return this.connFactoryJNDIMapper;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ConnectorManager getConnectorManager() {
        return this.connectorManager;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public PersistenceManager getPersistenceManagerInstance() {
        return this.persistenceManager;
    }

    public JMSUserManager getJmsUserManagerInstance() {
        return this.jmsUserManager;
    }

    public PostOffice getPostOfficeInstance() throws Exception {
        if (this.postOffice == null) {
            this.postOffice = (PostOffice)this.getServer().getAttribute(this.postOfficeObjectName, "Instance");
            if (!this.postOffice.isLocal()) {
                Replicator rep = (Replicator)((Object)this.postOffice);
                this.connFactoryJNDIMapper.injectReplicator(rep);
                rep.registerListener(new FailoverListener());
            }
            this.txRepository.injectPostOffice(this.postOffice);
        }
        return this.postOffice;
    }

    public Replicator getReplicator() throws Exception {
        PostOffice postOffice = this.getPostOfficeInstance();
        if (!(postOffice instanceof Replicator)) {
            throw new IllegalAccessException("This operations is only legal on clustering configurations");
        }
        return (Replicator)((Object)postOffice);
    }

    public synchronized int getNextObjectID() {
        return this.objectIDSequence++;
    }

    public int waitForFailover(int failedNodeID) throws Exception {
        log.debug(this + " waiting for server-side failover for failed node " + failedNodeID + " to complete");
        Replicator replicator = this.getReplicator();
        long startToWait = this.getFailoverStartTimeout();
        long completeToWait = this.getFailoverCompleteTimeout();
        Object object = this.failoverStatusLock;
        synchronized (object) {
            while (true) {
                Map replicants = replicator.get((Serializable)((Object)"FAILED_OVER_FOR"));
                boolean foundEntry = false;
                if (replicants != null) {
                    Iterator i = replicants.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        Integer nid = (Integer)entry.getKey();
                        FailoverStatus status = (FailoverStatus)entry.getValue();
                        if (status.isFailedOverForNode(failedNodeID)) {
                            log.debug(this + ": failover is complete on node " + nid);
                            return nid;
                        }
                        if (!status.isFailingOverForNode(failedNodeID)) continue;
                        log.debug(this + ": fail over is in progress on node " + nid);
                        if (nid.intValue() != this.getServerPeerID()) {
                            return nid;
                        }
                        if (completeToWait <= 0L) {
                            log.debug(this + " already waited long enough for failover to complete, giving up");
                            return -1;
                        }
                        long start = System.currentTimeMillis();
                        try {
                            log.debug(this + " blocking on the failover lock, waiting for failover to complete");
                            this.failoverStatusLock.wait(completeToWait);
                            log.debug(this + " releasing the failover lock, checking again whether failover completed ...");
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        completeToWait -= System.currentTimeMillis() - start;
                        foundEntry = true;
                    }
                }
                if (foundEntry) continue;
                if (startToWait <= 0L) {
                    log.debug(this + " already waited long enough for failover to start, giving up");
                    return -1;
                }
                long start = System.currentTimeMillis();
                try {
                    log.debug(this + " blocking on the failover lock, waiting for failover to start");
                    this.failoverStatusLock.wait(startToWait);
                    log.debug(this + " releasing the failover lock, checking again whether failover started ...");
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                startToWait -= System.currentTimeMillis() - start;
            }
        }
    }

    public void checkClientID(String clientID) throws Exception {
        if (clientID != null) {
            List conns = this.connectionManager.getActiveConnections();
            Iterator i = conns.iterator();
            while (i.hasNext()) {
                ServerConnectionEndpoint sce = (ServerConnectionEndpoint)i.next();
                if (clientID == null || !clientID.equals(sce.getClientID())) continue;
                throw new InvalidClientIDException("Client ID '" + clientID + "' already used by " + sce);
            }
        }
    }

    public String toString() {
        return "ServerPeer[" + this.getServerPeerID() + "]";
    }

    private void initializeRemoting(MBeanServer mbeanServer) throws Exception {
        JMSWireFormat wf = new JMSWireFormat();
        MarshalFactory.addMarshaller("jms", (Marshaller)wf, (UnMarshaller)wf);
        this.handler = new JMSServerInvocationHandler();
    }

    private void loadServerAOPConfig() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("aop-messaging-server.xml");
        AspectXmlLoader.deployXML(url, this.getClass().getClassLoader());
    }

    private void unloadServerAOPConfig() throws Exception {
        URL url = this.getClass().getClassLoader().getResource("aop-messaging-server.xml");
        AspectXmlLoader.undeployXML(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClientAOPConfig() throws Exception {
        ByteArrayOutputStream os;
        block6: {
            URL url = this.getClass().getClassLoader().getResource("aop-messaging-client.xml");
            InputStream is = null;
            os = new ByteArrayOutputStream();
            try {
                int b;
                is = url.openStream();
                while ((b = is.read()) != -1) {
                    os.write(b);
                }
                os.flush();
                this.clientAOPStack = os.toByteArray();
                Object var6_5 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (os != null) {
            os.close();
        }
    }

    private String deployDestinationDefault(boolean isQueue, String name, String jndiName) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String className = "org.jboss.jms.server.destination." + destType + "Service";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "</mbean>";
        return this.deployDestinationInternal(destinationMBeanConfig, on, jndiName, false, -1, -1, -1);
    }

    private String deployDestination(boolean isQueue, String name, String jndiName, int fullSize, int pageSize, int downCacheSize) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String className = "org.jboss.jms.server.destination." + destType + "Service";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        String destinationMBeanConfig = "<mbean code=\"" + className + "\" " + "       name=\"" + ons + "\" " + "       xmbean-dd=\"xmdesc/" + destType + "-xmbean.xml\">\n" + "    <constructor>" + "        <arg type=\"boolean\" value=\"true\"/>" + "    </constructor>" + "    <attribute name=\"FullSize\">" + fullSize + "</attribute>" + "    <attribute name=\"PageSize\">" + pageSize + "</attribute>" + "    <attribute name=\"DownCacheSize\">" + downCacheSize + "</attribute>" + "</mbean>";
        return this.deployDestinationInternal(destinationMBeanConfig, on, jndiName, true, fullSize, pageSize, downCacheSize);
    }

    private String deployDestinationInternal(String destinationMBeanConfig, ObjectName on, String jndiName, boolean params, int fullSize, int pageSize, int downCacheSize) throws Exception {
        MBeanServer mbeanServer = this.getServer();
        Element element = Util.stringToElement(destinationMBeanConfig);
        ServiceCreator sc = new ServiceCreator(mbeanServer);
        ClassLoader cl = this.getClass().getClassLoader();
        ObjectName loaderObjectName = null;
        if (cl instanceof UnifiedClassLoader3) {
            loaderObjectName = ((UnifiedClassLoader3)cl).getObjectName();
        }
        sc.install(on, loaderObjectName, element);
        mbeanServer.setAttribute(on, new Attribute("ServerPeer", this.getServiceName()));
        mbeanServer.setAttribute(on, new Attribute("JNDIName", jndiName));
        if (params) {
            mbeanServer.setAttribute(on, new Attribute("FullSize", new Integer(fullSize)));
            mbeanServer.setAttribute(on, new Attribute("PageSize", new Integer(pageSize)));
            mbeanServer.setAttribute(on, new Attribute("DownCacheSize", new Integer(downCacheSize)));
        }
        mbeanServer.invoke(on, "create", new Object[0], new String[0]);
        mbeanServer.invoke(on, "start", new Object[0], new String[0]);
        return (String)mbeanServer.getAttribute(on, "JNDIName");
    }

    private boolean undeployDestination(boolean isQueue, String name) throws Exception {
        String destType = isQueue ? "Queue" : "Topic";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        MBeanServer mbeanServer = this.getServer();
        if (!mbeanServer.isRegistered(on)) {
            return false;
        }
        Boolean b = (Boolean)mbeanServer.getAttribute(on, "CreatedProgrammatically");
        if (!b.booleanValue()) {
            log.warn("Cannot undeploy a destination that has not been created programatically");
            return false;
        }
        mbeanServer.invoke(on, "stop", new Object[0], new String[0]);
        mbeanServer.invoke(on, "destroy", new Object[0], new String[0]);
        mbeanServer.unregisterMBean(on);
        return true;
    }

    private boolean destroyDestination(boolean isQueue, String name) throws Exception {
        Binding binding;
        Iterator iter;
        Collection bindings;
        JMSCondition topicCond;
        Binding binding2;
        String destType = isQueue ? "Queue" : "Topic";
        String ons = "jboss.messaging.destination:service=" + destType + ",name=" + name;
        ObjectName on = new ObjectName(ons);
        MBeanServer mbeanServer = this.getServer();
        if (!mbeanServer.isRegistered(on)) {
            return false;
        }
        if (isQueue) {
            binding2 = this.postOffice.getBindingForQueueName(name);
            if (binding2 != null) {
                binding2.getQueue().deactivate();
            }
        } else {
            topicCond = new JMSCondition(false, name);
            bindings = this.postOffice.getBindingsForCondition(topicCond);
            iter = bindings.iterator();
            while (iter.hasNext()) {
                binding = (Binding)iter.next();
                binding.getQueue().deactivate();
            }
        }
        mbeanServer.invoke(on, "removeAllMessages", null, null);
        if (!this.undeployDestination(isQueue, name)) {
            return false;
        }
        if (isQueue) {
            binding2 = this.postOffice.getBindingForQueueName(name);
            if (binding2 != null) {
                try {
                    Queue queue = binding2.getQueue();
                    if (!queue.isClustered()) {
                        this.postOffice.unbindQueue(queue.getName());
                    }
                    ((ClusteredPostOffice)this.postOffice).unbindClusteredQueue(queue.getName());
                }
                catch (Throwable t) {
                    throw new Exception("Failed to unbind queue", t);
                }
            }
        } else {
            topicCond = new JMSCondition(false, name);
            bindings = this.postOffice.getBindingsForCondition(topicCond);
            iter = bindings.iterator();
            while (iter.hasNext()) {
                binding = (Binding)iter.next();
                try {
                    this.postOffice.unbindQueue(binding.getQueue().getName());
                }
                catch (Throwable t) {
                    throw new Exception("Failed to unbind queue", t);
                }
            }
        }
        return true;
    }

    private class FailoverListener
    implements ReplicationListener {
        private FailoverListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReplicationChange(Serializable key, Map updatedReplicantMap, boolean added, int originatingNodeId) {
            if (key.equals("FAILED_OVER_FOR")) {
                FailoverStatus status;
                if (updatedReplicantMap != null && originatingNodeId == ServerPeer.this.serverPeerID && (status = (FailoverStatus)updatedReplicantMap.get(new Integer(ServerPeer.this.serverPeerID))) != null && status.isFailedOver()) {
                    try {
                        ServerPeer.this.txRepository.loadPreparedTransactions();
                    }
                    catch (Exception e) {
                        log.error("Failed to load prepared transactions", e);
                    }
                }
                Object object = ServerPeer.this.failoverStatusLock;
                synchronized (object) {
                    log.debug(ServerPeer.this + ".FailoverListener got failover event, notifying those waiting on lock");
                    ServerPeer.this.failoverStatusLock.notifyAll();
                }
            }
        }
    }
}

