/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.util.StreamUtils;

class PutReplicantRequest
extends ClusterRequest {
    static final int TYPE = 12;
    private int nodeId;
    private Serializable key;
    private Serializable replicant;

    PutReplicantRequest() {
    }

    PutReplicantRequest(int nodeId, Serializable key, Serializable replicant) {
        this.nodeId = nodeId;
        this.key = key;
        this.replicant = replicant;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.key = (Serializable)StreamUtils.readObject(in, true);
        this.replicant = (Serializable)StreamUtils.readObject(in, true);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        StreamUtils.writeObject(out, this.key, true, true);
        StreamUtils.writeObject(out, this.replicant, true, true);
    }

    Object execute(PostOfficeInternal office) throws Exception {
        office.putReplicantLocally(this.nodeId, this.key, this.replicant);
        return null;
    }

    byte getType() {
        return 12;
    }

    public String toString() {
        return "PutRequest[" + this.key + "][" + this.replicant + "]";
    }
}

