/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.tx;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import javax.transaction.xa.Xid;
import org.jboss.messaging.util.Streamable;

public class MessagingXid
implements Xid,
Serializable,
Streamable {
    private static final long serialVersionUID = -1893120702576869245L;
    private byte[] branchQualifier;
    private int formatId;
    private byte[] globalTransactionId;
    private int hash;
    private boolean hashCalculated;

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public MessagingXid() {
    }

    public MessagingXid(byte[] branchQualifier, int formatId, byte[] globalTransactionId) {
        this.branchQualifier = branchQualifier;
        this.formatId = formatId;
        this.globalTransactionId = globalTransactionId;
    }

    public MessagingXid(Xid other) {
        this.branchQualifier = this.copyBytes(other.getBranchQualifier());
        this.formatId = other.getFormatId();
        this.globalTransactionId = this.copyBytes(other.getGlobalTransactionId());
    }

    public int hashCode() {
        if (!this.hashCalculated) {
            this.calcHash();
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        int i;
        if (!(other instanceof Xid)) {
            return false;
        }
        Xid xother = (Xid)other;
        if (xother.getFormatId() != this.formatId) {
            return false;
        }
        if (xother.getBranchQualifier().length != this.branchQualifier.length) {
            return false;
        }
        if (xother.getGlobalTransactionId().length != this.globalTransactionId.length) {
            return false;
        }
        for (i = 0; i < this.branchQualifier.length; ++i) {
            byte[] otherBQ = xother.getBranchQualifier();
            if (this.branchQualifier[i] == otherBQ[i]) continue;
            return false;
        }
        for (i = 0; i < this.globalTransactionId.length; ++i) {
            byte[] otherGtx = xother.getGlobalTransactionId();
            if (this.globalTransactionId[i] == otherGtx[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getName() + "(GID: " + this.stringRep(this.getGlobalTransactionId()) + ", Branch: " + this.stringRep(this.getBranchQualifier()) + ", Format: " + this.getFormatId() + ")";
    }

    private String stringRep(byte[] bytes) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buff.append(b);
            if (i == bytes.length - 1) continue;
            buff.append('.');
        }
        return buff.toString();
    }

    public void read(DataInputStream in) throws Exception {
        int len = in.readInt();
        this.branchQualifier = new byte[len];
        in.readFully(this.branchQualifier);
        this.formatId = in.readInt();
        len = in.readInt();
        this.globalTransactionId = new byte[len];
        in.readFully(this.globalTransactionId);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.branchQualifier.length);
        out.write(this.branchQualifier);
        out.writeInt(this.formatId);
        out.writeInt(this.globalTransactionId.length);
        out.write(this.globalTransactionId);
    }

    private void calcHash() {
        byte[] hashBytes = new byte[this.branchQualifier.length + this.globalTransactionId.length + 4];
        System.arraycopy(this.branchQualifier, 0, hashBytes, 0, this.branchQualifier.length);
        System.arraycopy(this.globalTransactionId, 0, hashBytes, this.branchQualifier.length, this.globalTransactionId.length);
        byte[] intBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            intBytes[i] = (byte)((this.formatId >> i * 8) % 255);
        }
        System.arraycopy(intBytes, 0, hashBytes, this.branchQualifier.length + this.globalTransactionId.length, 4);
        String s = new String(hashBytes);
        this.hash = s.hashCode();
        this.hashCalculated = true;
    }

    private byte[] copyBytes(byte[] other) {
        byte[] bytes = new byte[other.length];
        System.arraycopy(other, 0, bytes, 0, other.length);
        return bytes;
    }
}

