/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Message;
import org.jboss.deployment.DeploymentException;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.w3c.dom.Element;

public class MessageDrivenMetaData
extends BeanMetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int AUTO_ACKNOWLEDGE_MODE = 1;
    public static final int DUPS_OK_ACKNOWLEDGE_MODE = 3;
    public static final int CLIENT_ACKNOWLEDGE_MODE = 2;
    public static final byte DURABLE_SUBSCRIPTION = 0;
    public static final byte NON_DURABLE_SUBSCRIPTION = 1;
    public static final byte TX_UNSET = 9;
    public static final String DEFAULT_MESSAGE_DRIVEN_BEAN_INVOKER_PROXY_BINDING = "message-driven-bean";
    public static final String DEFAULT_MESSAGING_TYPE = "javax.jms.MessageListener";
    private int acknowledgeMode = 1;
    private byte subscriptionDurability = 1;
    private byte methodTransactionType = (byte)9;
    private String messagingType = "javax.jms.MessageListener";
    private String destinationType;
    private String destinationLink;
    private String messageSelector;
    private String destinationJndiName;
    private String user;
    private String passwd;
    private String clientId;
    private String subscriptionId;
    private HashMap activationConfigProperties = new HashMap();
    private String resourceAdapterName;

    public MessageDrivenMetaData(ApplicationMetaData app) {
        super(app, 'M');
    }

    public int getAcknowledgeMode() {
        if (this.getMethodTransactionType() == 1) {
            return 2;
        }
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(String ack) {
        if (ack == null || ack.equalsIgnoreCase("Auto-acknowledge") || ack.equalsIgnoreCase("AUTO_ACKNOWLEDGE")) {
            this.acknowledgeMode = 1;
        } else if (ack.equalsIgnoreCase("Dups-ok-acknowledge") || ack.equalsIgnoreCase("DUPS_OK_ACKNOWLEDGE")) {
            this.acknowledgeMode = 3;
        } else {
            throw new IllegalStateException("invalid acknowledge-mode: " + ack);
        }
    }

    public String getMessagingType() {
        return this.messagingType;
    }

    public void setMessagingType(String messagingType) {
        this.messagingType = messagingType;
    }

    public boolean isJMSMessagingType() {
        return DEFAULT_MESSAGING_TYPE.equals(this.messagingType);
    }

    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public String getDestinationLink() {
        return this.destinationLink;
    }

    public void setDestinationLink(String destinationLink) {
        this.destinationLink = destinationLink;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String selector) {
        this.messageSelector = selector;
        if (this.messageSelector != null) {
            int i = -1;
            while ((i = this.messageSelector.indexOf("\r\n")) >= 0) {
                this.messageSelector = (i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 2 ? "" : this.messageSelector.substring(i + 2));
            }
            i = -1;
            while ((i = this.messageSelector.indexOf("\r")) >= 0) {
                this.messageSelector = (i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 1 ? "" : this.messageSelector.substring(i + 1));
            }
            i = -1;
            while ((i = this.messageSelector.indexOf("\n")) >= 0) {
                this.messageSelector = (i == 0 ? "" : this.messageSelector.substring(0, i)) + " " + (i >= this.messageSelector.length() - 1 ? "" : this.messageSelector.substring(i + 1));
            }
            this.messageSelector = this.messageSelector.trim();
            if ("".equals(this.messageSelector)) {
                this.messageSelector = null;
            }
        }
    }

    public String getDestinationJndiName() {
        return this.destinationJndiName;
    }

    public void setDestinationJndiName(String destinationJndiName) {
        this.destinationJndiName = destinationJndiName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public byte getMethodTransactionType() {
        if (this.methodTransactionType == 9) {
            Class[] sig = new Class[]{Message.class};
            this.methodTransactionType = this.getMethodTransactionType("onMessage", sig);
        }
        return this.methodTransactionType;
    }

    public byte getMethodTransactionType(String methodName, Class[] signature) {
        if (this.isContainerManagedTx()) {
            if (super.getMethodTransactionType(methodName, signature, null) == 0) {
                return 0;
            }
            return 1;
        }
        return 6;
    }

    public byte getMethodTransactionType(String methodName, Class[] params, InvocationType iface) {
        if (this.isJMSMessagingType()) {
            return this.getMethodTransactionType();
        }
        return this.getMethodTransactionType(methodName, params);
    }

    public byte getSubscriptionDurability() {
        return this.subscriptionDurability;
    }

    public void setSubscriptionDurability(String subscr) {
        this.subscriptionDurability = subscr != null && subscr.equals("Durable") ? (byte)0 : 1;
    }

    public String getDefaultConfigurationName() {
        if (!this.isJMSMessagingType()) {
            return "Standard Message Inflow Driven Bean";
        }
        return "Standard Message Driven Bean";
    }

    public HashMap getActivationConfigProperties() {
        return this.activationConfigProperties;
    }

    public ActivationConfigPropertyMetaData getActivationConfigProperty(String name) {
        return (ActivationConfigPropertyMetaData)this.activationConfigProperties.get(name);
    }

    public String getResourceAdapterName() {
        return this.resourceAdapterName;
    }

    public void setResourceAdapterName(String resourceAdapterName) {
        this.resourceAdapterName = resourceAdapterName;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        String ejb21DestinationType;
        super.importEjbJarXml(element);
        this.setMessageSelector(MessageDrivenMetaData.getOptionalChildContent(element, "message-selector"));
        this.messagingType = MessageDrivenMetaData.getOptionalChildContent(element, "messaging-type", DEFAULT_MESSAGING_TYPE);
        Element destination = MessageDrivenMetaData.getOptionalChild(element, "message-driven-destination");
        if (destination != null) {
            this.destinationType = MessageDrivenMetaData.getUniqueChildContent(destination, "destination-type");
            if (this.destinationType.equals("javax.jms.Topic")) {
                String subscr = MessageDrivenMetaData.getOptionalChildContent(destination, "subscription-durability");
                this.setSubscriptionDurability(subscr);
            }
        }
        if ((ejb21DestinationType = MessageDrivenMetaData.getOptionalChildContent(element, "message-destination-type")) != null) {
            this.destinationType = ejb21DestinationType;
        }
        this.destinationLink = MessageDrivenMetaData.getOptionalChildContent(element, "message-destination-link");
        String transactionType = MessageDrivenMetaData.getUniqueChildContent(element, "transaction-type");
        if (transactionType.equals("Bean")) {
            this.containerManagedTx = false;
            String ack = MessageDrivenMetaData.getOptionalChildContent(element, "acknowledge-mode");
            this.setAcknowledgeMode(ack);
        } else if (transactionType.equals("Container")) {
            this.containerManagedTx = true;
        } else {
            throw new DeploymentException("transaction type should be 'Bean' or 'Container'");
        }
        Element activationConfig = MessageDrivenMetaData.getOptionalChild(element, "activation-config");
        if (activationConfig != null) {
            Iterator iterator = MessageDrivenMetaData.getChildrenByTagName(activationConfig, "activation-config-property");
            while (iterator.hasNext()) {
                Element resourceRef = (Element)iterator.next();
                ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
                metaData.importXml(resourceRef);
                if (this.activationConfigProperties.containsKey(metaData.getName())) {
                    throw new DeploymentException("Duplicate activation-config-property-name: " + metaData.getName());
                }
                this.activationConfigProperties.put(metaData.getName(), metaData);
            }
        }
    }

    public void importJbossXml(Element element) throws DeploymentException {
        super.importJbossXml(element);
        this.destinationJndiName = MessageDrivenMetaData.getOptionalChildContent(element, "destination-jndi-name");
        this.user = MessageDrivenMetaData.getOptionalChildContent(element, "mdb-user");
        this.passwd = MessageDrivenMetaData.getOptionalChildContent(element, "mdb-passwd");
        this.clientId = MessageDrivenMetaData.getOptionalChildContent(element, "mdb-client-id");
        this.subscriptionId = MessageDrivenMetaData.getOptionalChildContent(element, "mdb-subscription-id");
        this.resourceAdapterName = MessageDrivenMetaData.getOptionalChildContent(element, "resource-adapter-name");
        Element activationConfig = MessageDrivenMetaData.getOptionalChild(element, "activation-config");
        if (activationConfig != null) {
            Iterator iterator = MessageDrivenMetaData.getChildrenByTagName(activationConfig, "activation-config-property");
            while (iterator.hasNext()) {
                Element resourceRef = (Element)iterator.next();
                ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData();
                metaData.importXml(resourceRef);
                this.activationConfigProperties.put(metaData.getName(), metaData);
            }
        }
    }

    public void defaultInvokerBindings() {
        this.invokerBindings = new HashMap();
        this.invokerBindings.put(DEFAULT_MESSAGE_DRIVEN_BEAN_INVOKER_PROXY_BINDING, this.getJndiName());
    }
}

