/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.values;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.AbstractMetaValue;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeValueSupport
extends AbstractMetaValue
implements CompositeValue {
    private static final long serialVersionUID = 6262188760975631870L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("contents", SortedMap.class), new ObjectStreamField("metaType", CompositeMetaType.class)};
    private SortedMap<String, MetaValue> contents;
    private CompositeMetaType metaType;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    public CompositeValueSupport(CompositeMetaType metaType, String[] itemNames, MetaValue[] itemValues) {
        if (metaType == null) {
            throw new IllegalArgumentException("null meta type");
        }
        if (itemNames == null) {
            throw new IllegalArgumentException("null itemNames");
        }
        if (itemValues == null) {
            throw new IllegalArgumentException("null itemValues");
        }
        if (itemNames.length == 0) {
            throw new IllegalArgumentException("empty itemNames");
        }
        if (itemValues.length == 0) {
            throw new IllegalArgumentException("empty itemValues");
        }
        if (itemNames.length != itemValues.length) {
            throw new IllegalArgumentException("itemNames has size " + itemNames.length + " but itemValues has size " + itemValues.length);
        }
        int compositeNameSize = metaType.keySet().size();
        if (itemNames.length != compositeNameSize) {
            throw new IllegalArgumentException("itemNames has size " + itemNames.length + " but composite type has size " + compositeNameSize);
        }
        this.metaType = metaType;
        this.contents = new TreeMap<String, MetaValue>();
        for (int i = 0; i < itemNames.length; ++i) {
            if (itemNames[i] == null || itemNames[i].length() == 0) {
                throw new IllegalArgumentException("Item name " + i + " is null or empty");
            }
            if (this.contents.get(itemNames[i]) != null) {
                throw new IllegalArgumentException("duplicate item name " + itemNames[i]);
            }
            MetaType itemType = metaType.getType(itemNames[i]);
            if (itemType == null) {
                throw new IllegalArgumentException("item name not in composite type " + itemNames[i]);
            }
            if (itemValues[i] != null && !itemType.isValue(itemValues[i])) {
                throw new IllegalArgumentException("item value " + itemValues[i] + " for item name " + itemNames[i] + " is not a " + itemType);
            }
            this.contents.put(itemNames[i], itemValues[i]);
        }
    }

    public CompositeValueSupport(CompositeMetaType compositeMetaType, Map<String, MetaValue> items) {
        this.init(compositeMetaType, items);
    }

    @Override
    public CompositeMetaType getMetaType() {
        return this.metaType;
    }

    @Override
    public MetaValue get(String key) {
        this.validateKey(key);
        return (MetaValue)this.contents.get(key);
    }

    @Override
    public MetaValue[] getAll(String[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Null keys");
        }
        MetaValue[] result = new MetaValue[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.validateKey(keys[i]);
            result[i] = (MetaValue)this.contents.get(keys[i]);
        }
        return result;
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    @Override
    public boolean containsValue(MetaValue value) {
        return this.contents.containsValue(value);
    }

    @Override
    public Collection<MetaValue> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof CompositeValue)) {
            return false;
        }
        CompositeValue other = (CompositeValue)obj;
        if (!this.getMetaType().equals(other.getMetaType())) {
            return false;
        }
        if (this.values().size() != other.values().size()) {
            return false;
        }
        for (String key : this.contents.keySet()) {
            MetaValue thisValue = this.get(key);
            MetaValue otherValue = other.get(key);
            if (thisValue == null && otherValue == null || thisValue != null && thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getMetaType().hashCode();
        for (MetaValue value : this.contents.values()) {
            if (value == null) continue;
            this.cachedHashCode += value.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public String toString() {
        CompositeMetaType metaType = this.getMetaType();
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(": netaType=[");
        buffer.append(metaType);
        buffer.append("] mappings=[");
        Iterator<String> keys = metaType.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            buffer.append(key + "=" + this.contents.get(key));
            if (!keys.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void validateKey(String key) {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("null or empty key");
        }
        CompositeMetaType metaType = this.getMetaType();
        if (!metaType.containsKey(key)) {
            throw new IllegalArgumentException("no such item name " + key + " for composite type " + metaType);
        }
    }

    private void init(CompositeMetaType metaType, Map<String, MetaValue> items) {
        if (metaType == null) {
            throw new IllegalArgumentException("null meta type");
        }
        if (items == null) {
            throw new IllegalArgumentException("null items");
        }
        if (items.size() == 0) {
            throw new IllegalArgumentException("empty items");
        }
        int compositeNameSize = metaType.keySet().size();
        if (items.size() != compositeNameSize) {
            throw new IllegalArgumentException("items has size " + items.size() + " but composite type has size " + compositeNameSize);
        }
        this.metaType = metaType;
        this.contents = new TreeMap<String, MetaValue>();
        for (Map.Entry<String, MetaValue> entry : items.entrySet()) {
            String key = entry.getKey();
            if (key == null || key.length() == 0) {
                throw new IllegalArgumentException("Key is null or empty");
            }
            MetaType itemType = metaType.getType(key);
            if (itemType == null) {
                throw new IllegalArgumentException("item name not in composite type " + key);
            }
            MetaValue value = items.get(key);
            if (value != null && !itemType.isValue(value)) {
                throw new IllegalArgumentException("item value " + value + " for item name " + key + " is not a " + itemType);
            }
            this.contents.put(key, value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        SortedMap contents = (SortedMap)getField.get("contents", null);
        CompositeMetaType compositeType = (CompositeMetaType)getField.get("metaType", null);
        try {
            this.init(compositeType, contents);
        }
        catch (Exception e) {
            throw new RuntimeException("Error deserializing composite value", e);
        }
    }
}

