/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.plugins.SecurityContextAssociation;
import org.jboss.security.plugins.SecurityContextFactory;

interface SecurityActions {
    public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

        public Principal getPrincipal() {
            return SecurityAssociation.getPrincipal();
        }

        public Object getCredential() {
            return SecurityAssociation.getCredential();
        }

        public RunAsIdentity getCallerRunAsIdentity() {
            RunAsIdentity rai = null;
            SecurityContext existingSC = this.getSecurityContext();
            if (existingSC != null) {
                rai = (RunAsIdentity)existingSC.getUtil().get(existingSC, "RunAsIdentity");
            }
            return rai;
        }

        public SecurityContext getSecurityContext() {
            return SecurityContextAssociation.getSecurityContext();
        }

        public void setSecurityContext(SecurityContext sc) {
            SecurityContextAssociation.setSecurityContext(sc);
        }

        public SecurityContext createSecurityContext(Principal p, Object cred, String sdomain) {
            return SecurityContextFactory.createSecurityContext(p, cred, null, sdomain);
        }
    };
    public static final SecurityActions PRIVILEGED = new SecurityActions(){
        private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

            public Object run() {
                return SecurityAssociation.getPrincipal();
            }
        };
        private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

            public Object run() {
                return SecurityAssociation.getCredential();
            }
        };
        private final PrivilegedAction getSecurityContextAction = new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };

        public Principal getPrincipal() {
            return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
        }

        public Object getCredential() {
            return AccessController.doPrivileged(this.getCredentialAction);
        }

        public RunAsIdentity getCallerRunAsIdentity() {
            return (RunAsIdentity)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    RunAsIdentity rai = null;
                    SecurityContext existingSC = this.getSecurityContext();
                    if (existingSC != null) {
                        rai = (RunAsIdentity)existingSC.getUtil().get(existingSC, "RunAsIdentity");
                    }
                    return rai;
                }
            });
        }

        public SecurityContext getSecurityContext() {
            return (SecurityContext)AccessController.doPrivileged(this.getSecurityContextAction);
        }

        public void setSecurityContext(final SecurityContext sc) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    SecurityContextAssociation.setSecurityContext(sc);
                    return null;
                }
            });
        }

        public SecurityContext createSecurityContext(final Principal p, final Object cred, final String sdomain) {
            return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return SecurityContextFactory.createSecurityContext(p, cred, null, sdomain);
                }
            });
        }
    };

    public Principal getPrincipal();

    public Object getCredential();

    public RunAsIdentity getCallerRunAsIdentity();

    public SecurityContext createSecurityContext(Principal var1, Object var2, String var3);

    public SecurityContext getSecurityContext();

    public void setSecurityContext(SecurityContext var1);

    public static class UTIL {
        static SecurityActions getSecurityActions() {
            return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
        }
    }
}

