/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.transporter.custom.server;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jboss.remoting.detection.jndi.JNDIDetector;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.samples.transporter.basic.CustomerProcessorImpl;
import org.jboss.remoting.transporter.InternalTransporterServices;
import org.jboss.remoting.transporter.TransporterServer;

public class SocketServer {
    public static String locatorURI = "socket://localhost:5400";
    private TransporterServer server = null;
    static /* synthetic */ Class class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor;

    public void start() throws Exception {
        this.initTransporterServices();
        Map config = this.getConnectorConfig();
        this.server = TransporterServer.createTransporterServer(this.getLocatorURI(), (Object)new CustomerProcessorImpl(), (class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor == null ? (class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor = SocketServer.class$("org.jboss.remoting.samples.transporter.basic.CustomerProcessor")) : class$org$jboss$remoting$samples$transporter$basic$CustomerProcessor).getName(), config, true);
    }

    private Map getConnectorConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("timeout", "5000");
        return config;
    }

    protected String getLocatorURI() {
        return locatorURI;
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private void initTransporterServices() throws Exception {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer();
        NetworkRegistry registry = NetworkRegistry.getInstance();
        String host = InetAddress.getLocalHost().getHostAddress();
        JNDIDetector jndiDetector = new JNDIDetector();
        jndiDetector.setPort(2410);
        jndiDetector.setHost(host);
        jndiDetector.setContextFactory("org.jnp.interfaces.NamingContextFactory");
        jndiDetector.setURLPackage("org.jboss.naming:org.jnp.interfaces");
        InternalTransporterServices transporterService = InternalTransporterServices.getInstance();
        transporterService.setup(mbeanServer, jndiDetector, new ObjectName("remoting:type=Detector,transport=jndi"), registry, new ObjectName("remoting:type=NetworkRegistry"), true, true);
        jndiDetector.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        SocketServer server = new SocketServer();
        try {
            server.start();
            Thread.currentThread();
            Thread.sleep(60000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            server.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

