/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvocationResponse;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.serialization.ClassLoaderUtility;
import org.jboss.remoting.transport.socket.LRUPool;
import org.jboss.remoting.transport.socket.SocketServerInvoker;
import org.jboss.remoting.transport.socket.SocketWrapper;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$socket$ServerThread == null ? (class$org$jboss$remoting$transport$socket$ServerThread = ServerThread.class$("org.jboss.remoting.transport.socket.ServerThread")) : class$org$jboss$remoting$transport$socket$ServerThread);
    private static boolean trace = log.isTraceEnabled();
    private static int idGenerator = 0;
    protected volatile boolean running = true;
    protected volatile boolean handlingResponse = true;
    protected volatile boolean shutdown;
    protected LRUPool clientpool;
    protected LinkedList threadpool;
    protected String serverSocketClassName;
    protected Class serverSocketClass;
    private Socket socket;
    private int timeout;
    protected SocketServerInvoker invoker;
    private Constructor serverSocketConstructor;
    protected SocketWrapper socketWrapper;
    protected Marshaller marshaller;
    protected UnMarshaller unmarshaller;
    private int id = Integer.MIN_VALUE;
    private boolean shouldCheckConnection;
    private long lastRequestHandledTimestamp = System.currentTimeMillis();
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerThread;
    static /* synthetic */ Class class$java$net$Socket;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized int nextID() {
        return idGenerator++;
    }

    public ServerThread(Socket socket, SocketServerInvoker invoker, LRUPool clientpool, LinkedList threadpool, int timeout, String serverSocketClassName) throws Exception {
        Map configMap;
        String checkValue;
        this.setName(this.getWorkerThreadName(socket));
        this.socket = socket;
        this.timeout = timeout;
        this.serverSocketClassName = serverSocketClassName;
        this.invoker = invoker;
        this.clientpool = clientpool;
        this.threadpool = threadpool;
        this.processNewSocket();
        if (invoker != null && (checkValue = (String)(configMap = invoker.getConfiguration()).get("socket.check_connection")) != null && checkValue.length() > 0) {
            this.shouldCheckConnection = Boolean.valueOf(checkValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                this.dorun();
                ServerThread serverThread = this;
                synchronized (serverThread) {
                    LRUPool lRUPool = this.clientpool;
                    synchronized (lRUPool) {
                        LinkedList linkedList = this.threadpool;
                        synchronized (linkedList) {
                            if (this.shutdown) {
                                this.invoker = null;
                                return;
                            }
                            if (trace) {
                                log.trace(this + " removing itself from clientpool and going to threadpool");
                            }
                            this.clientpool.remove(this);
                            this.threadpool.add(this);
                            Thread.interrupted();
                            this.clientpool.notify();
                        }
                    }
                    try {
                        if (trace) {
                            log.trace(this + " begins to wait");
                        }
                        this.wait();
                        if (trace) {
                            log.trace(this + " woke up after wait");
                        }
                    }
                    catch (InterruptedException e) {
                        if (this.shutdown) {
                            this.invoker = null;
                            return;
                        }
                        throw e;
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug(this + " exiting run on exception, definitively thrown out of the threadpool", e);
            return;
        }
    }

    public synchronized void wakeup(Socket socket, int timeout, SocketServerInvoker invoker) throws Exception {
        this.setName(this.getWorkerThreadName(socket));
        this.socket = socket;
        this.timeout = timeout;
        this.invoker = invoker;
        this.running = true;
        this.handlingResponse = true;
        this.processNewSocket();
        this.notify();
        if (trace) {
            log.trace(this + " has notified on mutex");
        }
    }

    public long getLastRequestTimestamp() {
        return this.lastRequestHandledTimestamp;
    }

    public void shutdown() {
        this.shutdown = true;
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void shouldCheckConnection(boolean checkConnection) {
        this.shouldCheckConnection = checkConnection;
    }

    public boolean getCheckingConnection() {
        return this.shouldCheckConnection;
    }

    public void evict() {
        this.running = false;
        if (!this.handlingResponse) {
            try {
                this.interrupt();
                Thread.interrupted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void unblock() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            log.warn("Error closing socket when attempting to unblock I/O", e);
        }
    }

    public String toString() {
        return this.getName();
    }

    protected void dorun() {
        if (trace) {
            log.trace("beginning dorun()");
        }
        this.running = true;
        this.handlingResponse = true;
        try {
            if (trace) {
                log.trace("creating the socket wrapper");
            }
            this.socketWrapper = this.createServerSocketWrapper(this.socket, this.timeout, this.invoker.getLocator().getParameters());
            if (trace) {
                log.trace("processing first invocation without acknowledging");
            }
            this.processInvocation(this.socketWrapper);
        }
        catch (Exception ex) {
            log.error("Worker thread initialization failure", ex);
            this.running = false;
        }
        while (this.running) {
            block24: {
                try {
                    this.acknowledge(this.socketWrapper);
                    this.processInvocation(this.socketWrapper);
                }
                catch (AcknowledgeFailure e) {
                    if (!this.shutdown && trace) {
                        log.trace("keep alive acknowledge failed!");
                    }
                    this.running = false;
                }
                catch (SocketTimeoutException ste) {
                    if (!this.shutdown && trace) {
                        log.trace(ste);
                    }
                    this.running = false;
                }
                catch (InterruptedIOException e) {
                    if (!this.shutdown) {
                        log.error("Socket IO interrupted", e);
                    }
                    this.running = false;
                }
                catch (InterruptedException e) {
                    if (trace) {
                        log.trace(e);
                    }
                    if (!this.shutdown) {
                        log.error("interrupted", e);
                    }
                }
                catch (EOFException eof) {
                    if (!this.shutdown && trace) {
                        log.trace("EOFException received. This is likely due to client finishing communication.", eof);
                    }
                    this.running = false;
                }
                catch (SocketException sex) {
                    if (!this.shutdown && trace) {
                        log.trace("SocketException received. This is likely due to client disconnecting and resetting connection.", sex);
                    }
                    this.running = false;
                }
                catch (Exception ex) {
                    if (this.shutdown) break block24;
                    log.error("failed", ex);
                    this.running = false;
                }
            }
            this.handlingResponse = false;
            Thread.interrupted();
        }
        try {
            if (this.socketWrapper != null) {
                log.debug(this + " closing socketWrapper: " + this.socketWrapper);
                this.socketWrapper.close();
            }
        }
        catch (Exception ex) {
            log.error("failed to close socket wrapper", ex);
        }
        this.socketWrapper = null;
    }

    protected void processInvocation(SocketWrapper socketWrapper) throws Exception {
        Object resp;
        boolean isError;
        boolean createdInvocationRequest;
        InvocationRequest req;
        boolean performVersioning;
        int version;
        block14: {
            if (trace) {
                log.trace("preparing to process next invocation invocation");
            }
            this.handlingResponse = true;
            version = Version.getDefaultVersion();
            performVersioning = Version.performVersioning();
            InputStream inputStream = socketWrapper.getInputStream();
            if (performVersioning && (version = this.readVersion(inputStream)) == -1) {
                version = 1;
            }
            Object obj = this.versionedRead(inputStream, this.invoker, this.getClass().getClassLoader(), version);
            this.lastRequestHandledTimestamp = System.currentTimeMillis();
            req = null;
            createdInvocationRequest = false;
            isError = false;
            if (obj instanceof InvocationRequest) {
                req = (InvocationRequest)obj;
            } else {
                req = this.createInvocationRequest(obj, socketWrapper);
                createdInvocationRequest = true;
                performVersioning = false;
            }
            resp = null;
            try {
                Thread.interrupted();
                if (trace) {
                    log.trace("about to call " + this.invoker + ".invoke()");
                }
                resp = this.invoker.invoke(req);
                if (trace) {
                    log.trace(this.invoker + ".invoke() returned " + resp);
                }
            }
            catch (Throwable ex) {
                resp = ex;
                isError = true;
                if (!trace) break block14;
                log.trace(this.invoker + ".invoke() call failed", ex);
            }
        }
        Thread.interrupted();
        if (this.isOneway(req.getRequestPayload())) {
            if (trace) {
                log.trace("oneway request, writing no reply on the wire");
            }
        } else {
            if (!createdInvocationRequest) {
                if (trace) {
                    log.trace("creating response instance");
                }
                resp = new InvocationResponse(req.getSessionId(), resp, isError, req.getReturnPayload());
            }
            OutputStream outputStream = socketWrapper.getOutputStream();
            if (performVersioning) {
                this.writeVersion(outputStream, version);
            }
            this.versionedWrite(outputStream, this.invoker, this.getClass().getClassLoader(), resp, version);
        }
        this.handlingResponse = false;
        this.lastRequestHandledTimestamp = System.currentTimeMillis();
    }

    protected void acknowledge(SocketWrapper socketWrapper) throws Exception {
        if (this.shouldCheckConnection) {
            this.handlingResponse = true;
            try {
                if (trace) {
                    log.trace("checking connection");
                }
                socketWrapper.checkConnection();
            }
            catch (EOFException e) {
                throw new AcknowledgeFailure();
            }
            catch (SocketException se) {
                throw new AcknowledgeFailure();
            }
            catch (IOException ioe) {
                throw new AcknowledgeFailure();
            }
            this.handlingResponse = false;
        }
    }

    protected Object versionedRead(InputStream inputStream, ServerInvoker invoker, ClassLoader classLoader, int version) throws IOException, ClassNotFoundException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                if (trace) {
                    log.trace("blocking to read invocation from unmarshaller");
                }
                Object o = this.unmarshaller.read(inputStream, null);
                if (trace) {
                    log.trace("read " + o + " from unmarshaller");
                }
                return o;
            }
        }
        throw new IOException("Can not read data for version " + version + ".  Supported versions: " + 1 + "," + 2 + "," + 22);
    }

    private SocketWrapper createServerSocketWrapper(Socket socket, int timeout, Map metadata) throws Exception {
        if (this.serverSocketConstructor == null) {
            if (this.serverSocketClass == null) {
                this.serverSocketClass = ClassLoaderUtility.loadClass(this.serverSocketClassName, this.getClass());
            }
            try {
                this.serverSocketConstructor = this.serverSocketClass.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket, class$java$util$Map == null ? (class$java$util$Map = ServerThread.class$("java.util.Map")) : class$java$util$Map, class$java$lang$Integer == null ? (class$java$lang$Integer = ServerThread.class$("java.lang.Integer")) : class$java$lang$Integer);
            }
            catch (NoSuchMethodException e) {
                this.serverSocketConstructor = this.serverSocketClass.getConstructor(class$java$net$Socket == null ? (class$java$net$Socket = ServerThread.class$("java.net.Socket")) : class$java$net$Socket);
            }
        }
        SocketWrapper serverSocketWrapper = null;
        if (this.serverSocketConstructor.getParameterTypes().length == 3) {
            HashMap<String, Serializable> localMetadata = null;
            localMetadata = metadata == null ? new HashMap<String, Serializable>(2) : new HashMap(metadata);
            localMetadata.put("marshaller", this.marshaller);
            localMetadata.put("unmarshaller", this.unmarshaller);
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket, localMetadata, new Integer(timeout));
        } else {
            serverSocketWrapper = (SocketWrapper)this.serverSocketConstructor.newInstance(socket);
            serverSocketWrapper.setTimeout(timeout);
        }
        return serverSocketWrapper;
    }

    private boolean isOneway(Map metadata) {
        Object val;
        boolean isOneway = false;
        if (metadata != null && (val = metadata.get("oneway")) != null && val instanceof String && Boolean.valueOf((String)val).booleanValue()) {
            isOneway = true;
        }
        return isOneway;
    }

    private InvocationRequest createInvocationRequest(Object obj, SocketWrapper socketWrapper) {
        if (obj instanceof InvocationRequest) {
            return (InvocationRequest)obj;
        }
        SocketAddress remoteAddress = socketWrapper.getSocket().getRemoteSocketAddress();
        return new InvocationRequest(remoteAddress.toString(), this.invoker.getSupportedSubsystems()[0], obj, null, null, null);
    }

    private void processNewSocket() {
        InvokerLocator locator = this.invoker.getLocator();
        ClassLoader classLoader = this.getClass().getClassLoader();
        String dataType = this.invoker.getDataType();
        String serializationType = this.invoker.getSerializationType();
        if (this.unmarshaller == null) {
            this.unmarshaller = MarshalFactory.getUnMarshaller(locator, classLoader);
        }
        if (this.unmarshaller == null) {
            this.unmarshaller = MarshalFactory.getUnMarshaller(dataType, serializationType);
        }
        if (this.marshaller == null) {
            this.marshaller = MarshalFactory.getMarshaller(locator, classLoader);
        }
        if (this.marshaller == null) {
            this.marshaller = MarshalFactory.getMarshaller(dataType, serializationType);
        }
    }

    private void versionedWrite(OutputStream outputStream, SocketServerInvoker invoker, ClassLoader classLoader, Object resp, int version) throws IOException {
        switch (version) {
            case 1: 
            case 2: 
            case 22: {
                this.marshaller.write(resp, outputStream);
                if (trace) {
                    log.trace("wrote response to the output stream");
                }
                return;
            }
        }
        throw new IOException("Can not write data for version " + version + ".  Supported version: " + 1 + ", " + 2 + ", " + 22);
    }

    private int readVersion(InputStream inputStream) throws IOException {
        if (trace) {
            log.trace("blocking to read version from input stream");
        }
        int version = inputStream.read();
        if (trace) {
            log.trace("read version " + version + " from input stream");
        }
        return version;
    }

    private void writeVersion(OutputStream outputStream, int version) throws IOException {
        outputStream.write(version);
    }

    private String getWorkerThreadName(Socket currentSocket) {
        if (this.id == Integer.MIN_VALUE) {
            this.id = ServerThread.nextID();
        }
        StringBuffer sb = new StringBuffer("WorkerThread#");
        sb.append(this.id).append('[');
        sb.append(currentSocket.getInetAddress().getHostAddress());
        sb.append(':');
        sb.append(currentSocket.getPort());
        sb.append(']');
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AcknowledgeFailure
    extends Exception {
    }
}

