/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.IncompleteDeploymentException;
import org.jboss.deployers.spi.IncompleteDeployments;
import org.jboss.deployers.spi.IncompleteDeploymentsBuilder;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.deployment.xml.BasicXMLDeployer;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.system.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileServiceBootstrap
extends BasicBootstrap {
    public static String BOOTSTRAP_XML_NAME = "bootstrap-beans.xml";
    protected String profileName;
    protected Server server;
    protected BasicXMLDeployer kernelDeployer;
    protected KernelController controller;
    protected MainDeployer mainDeployer;
    protected ProfileService profileService;
    protected String deployerBeansPrefix;
    protected URL bootstrapURL;

    public ProfileServiceBootstrap() {
        this("default", null);
    }

    public ProfileServiceBootstrap(String name, Server server) {
        this.profileName = name;
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public ProfileService getProfileService() {
        return this.profileService;
    }

    public BasicXMLDeployer getKernelDeployer() {
        return this.kernelDeployer;
    }

    public String getDeployerBeansPrefix() {
        return this.deployerBeansPrefix;
    }

    public void setDeployerBeansPrefix(String prefix) {
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        this.deployerBeansPrefix = prefix;
    }

    public URL getBootstrapURL() {
        return this.bootstrapURL;
    }

    public void setBootstrapURL(URL bootstrapURL) {
        this.bootstrapURL = bootstrapURL;
    }

    @Override
    public void bootstrap() throws Throwable {
        super.bootstrap();
        this.kernelDeployer = new BasicXMLDeployer(this.getKernel());
        if (this.bootstrapURL == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String bootstrapResName = this.deployerBeansPrefix == null ? this.profileName + "/" + BOOTSTRAP_XML_NAME : this.deployerBeansPrefix + BOOTSTRAP_XML_NAME;
            this.log.debug("Scanning for bootstrap resources: " + bootstrapResName);
            Enumeration<URL> descriptors = cl.getResources(bootstrapResName);
            while (descriptors.hasMoreElements()) {
                URL url = descriptors.nextElement();
                this.log.debug("Found: " + url);
                this.deploy(url);
            }
            String metaInfBootstrapResName = "META-INF/" + bootstrapResName;
            this.log.debug("Scanning for bootstrap resources: " + metaInfBootstrapResName);
            descriptors = cl.getResources(metaInfBootstrapResName);
            while (descriptors.hasMoreElements()) {
                URL url = descriptors.nextElement();
                this.log.debug("Found: " + url);
                this.deploy(url);
            }
        } else {
            this.deploy(this.bootstrapURL);
        }
        Kernel kernel = this.getKernel();
        this.controller = kernel.getController();
        if (this.server != null) {
            AbstractBeanMetaData metaData = new AbstractBeanMetaData("JBossServer", this.server.getClass().getName());
            this.controller.install(metaData, this.server);
        }
        this.checkIncomplete();
        this.profileService = this.getBean(this.controller, "ProfileService", ProfileService.class);
        this.log.debug("Using ProfileService: " + this.profileService);
        this.mainDeployer = this.getBean(this.controller, "MainDeployer", MainDeployer.class);
        this.log.debug("Using MainDeployer: " + this.mainDeployer);
        try {
            this.loadProfile(this.profileName);
        }
        catch (IncompleteDeploymentException e) {
            this.log.error("Failed to load profile: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error("Failed to load profile: ", e);
        }
        Profile profile = this.profileService.getActiveProfile();
        if (profile != null) {
            profile.enableModifiedDeploymentChecks(true);
        }
    }

    protected <T> T getBean(KernelController controller, Object name, Class<T> expectedType) {
        ControllerContext context = controller.getInstalledContext(name);
        if (context == null) {
            throw new IllegalStateException("Context not installed: " + name);
        }
        Object result = context.getTarget();
        if (result == null) {
            throw new IllegalStateException("No target for " + name);
        }
        if (!expectedType.isInstance(result)) {
            throw new IllegalStateException(name + " expected " + expectedType.getName() + " was " + result.getClass().getName());
        }
        return expectedType.cast(result);
    }

    protected void deploy(URL url) throws Throwable {
        this.log.debug("Deploying bootstrap config: " + url);
        this.kernelDeployer.deploy(url);
    }

    protected void undeploy(URL url) {
        try {
            this.log.debug("Undeploying bootstrap config: " + url);
            this.kernelDeployer.undeploy(url);
        }
        catch (Throwable t) {
            this.log.warn("Error during undeployment: " + url, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProfile(String name) throws Throwable {
        ClassLoader cl;
        MainDeployer deployer = this.getMainDeployer();
        if (deployer == null) {
            throw new NullPointerException("MainDeployer has not been set");
        }
        ProfileService ps = this.getProfileService();
        if (ps == null) {
            throw new NullPointerException("ProfileService has not been set");
        }
        ProfileKey key = new ProfileKey(name);
        Profile profile = ps.getProfile(key);
        DeploymentContext first = null;
        Collection<DeploymentContext> boostraps = profile.getDeployments(Profile.DeploymentPhase.BOOTSTRAP);
        for (DeploymentContext d : boostraps) {
            deployer.addDeploymentContext(d);
            if (first != null) continue;
            first = d;
        }
        deployer.process();
        this.checkIncomplete();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        ClassLoader classLoader = cl = first != null ? first.getClassLoader() : null;
        if (cl != null) {
            thread.setContextClassLoader(cl);
        }
        try {
            Collection<DeploymentContext> profileDeployers = profile.getDeployments(Profile.DeploymentPhase.DEPLOYER);
            for (DeploymentContext d : profileDeployers) {
                deployer.addDeploymentContext(d);
            }
            deployer.process();
            this.checkIncomplete();
            Collection<DeploymentContext> profileDeployments = profile.getDeployments(Profile.DeploymentPhase.APPLICATION);
            for (DeploymentContext d : profileDeployments) {
                deployer.addDeploymentContext(d);
            }
            deployer.process();
            this.checkIncomplete();
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    protected void checkIncomplete() throws DeploymentException {
        IncompleteDeployments incomplete = IncompleteDeploymentsBuilder.build(this.mainDeployer, this.controller);
        if (incomplete.isIncomplete()) {
            throw new IncompleteDeploymentException(incomplete);
        }
    }
}

