/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.ws.integration.UnifiedVirtualFile;

public class UnifiedDeploymentInfo {
    public DeploymentType type;
    public UnifiedDeploymentInfo parent;
    public String simpleName;
    public URL url;
    public UnifiedVirtualFile vfRoot;
    public String name;
    public URL webappURL;
    public Object metaData;
    public ClassLoader classLoader;
    public Map<String, Object> context = new HashMap<String, Object>();
    public ObjectName deployedObject;

    public UnifiedDeploymentInfo(DeploymentType type) {
        this.type = type;
    }

    public String getCanonicalName() {
        String name = this.simpleName;
        if (this.parent != null) {
            name = this.parent.getCanonicalName() + "/" + name;
        }
        return name;
    }

    public URL getMetaDataFileURL(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null && this.vfRoot != null) {
                UnifiedVirtualFile vfResource = this.vfRoot.findChild(resourcePath);
                resourceURL = vfResource.toURL();
            }
            if (resourceURL == null) {
                String deploymentPath = this.url.toExternalForm();
                if (deploymentPath.startsWith("jar:") && !deploymentPath.endsWith("!/")) {
                    deploymentPath = deploymentPath + "!/";
                }
                if (!deploymentPath.endsWith("/")) {
                    deploymentPath = deploymentPath + "/";
                }
                resourceURL = new URL(deploymentPath + resourcePath);
            }
        }
        return resourceURL;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append("type=" + (Object)((Object)this.type));
        builder.append(",simpleName=" + this.simpleName);
        builder.append(",url=" + this.url);
        builder.append("]");
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeploymentType {
        JAXRPC_Client,
        JAXRPC_JSE,
        JAXRPC_EJB21,
        JAXRPC_EJB3,
        JAXWS_JSE,
        JAXWS_EJB3;

    }
}

