/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.metadata.SimpleMetaData;

public class InstanceAdvisorDelegate
implements Serializable {
    private static final long serialVersionUID = -5421366346785427537L;
    protected transient WeakReference classAdvisor;
    InstanceAdvisor instanceAdvisor;
    protected transient WeakHashMap aspects;
    protected transient WeakHashMap joinpointAspects;
    protected SimpleMetaData metadata;

    public InstanceAdvisorDelegate(Advisor classAdvisor, InstanceAdvisor instanceAdvisor) {
        this.instanceAdvisor = instanceAdvisor;
        this.classAdvisor = new WeakReference<Advisor>(classAdvisor);
    }

    public Advisor getAdvisor() {
        if (this.classAdvisor != null) {
            return (Advisor)this.classAdvisor.get();
        }
        return null;
    }

    public void initialize() {
        this.initializeAspects();
        this.initializeJoinpointAspects();
    }

    private Advisor getClassAdvisor() {
        return this.getAdvisor();
    }

    private synchronized void initializeAspects() {
        if (this.getClassAdvisor() == null) {
            return;
        }
        if (this.aspects != null) {
            return;
        }
        Set defs = this.getClassAdvisor().getPerInstanceAspectDefinitions();
        if (this.instanceAdvisor instanceof Advisor) {
            Advisor ia = (Advisor)((Object)this.instanceAdvisor);
            Set instanceDefs = ia.getPerInstanceAspectDefinitions();
            defs.addAll(instanceDefs);
        }
        if (defs.size() > 0) {
            this.aspects = new WeakHashMap();
            for (AspectDefinition def : defs) {
                Object aspect = def.getFactory().createPerInstance(this.getClassAdvisor(), this.instanceAdvisor);
                this.aspects.put(def, aspect);
            }
        }
    }

    private synchronized void initializeJoinpointAspects() {
        if (this.getClassAdvisor() == null) {
            return;
        }
        if (this.joinpointAspects != null) {
            return;
        }
        Map jpAspects = this.getClassAdvisor().getPerInstanceJoinpointAspectDefinitions();
        if (this.instanceAdvisor instanceof Advisor) {
            Advisor ia = (Advisor)((Object)this.instanceAdvisor);
            Map instanceJpAspects = ia.getPerInstanceJoinpointAspectDefinitions();
            jpAspects.putAll(instanceJpAspects);
        }
        if (jpAspects.size() > 0) {
            this.joinpointAspects = new WeakHashMap();
            for (AspectDefinition def : jpAspects.keySet()) {
                ConcurrentReaderHashMap joins = new ConcurrentReaderHashMap();
                this.joinpointAspects.put(def, joins);
                Set joinpoints = (Set)jpAspects.get(def);
                for (Object joinpoint : joinpoints) {
                    joins.put(joinpoint, def.getFactory().createPerJoinpoint(this.getClassAdvisor(), this.instanceAdvisor, (Joinpoint)joinpoint));
                }
            }
        }
    }

    public Object getPerInstanceAspect(String def) {
        for (AspectDefinition d : this.aspects.keySet()) {
            if (!d.getName().equals(def)) continue;
            return this.aspects.get(d);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceAspect(AspectDefinition def) {
        if (this.aspects == null) {
            this.initializeAspects();
            return this.aspects.get(def);
        }
        Object aspect = this.aspects.get(def);
        if (aspect == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                aspect = this.aspects.get(def);
                if (aspect != null) {
                    return aspect;
                }
                if (this.classAdvisor != null && this.getClassAdvisor() instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.getClassAdvisor();
                    cadvisor.getPerInstanceAspectDefinitions().add(def);
                    aspect = def.getFactory().createPerInstance(null, null);
                    WeakHashMap copy = new WeakHashMap(this.aspects);
                    copy.put(def, aspect);
                    this.aspects = copy;
                }
            }
        }
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getPerInstanceJoinpointAspect(Joinpoint joinpoint, AspectDefinition def) {
        if (this.joinpointAspects == null) {
            this.initializeJoinpointAspects();
            return this.getJoinpointAspect(def, joinpoint);
        }
        Object aspect = this.getJoinpointAspect(def, joinpoint);
        if (aspect == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                aspect = this.getJoinpointAspect(def, joinpoint);
                if (aspect != null) {
                    return aspect;
                }
                if (this.classAdvisor != null && this.getClassAdvisor() instanceof ClassAdvisor) {
                    ClassAdvisor cadvisor = (ClassAdvisor)this.getClassAdvisor();
                    cadvisor.addPerInstanceJoinpointAspect(joinpoint, def);
                    aspect = def.getFactory().createPerJoinpoint(this.getClassAdvisor(), this.instanceAdvisor, joinpoint);
                    WeakHashMap copy = new WeakHashMap(this.joinpointAspects);
                    Map map = (Map)copy.get(def);
                    if (map == null) {
                        map = new ConcurrentReaderHashMap();
                    }
                    map.put(joinpoint, aspect);
                    this.joinpointAspects = copy;
                }
            }
        }
        return aspect;
    }

    private Object getJoinpointAspect(AspectDefinition def, Joinpoint joinpoint) {
        if (this.joinpointAspects == null) {
            return null;
        }
        Map map = (Map)this.joinpointAspects.get(def);
        Object aspect = map.get(joinpoint);
        return aspect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleMetaData getMetaData() {
        if (this.metadata == null) {
            InstanceAdvisorDelegate instanceAdvisorDelegate = this;
            synchronized (instanceAdvisorDelegate) {
                if (this.metadata == null) {
                    this.metadata = new SimpleMetaData();
                }
            }
        }
        return this.metadata;
    }
}

