/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.dispatch.AttributeDispatchContext;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class AbstractDependencyValueMetaData
extends AbstractValueMetaData {
    private static final long serialVersionUID = 2L;
    protected transient ControllerContext context;
    protected String property;
    protected ControllerState whenRequiredState;
    protected ControllerState dependentState = ControllerState.INSTALLED;

    public AbstractDependencyValueMetaData() {
    }

    public AbstractDependencyValueMetaData(Object value) {
        super(value);
    }

    public AbstractDependencyValueMetaData(Object value, String property) {
        super(value);
        this.property = property;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setWhenRequiredState(ControllerState whenRequiredState) {
        this.whenRequiredState = whenRequiredState;
        this.flushJBossObjectCache();
    }

    public ControllerState getWhenRequiredState() {
        return this.whenRequiredState;
    }

    public void setDependentState(ControllerState dependentState) {
        this.dependentState = dependentState;
        this.flushJBossObjectCache();
    }

    public ControllerState getDependentState() {
        return this.dependentState;
    }

    public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
        Controller controller;
        ControllerContext lookup;
        ControllerState state = this.dependentState;
        if (state == null) {
            state = ControllerState.INSTALLED;
        }
        if ((lookup = (controller = this.context.getController()).getContext(this.value, state)) == null) {
            throw new Error("Should not be here - dependency failed! " + this);
        }
        Object result = lookup.getTarget();
        if (this.property != null && lookup instanceof AttributeDispatchContext) {
            AttributeDispatchContext adc = (AttributeDispatchContext)((Object)lookup);
            result = adc.get(this.property);
        }
        return info != null ? info.convertValue(result) : result;
    }

    public void initialVisit(MetaDataVisitor visitor) {
        this.context = visitor.getControllerContext();
        Object name = this.context.getName();
        Object iDependOn = this.getUnderlyingValue();
        ControllerState whenRequired = this.whenRequiredState;
        if (whenRequired == null) {
            whenRequired = visitor.getContextState();
        }
        AbstractDependencyItem item = new AbstractDependencyItem(name, iDependOn, whenRequired, this.dependentState);
        visitor.addDependency(item);
        super.initialVisit(visitor);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        if (this.property != null) {
            buffer.append(" property=").append(this.property);
        }
        if (this.whenRequiredState != null) {
            buffer.append(" whenRequiredState=").append(this.whenRequiredState.getStateString());
        }
        if (this.dependentState != null) {
            buffer.append(" dependentState=").append(this.dependentState.getStateString());
        }
    }
}

