/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.plugins.AbstractFeatureMetaData;
import org.jboss.beans.metadata.plugins.builder.MutableParameterizedMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLifecycleMetaData
extends AbstractFeatureMetaData
implements LifecycleMetaData,
MutableParameterizedMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ControllerState state;
    protected String methodName;
    protected List<ParameterMetaData> parameters;
    protected String type;

    public AbstractLifecycleMetaData() {
    }

    public AbstractLifecycleMetaData(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public ControllerState getState() {
        return this.state;
    }

    @Override
    public void setState(ControllerState state) {
        this.state = state;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String name) {
        this.methodName = name;
        this.flushJBossObjectCache();
    }

    @Override
    public List<ParameterMetaData> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<ParameterMetaData> parameters) {
        this.parameters = parameters;
        this.flushJBossObjectCache();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        visitor.setContextState(this.state);
        super.initialVisit(visitor);
    }

    @Override
    protected void addChildren(Set<MetaDataVisitorNode> children) {
        super.addChildren(children);
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
    }

    @Override
    public Class getType(MetaDataVisitor visitor, MetaDataVisitorNode previous) throws Throwable {
        ParameterMetaData parameter = (ParameterMetaData)previous;
        KernelControllerContext context = visitor.getControllerContext();
        String method = this.methodName != null ? this.methodName : this.type;
        String[] parameterTypes = Configurator.getParameterTypes(false, this.parameters);
        MethodInfo methodInfo = Configurator.findMethodInfo(this.getClassInfo(context), method, parameterTypes);
        return this.applyCollectionOrMapCheck(methodInfo.getParameterTypes()[parameter.getIndex()].getType());
    }

    protected ClassInfo getClassInfo(KernelControllerContext context) throws Throwable {
        return context.getBeanInfo().getClassInfo();
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        if (this.methodName != null) {
            buffer.append("method=").append(this.methodName);
        }
        buffer.append(" parameters=");
        JBossObject.list(buffer, this.parameters);
        buffer.append(" ");
        super.toString(buffer);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.methodName);
    }
}

