/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.util.JBossObject;
import org.jboss.util.collection.CollectionsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractController
extends JBossObject
implements Controller {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected List<ControllerState> states = CollectionsFactory.createCopyOnWriteList();
    protected Map<Object, ControllerContext> allContexts = CollectionsFactory.createConcurrentReaderMap();
    protected Map<ControllerState, Set<ControllerContext>> contextsByState = CollectionsFactory.createConcurrentReaderMap();
    protected Map<Object, ControllerContext> errorContexts = CollectionsFactory.createConcurrentReaderMap();
    protected Set<ControllerContext> installing = CollectionsFactory.createCopyOnWriteSet();
    protected Set<Controller> childControllers = CollectionsFactory.createCopyOnWriteSet();
    protected boolean onDemandEnabled = true;

    public AbstractController() throws Exception {
        this.addState(ControllerState.NOT_INSTALLED, null);
        this.addState(ControllerState.PRE_INSTALL, null);
        this.addState(ControllerState.DESCRIBED, null);
        this.addState(ControllerState.INSTANTIATED, null);
        this.addState(ControllerState.CONFIGURED, null);
        this.addState(ControllerState.CREATE, null);
        this.addState(ControllerState.START, null);
        this.addState(ControllerState.INSTALLED, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addState(ControllerState state, ControllerState before) {
        this.lockWrite();
        try {
            if (before == null) {
                this.states.add(state);
            } else {
                int index = this.states.indexOf(before);
                if (index == -1) {
                    throw new IllegalStateException(before + " is not a state in the controller.");
                }
                this.states.add(index, state);
            }
            Set contexts = CollectionsFactory.createCopyOnWriteSet();
            this.contextsByState.put(state, contexts);
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public Set<Controller> getControllers() {
        return this.childControllers;
    }

    @Override
    public void addController(Controller controller) {
        this.childControllers.add(controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerContext getContext(Object name, ControllerState state) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.lockRead();
        try {
            ControllerContext result = this.allContexts.get(name);
            if (result != null && state != null) {
                int required = this.states.indexOf(state);
                if (required == -1) {
                    throw new IllegalArgumentException("Unknown state " + state + " states=" + this.states);
                }
                int current = this.states.indexOf(result.getState());
                if (current < required) {
                    ControllerContext controllerContext = null;
                    return controllerContext;
                }
            }
            ControllerContext controllerContext = result;
            return controllerContext;
        }
        finally {
            this.unlockRead();
        }
    }

    @Override
    public ControllerContext getInstalledContext(Object name) {
        return this.getContext(name, ControllerState.INSTALLED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ControllerContext> getNotInstalled() {
        this.lockWrite();
        try {
            HashSet<ControllerContext> result = new HashSet<ControllerContext>(this.errorContexts.values());
            int i = 0;
            while (!ControllerState.INSTALLED.equals(this.states.get(i))) {
                Set<ControllerContext> stateContexts = this.contextsByState.get(this.states.get(i));
                result.addAll(stateContexts);
                ++i;
            }
            HashSet<ControllerContext> hashSet = result;
            return hashSet;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public List<ControllerState> getStates() {
        return this.states;
    }

    @Override
    public void install(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        Object name = context.getName();
        if (name == null) {
            throw new IllegalArgumentException("Null name " + context.toShortString());
        }
        this.install(context, trace);
    }

    @Override
    public void change(ControllerContext context, ControllerState state) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (state == null) {
            throw new IllegalArgumentException("Null state");
        }
        this.change(context, state, trace);
    }

    @Override
    public void enableOnDemand(ControllerContext context) throws Throwable {
        boolean trace = this.log.isTraceEnabled();
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.enableOnDemand(context, trace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ControllerContext uninstall(Object name) {
        boolean trace = this.log.isTraceEnabled();
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.lockWrite();
        try {
            ControllerContext context;
            if (this.errorContexts.remove(name) != null && trace) {
                this.log.trace("Tidied up context in error state: " + name);
            }
            if ((context = this.allContexts.get(name)) == null) {
                throw new IllegalStateException("Not installed: " + name);
            }
            if (trace) {
                this.log.trace("Uninstalling " + context.toShortString());
            }
            this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
            this.allContexts.remove(name);
            ControllerContext controllerContext = context;
            return controllerContext;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(ControllerContext context, boolean trace) throws Throwable {
        block9: {
            this.lockWrite();
            try {
                Object name = context.getName();
                if (this.allContexts.get(name) != null) {
                    throw new IllegalStateException(name + " is already installed.");
                }
                if (ControllerMode.AUTOMATIC.equals(context.getMode())) {
                    context.setRequiredState(ControllerState.INSTALLED);
                }
                if (trace) {
                    this.log.trace("Installing " + context.toShortString());
                }
                context.setController(this);
                DependencyInfo dependencies = context.getDependencyInfo();
                if (trace) {
                    Set<DependencyItem> set;
                    String dependsOn = null;
                    if (dependencies != null && (set = dependencies.getIDependOn(null)) != null) {
                        dependsOn = set.toString();
                    }
                    this.log.trace("Dependencies for " + name + ": " + dependsOn);
                }
                if (this.incrementState(context, trace)) {
                    this.allContexts.put(context.getName(), context);
                    this.resolveContexts(trace);
                    break block9;
                }
                this.errorContexts.remove(context);
                throw context.getError();
            }
            finally {
                this.unlockWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void change(ControllerContext context, ControllerState state, boolean trace) throws Throwable {
        this.lockWrite();
        try {
            ControllerState fromState = context.getState();
            int currentIndex = this.states.indexOf(fromState);
            int requiredIndex = this.states.indexOf(state);
            if (requiredIndex == -1) {
                throw new IllegalArgumentException("Unknown state: " + state);
            }
            if (currentIndex == requiredIndex) {
                if (trace) {
                    this.log.trace("No change required toState=" + state.getStateString() + " " + context.toShortString());
                }
                return;
            }
            if (trace) {
                this.log.trace("Change toState=" + state.getStateString() + " " + context.toShortString());
            }
            context.setRequiredState(state);
            if (currentIndex < requiredIndex) {
                this.resolveContexts(trace);
            } else {
                while (currentIndex > requiredIndex) {
                    this.uninstallContext(context, trace);
                    currentIndex = this.states.indexOf(context.getState());
                }
            }
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableOnDemand(ControllerContext context, boolean trace) throws Throwable {
        this.lockWrite();
        try {
            if (!ControllerMode.ON_DEMAND.equals(context.getMode())) {
                throw new IllegalStateException("Context is not ON DEMAND: " + context.toShortString());
            }
            if (!this.allContexts.containsKey(context.getName())) {
                throw new IllegalStateException("Unknown context: " + context.toShortString());
            }
            if (ControllerState.INSTALLED.equals(context.getRequiredState())) {
                return;
            }
            context.setRequiredState(ControllerState.INSTALLED);
            if (trace) {
                this.log.trace("Enable onDemand: " + context.toShortString());
            }
            this.onDemandEnabled = true;
        }
        finally {
            this.unlockWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean incrementState(ControllerContext context, boolean trace) {
        ControllerState fromState = context.getState();
        Set<ControllerContext> fromContexts = null;
        int currentIndex = -1;
        if (ControllerState.ERROR.equals(fromState)) {
            this.errorContexts.remove(context);
            Throwable error = null;
            this.unlockWrite();
            try {
                this.install(context, ControllerState.ERROR, ControllerState.NOT_INSTALLED);
            }
            catch (Throwable t) {
                error = t;
                return (boolean)error;
            }
            finally {
                this.lockWrite();
                if (error != null) {
                    this.log.error("Error during initial installation: " + context.toShortString(), error);
                    context.setError(error);
                    this.errorContexts.put(context.getName(), context);
                    return false;
                }
            }
            Set<ControllerContext> notInstalled = this.contextsByState.get(ControllerState.NOT_INSTALLED);
            notInstalled.add(context);
            context.setState(ControllerState.NOT_INSTALLED);
        } else {
            currentIndex = this.states.indexOf(fromState);
            fromContexts = this.contextsByState.get(fromState);
            if (!fromContexts.contains(context)) {
                throw new IllegalStateException("Context not found in previous state: " + context.toShortString());
            }
        }
        int toIndex = currentIndex + 1;
        ControllerState toState = this.states.get(toIndex);
        Set<ControllerContext> toContexts = this.contextsByState.get(toState);
        this.unlockWrite();
        Throwable error = null;
        try {
            this.install(context, fromState, toState);
        }
        catch (Throwable t) {
            error = t;
            return (boolean)error;
        }
        finally {
            this.lockWrite();
            if (error != null) {
                this.log.error("Error installing to " + toState.getStateString() + ": " + context.toShortString(), error);
                this.uninstallContext(context, ControllerState.NOT_INSTALLED, trace);
                this.errorContexts.put(context.getName(), context);
                context.setError(error);
                return false;
            }
        }
        if (fromContexts != null) {
            fromContexts.remove(context);
        }
        toContexts.add(context);
        context.setState(toState);
        return true;
    }

    protected void resolveContexts(boolean trace) {
        int i;
        boolean resolutions = true;
        block0: while (resolutions || this.onDemandEnabled) {
            this.onDemandEnabled = false;
            resolutions = false;
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState toState;
                ControllerState fromState = this.states.get(i);
                if (!this.resolveContexts(fromState, toState = this.states.get(i + 1), trace)) continue;
                resolutions = true;
                continue block0;
            }
        }
        if (trace) {
            for (i = 0; i < this.states.size() - 1; ++i) {
                ControllerState state = this.states.get(i);
                ControllerState nextState = this.states.get(i + 1);
                Set<ControllerContext> stillUnresolved = this.contextsByState.get(state);
                if (stillUnresolved.isEmpty()) continue;
                for (ControllerContext ctx : stillUnresolved) {
                    if (!this.advance(ctx)) continue;
                    this.log.trace("Still unresolved " + nextState.getStateString() + ": " + ctx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resolveContexts(ControllerState fromState, ControllerState toState, boolean trace) {
        boolean resolutions = false;
        Set<ControllerContext> unresolved = this.contextsByState.get(fromState);
        Set<ControllerContext> resolved = this.resolveContexts(unresolved, toState, trace);
        if (!resolved.isEmpty()) {
            for (ControllerContext context : resolved) {
                Object name = context.getName();
                if (!fromState.equals(context.getState())) {
                    if (!trace) continue;
                    this.log.trace("Skipping already installed " + name + " for " + toState.getStateString());
                    continue;
                }
                if (!this.installing.add(context)) {
                    if (!trace) continue;
                    this.log.trace("Already installing " + name + " for " + toState.getStateString());
                    continue;
                }
                try {
                    if (trace) {
                        this.log.trace("Dependencies resolved " + name + " for " + toState.getStateString());
                    }
                    if (!this.incrementState(context, trace)) continue;
                    resolutions = true;
                    if (!trace) continue;
                    this.log.trace(name + " " + toState.getStateString());
                }
                finally {
                    this.installing.remove(context);
                }
            }
        }
        return resolutions;
    }

    protected Set<ControllerContext> resolveContexts(Set<ControllerContext> contexts, ControllerState state, boolean trace) {
        HashSet<ControllerContext> result = new HashSet<ControllerContext>();
        if (!contexts.isEmpty()) {
            for (ControllerContext ctx : contexts) {
                DependencyInfo dependencies;
                if (!this.advance(ctx) || !(dependencies = ctx.getDependencyInfo()).resolveDependencies(this, state)) continue;
                result.add(ctx);
            }
        }
        return result;
    }

    protected void uninstallContext(ControllerContext context, ControllerState toState, boolean trace) {
        int targetState = this.states.indexOf(toState);
        if (targetState == -1) {
            this.log.error("INTERNAL ERROR: unknown state " + toState + " states=" + this.states, new Exception("STACKTRACE"));
        }
        ControllerState fromState;
        while (!ControllerState.ERROR.equals(fromState = context.getState())) {
            int currentState = this.states.indexOf(fromState);
            if (currentState == -1) {
                this.log.error("INTERNAL ERROR: current state not found: " + context.toShortString(), new Exception("STACKTRACE"));
            }
            if (targetState > currentState) {
                return;
            }
            this.uninstallContext(context, trace);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uninstallContext(ControllerContext context, boolean trace) {
        int toIndex;
        Set<ControllerContext> fromContexts;
        Object name = context.getName();
        ControllerState fromState = context.getState();
        int currentIndex = this.states.indexOf(fromState);
        if (trace) {
            this.log.trace("Uninstalling " + name + " from " + fromState.getStateString());
        }
        if ((fromContexts = this.contextsByState.get(fromState)) == null || !fromContexts.remove(context)) {
            throw new Error("INTERNAL ERROR: context not found in previous state " + fromState.getStateString() + " context=" + context.toShortString(), new Exception("STACKTRACE"));
        }
        DependencyInfo dependencies = context.getDependencyInfo();
        Set<DependencyItem> dependsOnMe = dependencies.getDependsOnMe(null);
        if (!dependsOnMe.isEmpty()) {
            for (DependencyItem item : dependsOnMe) {
                int actual;
                int proposed;
                ControllerState dependentState;
                if (!item.isResolved() || (dependentState = item.getDependentState()) != null && !dependentState.equals(fromState)) continue;
                item.unresolved(this);
                ControllerContext dependent = this.getContext(item.getName(), null);
                if (dependent == null) continue;
                ControllerState whenRequired = item.getWhenRequired();
                if (whenRequired == null) {
                    whenRequired = ControllerState.NOT_INSTALLED;
                }
                if ((proposed = this.states.indexOf(whenRequired)) > (actual = this.states.indexOf(dependent.getState()))) continue;
                this.uninstallContext(dependent, whenRequired, trace);
            }
        }
        if ((toIndex = currentIndex - 1) == -1) {
            context.setError(new IllegalStateException("Cannot uninstall from " + fromState));
            return;
        }
        ControllerState toState = this.states.get(toIndex);
        Set<ControllerContext> toContexts = this.contextsByState.get(toState);
        toContexts.add(context);
        context.setState(toState);
        this.unlockWrite();
        try {
            this.uninstall(context, fromState, toState);
        }
        catch (Throwable t) {
            this.log.warn("Error uninstalling from " + fromState.getStateString() + ": " + context.toShortString(), t);
        }
        finally {
            this.lockWrite();
        }
    }

    protected void install(ControllerContext context, ControllerState fromState, ControllerState toState) throws Throwable {
        context.install(fromState, toState);
    }

    protected void uninstall(ControllerContext context, ControllerState fromState, ControllerState toState) {
        context.uninstall(fromState, toState);
    }

    protected boolean advance(ControllerContext context) {
        ControllerState requiredState;
        int requiredIndex;
        ControllerMode mode = context.getMode();
        if (ControllerMode.DISABLED.equals(mode)) {
            return false;
        }
        ControllerState fromState = context.getState();
        int fromIndex = this.states.indexOf(fromState);
        return fromIndex < (requiredIndex = this.states.indexOf(requiredState = context.getRequiredState()));
    }

    protected void lockRead() {
        this.lock.readLock().lock();
    }

    protected void unlockRead() {
        this.lock.readLock().unlock();
    }

    protected void lockWrite() {
        this.lock.writeLock().lock();
    }

    protected void unlockWrite() {
        this.lock.writeLock().unlock();
    }
}

