/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.net.URL;
import org.jboss.deployers.plugins.deployers.helpers.AbstractParsingDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectModelFactoryDeployer<T>
extends AbstractParsingDeployer<T> {
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private boolean useSchemaValidation = true;
    private boolean useValidation = true;

    public ObjectModelFactoryDeployer(Class<T> deploymentType) {
        super(deploymentType);
    }

    public boolean isUseSchemaValidation() {
        return this.useSchemaValidation;
    }

    public void setUseSchemaValidation(boolean useSchemaValidation) {
        this.useSchemaValidation = useSchemaValidation;
    }

    public boolean isUseValidation() {
        return this.useValidation;
    }

    public void setUseValidation(boolean useValidation) {
        this.useValidation = useValidation;
    }

    @Override
    protected T parse(DeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        unmarshaller.setSchemaValidation(this.useSchemaValidation);
        unmarshaller.setValidation(this.useValidation);
        Object parsed = null;
        try {
            ObjectModelFactory factory = this.getObjectModelFactory(root);
            URL url = file.toURL();
            parsed = unmarshaller.unmarshal(url.toString(), factory, root);
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error parsing meta data " + file.getPathName(), t);
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        return this.getDeploymentType().cast(parsed);
    }

    protected abstract ObjectModelFactory getObjectModelFactory(T var1);
}

