/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.scanner;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.deployers.plugins.structure.AbstractDeploymentContext;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSDeploymentScannerImpl
implements Runnable {
    private static final Logger log = Logger.getLogger(VFSDeploymentScannerImpl.class);
    private MainDeployer mainDeployer;
    private VirtualFileFilter filter;
    private ScheduledExecutorService scanExecutor;
    private ScheduledFuture activeScan;
    private URI serverHomeURI;
    private List<URI> uriList = Collections.synchronizedList(new ArrayList());
    private List<VirtualFile> vdfList = Collections.synchronizedList(new ArrayList());
    private boolean doRecursiveSearch = true;
    private long scanPeriod = 5000L;
    private int scanCount;
    private Map<VirtualFile, DeploymentContext> deployedMap = new ConcurrentHashMap<VirtualFile, DeploymentContext>();

    public void setMainDeployer(MainDeployer deployer) {
        this.mainDeployer = deployer;
    }

    public VirtualFileFilter getFilterInstance() {
        return this.filter;
    }

    public void setFilterInstance(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public ScheduledExecutorService getScanExecutor() {
        return this.scanExecutor;
    }

    public void setScanExecutor(ScheduledExecutorService scanExecutor) {
        this.scanExecutor = scanExecutor;
    }

    public long getScanPeriod() {
        return this.scanPeriod;
    }

    public void setScanPeriod(long period) {
        this.scanPeriod = period;
    }

    public boolean isScanEnabled() {
        return this.activeScan != null;
    }

    public synchronized int getScanCount() {
        return this.scanCount;
    }

    public synchronized void resetScanCount() {
        this.scanCount = 0;
    }

    public synchronized void setScanEnabled(boolean scanEnabled) {
        if (scanEnabled && this.activeScan == null) {
            this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
        } else if (!scanEnabled && this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    public void setURIs(String listspec) throws URISyntaxException, IOException {
        if (listspec == null) {
            this.uriList.clear();
            return;
        }
        LinkedList<URI> list2 = new LinkedList<URI>();
        StringTokenizer stok = new StringTokenizer(listspec, ",");
        while (stok.hasMoreTokens()) {
            String urispec = stok.nextToken().trim();
            log.debug("Adding URI from spec: " + urispec);
            URI uri = this.makeURI(urispec);
            log.debug("URI: " + uri);
            list2.add(uri);
        }
        this.setURIList(list2);
    }

    public void setURIList(List<URI> list2) throws IOException {
        if (list2 == null) {
            return;
        }
        this.uriList.clear();
        for (int n = 0; n < list2.size(); ++n) {
            URI uri = list2.get(n);
            if (uri == null) {
                throw new IllegalArgumentException("list element[" + n + "] is null");
            }
            this.addURI(uri);
        }
        log.debug("URI list: " + this.uriList);
    }

    public List<URI> getURIList() {
        return new ArrayList<URI>(this.uriList);
    }

    public void setRecursiveSearch(boolean recurse) {
        this.doRecursiveSearch = recurse;
    }

    public boolean getRecursiveSearch() {
        return this.doRecursiveSearch;
    }

    public void addURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        if (this.uriList.add(uri)) {
            log.debug("Added URI: " + uri);
            VirtualFile vf = VFS.getRoot(uri);
            this.vdfList.add(vf);
        }
    }

    public void removeURI(URI uri) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        VirtualFile vf = VFS.getRoot(uri);
        this.vdfList.remove(vf);
        boolean success = this.uriList.remove(uri);
        if (success) {
            log.debug("Removed URI: " + uri);
        }
    }

    public boolean hasURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri argument cannot be null");
        }
        return this.uriList.contains(uri);
    }

    public void start() throws Exception {
        this.vdfList.clear();
        for (URI uri : this.uriList) {
            VirtualFile vf = VFS.getRoot(uri);
            this.vdfList.add(vf);
        }
        if (this.scanExecutor == null) {
            this.scanExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    return new Thread(r, "VFSDeploymentScanner");
                }
            });
        }
        this.activeScan = this.scanExecutor.scheduleWithFixedDelay(this, 0L, this.scanPeriod, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.scan();
        }
        catch (Throwable e) {
            log.warn("Scan failed", e);
        }
        finally {
            this.incScanCount();
        }
    }

    public void stop() {
        if (this.activeScan != null) {
            this.activeScan.cancel(true);
            this.activeScan = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() throws Exception {
        int i;
        VirtualFile vf2;
        if (this.vdfList == null) {
            throw new IllegalStateException("not initialized");
        }
        boolean trace = log.isTraceEnabled();
        log.debug("Begin deployment scan");
        LinkedList<VirtualFile> toDeployList = new LinkedList<VirtualFile>();
        List<VirtualFile> list2 = this.vdfList;
        synchronized (list2) {
            for (VirtualFile virtualFile : this.vdfList) {
                if (trace) {
                    log.trace("Checking file: " + virtualFile);
                }
                if (virtualFile.isLeaf()) {
                    toDeployList.add(virtualFile);
                    continue;
                }
                this.addDeployments(toDeployList, virtualFile);
            }
        }
        if (trace) {
            log.trace("toDeployList: " + toDeployList);
        }
        LinkedList<VirtualFile> toRemoveList = new LinkedList<VirtualFile>();
        LinkedList<VirtualFile> toCheckForUpdateList = new LinkedList<VirtualFile>();
        Map<VirtualFile, DeploymentContext> map = this.deployedMap;
        synchronized (map) {
            for (VirtualFile vf3 : this.deployedMap.keySet()) {
                if (toDeployList.contains(vf3)) {
                    toCheckForUpdateList.add(vf3);
                    continue;
                }
                toRemoveList.add(vf3);
            }
        }
        for (VirtualFile vf4 : toRemoveList) {
            this.undeploy(vf4);
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(toCheckForUpdateList.size());
        for (VirtualFile vf2 : arrayList) {
            DeploymentContext context = this.deployedMap.get(vf2);
            long modified = vf2.getLastModified();
            Long prevLastDeployed = context.getTransientAttachments().getAttachment("deployedLastModified", Long.class);
            if (prevLastDeployed == null || prevLastDeployed.compareTo(modified) >= 0) continue;
            if (trace) {
                log.trace("Re-deploying " + vf2);
            }
            arrayList.add(vf2);
        }
        for (i = arrayList.size() - 1; i >= 0; --i) {
            vf2 = (VirtualFile)arrayList.get(i);
            this.undeploy(vf2);
        }
        for (i = 0; i < arrayList.size(); ++i) {
            vf2 = (VirtualFile)arrayList.get(i);
            this.deploy(vf2);
        }
        Iterator i2 = toDeployList.iterator();
        while (i2.hasNext()) {
            vf2 = (VirtualFile)i2.next();
            if (!this.deployedMap.containsKey(vf2)) {
                this.deploy(vf2);
            }
            i2.remove();
        }
        log.debug("End deployment scan");
    }

    protected synchronized void incScanCount() {
        ++this.scanCount;
        this.notifyAll();
    }

    private URI makeURI(String urispec) throws URISyntaxException {
        urispec = StringPropertyReplacer.replaceProperties(urispec);
        return this.serverHomeURI.resolve(urispec);
    }

    private void addDeployments(List<VirtualFile> list2, VirtualFile root) throws IOException {
        List<VirtualFile> components = root.getChildren();
        for (VirtualFile vf : components) {
            if (vf.isLeaf()) {
                if (this.filter != null && !this.filter.accepts(vf)) continue;
                list2.add(vf);
                continue;
            }
            if (vf.getName().indexOf(46) == -1 && this.doRecursiveSearch) {
                this.addDeployments(list2, vf);
                continue;
            }
            list2.add(vf);
        }
    }

    private void deploy(VirtualFile vf) {
        log.debug("Deploying: " + vf);
        AbstractDeploymentContext context = new AbstractDeploymentContext(vf);
        try {
            this.mainDeployer.addDeploymentContext(context);
            this.mainDeployer.process();
        }
        catch (Exception e) {
            log.warn("Failed to deploy: " + vf, e);
            return;
        }
        try {
            long deployedLastModified = vf.getLastModified();
            context.getTransientAttachments().addAttachment("deployedLastModified", (Object)deployedLastModified);
            if (!this.deployedMap.containsKey(vf)) {
                this.deployedMap.put(vf, context);
            }
        }
        catch (IOException e) {
            log.warn("Failed to obtain lastModified for: " + vf, e);
        }
    }

    private void undeploy(VirtualFile vf) {
        try {
            log.debug("Undeploying: " + vf);
            DeploymentContext deployment = this.deployedMap.remove(vf);
            this.mainDeployer.removeDeploymentContext(deployment.getName());
        }
        catch (Exception e) {
            log.error("Failed to undeploy: " + vf, e);
        }
    }
}

