/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.deployers.plugins.structure.AbstractDeploymentContext;
import org.jboss.deployers.plugins.structure.SecurityActions;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployers.spi.structure.vfs.ClassPathInfo;
import org.jboss.deployers.spi.structure.vfs.ContextInfo;
import org.jboss.deployers.spi.structure.vfs.StructureBuilder;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultStructureBuilder
implements StructureBuilder {
    private static Logger log = Logger.getLogger(DefaultStructureBuilder.class);

    @Override
    public void populateContext(DeploymentContext context, StructureMetaData metaData) throws DeploymentException {
        HashMap<String, DeploymentContext> contextMap = new HashMap<String, DeploymentContext>();
        VirtualFile root = context.getRoot();
        ContextInfo rootInfo = metaData.getContext(root.getPathName());
        if (rootInfo == null) {
            throw new DeploymentException("Failed to find ContextInfo for context root: " + root);
        }
        VFS vfs = root.getVFS();
        contextMap.put(root.getPathName(), context);
        try {
            for (ContextInfo info : metaData.getContexts()) {
                String vfsPath = info.getVfsPath();
                VirtualFile vf = vfs.findChild(vfsPath);
                ContextInfo parentInfo = info.getParent();
                String parentPath = parentInfo != null ? parentInfo.getVfsPath() : "";
                DeploymentContext ctx = (DeploymentContext)contextMap.get(vfsPath);
                DeploymentContext parent = (DeploymentContext)contextMap.get(parentPath);
                if (ctx == null) {
                    if (parent != null) {
                        ctx = new AbstractDeploymentContext(vf, true, parent);
                        parent.addChild(ctx);
                    } else {
                        ctx = new AbstractDeploymentContext(vf);
                    }
                }
                this.processContext(ctx, vf, info, contextMap);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to process context: " + context.getName(), e);
        }
        contextMap.clear();
    }

    protected void processContext(DeploymentContext context, VirtualFile virtualFile, ContextInfo info, HashMap<String, DeploymentContext> contextMap) {
        String metaDataPath;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Processing context: " + context + ", info: " + info);
        }
        if ((metaDataPath = info.getMetaDataPath()) != null && metaDataPath.length() > 0) {
            context.setMetaDataPath(metaDataPath);
        }
        ArrayList<VirtualFile> paths = new ArrayList<VirtualFile>();
        List<ClassPathInfo> classPath = info.getClassPath();
        boolean classPathHadVF = false;
        if (classPath != null) {
            for (ClassPathInfo cp : classPath) {
                try {
                    VirtualFile child = virtualFile.findChild(cp.getPath());
                    String suffixesOpt = (String)cp.getOption("suffixes");
                    String[] suffixes = null;
                    if (suffixesOpt != null) {
                        suffixes = suffixesOpt.split(",");
                    }
                    if (suffixes == null || suffixes.length == 0) {
                        paths.add(child);
                        if (!classPathHadVF) {
                            classPathHadVF = child.equals(virtualFile);
                        }
                        if (trace) {
                            log.trace("Added simple classpath entry: " + child);
                        }
                        VFSUtils.addManifestLocations(child, paths);
                        continue;
                    }
                    SuffixMatchFilter filter = new SuffixMatchFilter(Arrays.asList(suffixes), VisitorAttributes.DEFAULT);
                    List<VirtualFile> matches = child.getChildren(filter);
                    if (matches == null) continue;
                    paths.addAll(matches);
                    if (trace) {
                        log.trace("Added classpath matches: " + matches);
                    }
                    for (VirtualFile file : matches) {
                        VFSUtils.addManifestLocations(file, paths);
                        if (classPathHadVF) continue;
                        classPathHadVF = child.equals(virtualFile);
                    }
                }
                catch (IOException e) {
                    log.debug("Failed to find cp element: " + cp + ", " + e.getMessage());
                }
            }
        }
        if (!classPathHadVF) {
            try {
                if (!SecurityActions.isLeaf(virtualFile)) {
                    VFSUtils.addManifestLocations(virtualFile, paths);
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (paths.size() > 0) {
            context.setClassPath(paths);
        }
        contextMap.put(virtualFile.getPathName(), context);
    }
}

